//  ன:   writeable

class TTrigwDevice: public TBaseDevice {
  public:
    TRef           Sinp;
    TRef           Rinp;
    unsigned char  _oper_mark_1;
    unsigned char  Output;
    unsigned char  _oper_mark_2;
    TTrigwDevice(unsigned char* PFatalError);
    void Set(unsigned char num, unsigned int val);
    unsigned int Get(unsigned char num);
    void Work();
    char* GetDevType(void);
    ~TTrigwDevice();
};

//===== implementation =====

// 
TTrigwDevice::TTrigwDevice(unsigned char* PFatalError) {

  *PFatalError = 0;
  Sinp.Addr  = ReadInt();
  Sinp.Num   = ReadChar();
  Rinp.Addr  = ReadInt();
  Rinp.Num   = ReadChar();
  Output     = 0;

  OperData1 = &_oper_mark_1;
  OperData2 = &_oper_mark_2;
}


//  
void TTrigwDevice::Set(unsigned char num, unsigned int val) {
  if (num==0) Output = val;
};


//  
unsigned int TTrigwDevice::Get(unsigned char) {
  return (unsigned int)Output;
};


//  
void TTrigwDevice::Work() {

  if (GetData(Rinp.Addr, Rinp.Num)) Output=0;
  else if (GetData(Sinp.Addr, Sinp.Num)) Output=1;

};


// 
TTrigwDevice::~TTrigwDevice() {
};





char* TTrigwDevice::GetDevType(void) {
  return "TRIGW";
}