/*
 * Decompiled with CFR 0.152.
 */
package promauto.jroboplc.core;

import java.net.URL;
import java.nio.file.Paths;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.log4j.helpers.LogLog;
import org.apache.log4j.xml.DOMConfigurator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import promauto.jroboplc.core.ConfigurationYaml;
import promauto.jroboplc.core.ConsoleDaemon;
import promauto.jroboplc.core.ConsoleInteract;
import promauto.jroboplc.core.ConsoleManagerImpl;
import promauto.jroboplc.core.EnvironmentImpl;
import promauto.jroboplc.core.LoggerMode;
import promauto.jroboplc.core.ModuleManagerImpl;
import promauto.jroboplc.core.SerialManagerStub;
import promauto.jroboplc.core.TaskManagerImpl;
import promauto.jroboplc.core.TcpServerStub;
import promauto.jroboplc.core.Version;
import promauto.jroboplc.core.api.Configuration;
import promauto.jroboplc.core.api.EnvironmentInst;
import promauto.jroboplc.core.cmd.CmdAnsi;
import promauto.jroboplc.core.cmd.CmdAppName;
import promauto.jroboplc.core.cmd.CmdAppend;
import promauto.jroboplc.core.cmd.CmdCheck;
import promauto.jroboplc.core.cmd.CmdDispatcherImpl;
import promauto.jroboplc.core.cmd.CmdGc;
import promauto.jroboplc.core.cmd.CmdHelp;
import promauto.jroboplc.core.cmd.CmdKeygen;
import promauto.jroboplc.core.cmd.CmdList;
import promauto.jroboplc.core.cmd.CmdListAgain;
import promauto.jroboplc.core.cmd.CmdListBack;
import promauto.jroboplc.core.cmd.CmdListFwd;
import promauto.jroboplc.core.cmd.CmdModinfo;
import promauto.jroboplc.core.cmd.CmdQuit;
import promauto.jroboplc.core.cmd.CmdReload;
import promauto.jroboplc.core.cmd.CmdRemove;
import promauto.jroboplc.core.cmd.CmdRepeat;
import promauto.jroboplc.core.cmd.CmdSettag;
import promauto.jroboplc.core.cmd.CmdStart;
import promauto.jroboplc.core.cmd.CmdState;
import promauto.jroboplc.core.cmd.CmdStop;
import promauto.jroboplc.core.cmd.CmdStx;
import promauto.jroboplc.core.cmd.CmdSusp;
import promauto.jroboplc.core.cmd.CmdTaglist;
import promauto.jroboplc.core.cmd.CmdVersion;

public class JRoboPLC {
    final Logger logger = LoggerFactory.getLogger(JRoboPLC.class);
    private EnvironmentImpl env;
    private static final String LOGGER_CONF = "/logger.xml";
    private static final String DEFAULT_LOGDIR = "log";
    private String plugDir = "jar/plugin";
    private String confDir = "conf";
    private boolean quiet = false;
    private String startCommands = "";

    private boolean parseCommandLine(String[] args) {
        Options options = new Options();
        options.addOption("cfg", true, "configuration directory, default is '" + this.confDir + "'");
        options.addOption("plg", true, "plugins directory, default is '" + this.plugDir + "'");
        options.addOption("cmd", true, "start up commands ('|' - separator)");
        options.addOption("quiet", false, "disable output and interactive console");
        try {
            DefaultParser parser = new DefaultParser();
            CommandLine cmd = parser.parse(options, args);
            this.plugDir = cmd.hasOption("plg") ? cmd.getOptionValue("plg") : this.plugDir;
            this.confDir = cmd.hasOption("cfg") ? cmd.getOptionValue("cfg") : this.confDir;
            this.startCommands = cmd.hasOption("cmd") ? cmd.getOptionValue("cmd") : this.startCommands;
            this.quiet = cmd.hasOption("quiet");
            return true;
        }
        catch (ParseException e) {
            new HelpFormatter().printHelp("jroboplc", options);
            return false;
        }
    }

    private boolean initialize() {
        this.env = new EnvironmentImpl();
        EnvironmentInst.set(this.env);
        ConfigurationYaml conf = new ConfigurationYaml(this.confDir);
        if (!conf.load()) {
            return false;
        }
        this.env.setConfiguration(conf);
        if (!this.setupLogger()) {
            return false;
        }
        this.env.logStatus(this.logger, "*** INIT v" + Version.getVersionStr() + " ***");
        this.env.setConsoleManager(new ConsoleManagerImpl());
        if (this.quiet) {
            this.env.setConsole(new ConsoleDaemon());
        } else {
            this.env.setConsole(new ConsoleInteract(this.env));
        }
        this.env.getConsole().print("JRoboPLC v" + Version.getVersionStr() + " loading...\r\n");
        this.env.setCmdDispatcher(new CmdDispatcherImpl());
        this.env.setTaskManager(new TaskManagerImpl(this.env));
        this.addGlobalCommands();
        this.env.setModuleManager(new ModuleManagerImpl());
        boolean result = this.env.getModuleManager().loadModules();
        if (this.env.getSerialManager() == null) {
            this.env.setSerialManager(new SerialManagerStub());
        }
        if (this.env.getTcpServer() == null) {
            this.env.setTcpServer(new TcpServerStub());
        }
        if (!result) {
            this.env.getConsole().print("Fatal configuration error!\r\n");
        }
        this.attachShutDownHook();
        return result;
    }

    private boolean setupLogger() {
        Configuration cm = this.env.getConfiguration();
        String logdir = cm.getPath(cm.getRoot(), "log.dir", DEFAULT_LOGDIR).resolve(Paths.get(this.confDir, new String[0]).getFileName()).toString();
        System.setProperty("jroboplc.logdir", logdir);
        LogLog.setQuietMode((boolean)true);
        URL resourceUrl = this.getClass().getResource(LOGGER_CONF);
        DOMConfigurator.configure((URL)resourceUrl);
        LogLog.setQuietMode((boolean)false);
        this.env.setLoggerMode(new LoggerMode());
        return this.env.getLoggerMode().isOk();
    }

    private void addGlobalCommands() {
        this.env.getCmdDispatcher().addCommand(CmdQuit.class);
        this.env.getCmdDispatcher().addCommand(CmdHelp.class);
        this.env.getCmdDispatcher().addCommand(CmdStart.class);
        this.env.getCmdDispatcher().addCommand(CmdStop.class);
        this.env.getCmdDispatcher().addCommand(CmdTaglist.class);
        this.env.getCmdDispatcher().addCommand(CmdList.class);
        this.env.getCmdDispatcher().addCommand(CmdListAgain.class);
        this.env.getCmdDispatcher().addCommand(CmdRepeat.class);
        this.env.getCmdDispatcher().addCommand(CmdListFwd.class);
        this.env.getCmdDispatcher().addCommand(CmdListBack.class);
        this.env.getCmdDispatcher().addCommand(CmdSettag.class);
        this.env.getCmdDispatcher().addCommand(CmdStx.class);
        this.env.getCmdDispatcher().addCommand(CmdModinfo.class);
        this.env.getCmdDispatcher().addCommand(CmdAnsi.class);
        this.env.getCmdDispatcher().addCommand(CmdReload.class);
        this.env.getCmdDispatcher().addCommand(CmdAppend.class);
        this.env.getCmdDispatcher().addCommand(CmdRemove.class);
        this.env.getCmdDispatcher().addCommand(CmdState.class);
        this.env.getCmdDispatcher().addCommand(CmdCheck.class);
        this.env.getCmdDispatcher().addCommand(CmdSusp.class);
        this.env.getCmdDispatcher().addCommand(CmdVersion.class);
        this.env.getCmdDispatcher().addCommand(CmdGc.class);
        this.env.getCmdDispatcher().addCommand(CmdKeygen.class);
        this.env.getCmdDispatcher().addCommand(CmdAppName.class);
    }

    private void run() {
        this.env.logStatus(this.logger, "*** READY ***");
        if (!this.quiet) {
            this.env.getConsole().print("OK\r\n(use 'h' for help)\r\n");
        } else {
            this.env.getConsole().print("Starting..." + this.env.getTaskManager().start() + "\r\n");
            if (!this.env.isRunning()) {
                return;
            }
        }
        this.executeStartCommands();
        try {
            while (!this.env.isTerminated()) {
                this.env.getConsole().process();
                Thread.sleep(100L);
            }
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    private void executeStartCommands() {
        if (!this.startCommands.isEmpty()) {
            String[] cmds;
            for (String cmd : cmds = this.startCommands.split("\\s*\\|\\s*")) {
                this.env.getConsole().print("\u001b[34mcmd: " + cmd + "\r\n" + this.env.getCmdDispatcher().execute(this.env.getConsole(), cmd) + "\r\n\r\n" + "\u001b[0m");
            }
        }
    }

    public void attachShutDownHook() {
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                if (JRoboPLC.this.env.isRunning()) {
                    JRoboPLC.this.env.getConsole().print("\u001b[34mStop PLC!\r\n\u001b[0m");
                    JRoboPLC.this.env.getTaskManager().stop();
                }
                JRoboPLC.this.env.logStatus(JRoboPLC.this.logger, "*** EXIT ***\r\n\r\n");
            }
        });
    }

    private void closedown() {
        this.env.logStatus(this.logger, "*** CLOSE ***");
    }

    public static void main(String[] args) {
        JRoboPLC app = new JRoboPLC();
        if (app.parseCommandLine(args) && app.initialize()) {
            app.run();
            app.closedown();
        }
        System.exit(0);
    }
}

