/*
 * Decompiled with CFR 0.152.
 */
package promauto.jroboplc.core.cmd;

import java.util.Set;
import java.util.TreeMap;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import promauto.jroboplc.core.AbstractCommand;
import promauto.jroboplc.core.api.Console;
import promauto.jroboplc.core.api.Environment;
import promauto.jroboplc.core.api.EnvironmentInst;
import promauto.jroboplc.core.api.Module;
import promauto.jroboplc.core.api.Tag;

public class CmdList
extends AbstractCommand {
    protected static final int LIMIT = 1000;
    public static final String STATUS_GOOD = "Good";
    public static final String STATUS_BAD = "Bad";

    @Override
    public String getName() {
        return "l";
    }

    @Override
    public String getUsage() {
        return "[mod|filter]";
    }

    @Override
    public String getDescription() {
        return "list tags filtered with regex";
    }

    @Override
    public String execute(Console console, String args) {
        return this.list(console, args, 0);
    }

    protected String list(Console console, String filter, int pos) {
        String[] s;
        Environment env = EnvironmentInst.get();
        console.setProperty("cmd_l_filter", filter);
        Module m = env.getModuleManager().getModule(filter);
        if (m != null) {
            filter = filter + ":.*";
        }
        int cntbeg = Math.max(0, pos);
        Pattern p = null;
        try {
            if (!filter.isEmpty()) {
                p = Pattern.compile(filter);
            }
        }
        catch (PatternSyntaxException patternSyntaxException) {
            // empty catch block
        }
        int cnt = 0;
        Set<Module> mods = env.getModuleManager().getModules();
        TreeMap<String, String[]> map = new TreeMap<String, String[]>();
        int len1 = 1;
        int len2 = 1;
        int len3 = 1;
        int len4 = 1;
        for (Module mod : mods) {
            for (Tag tag : mod.getTagTable().values()) {
                String tagname = mod.getName() + ':' + tag.getName();
                if (p != null && !p.matcher(tagname).matches()) continue;
                String value = tag.getString();
                if (tag.getType() == Tag.Type.STRING) {
                    value = "\u001b[01m\u001b[33m" + value + "\u001b[0m";
                }
                s = new String[]{tag.getType().name(), this.getFlagsText(tag), this.getStatusText(tag), value};
                map.put(tagname, s);
                ++cnt;
                len1 = Math.max(len1, tagname.length());
                len2 = Math.max(len2, s[0].length());
                len3 = Math.max(len3, s[1].length());
                len4 = Math.max(len4, s[2].length());
            }
        }
        int cntend = cntbeg + 1000;
        int cntlast = 0;
        int i = -1;
        StringBuilder sb = new StringBuilder();
        for (String tagname : map.keySet()) {
            if (++i < cntbeg || i >= cntend) continue;
            s = (String[])map.get(tagname);
            String row = String.format("%-" + len1 + "s  " + "\u001b[32m" + "%-" + len2 + "s %-" + len3 + "s %s%-" + len4 + "s " + "\u001b[0m" + " = %s\r\n", tagname, s[0], s[1], s[2].equals(STATUS_BAD) ? "\u001b[01m\u001b[31m" : "\u001b[01m\u001b[30m", s[2], s[3]);
            sb.append(row);
            cntlast = i;
        }
        console.setProperty("cmd_l_pos", "" + pos);
        console.setProperty("cmd_l_last", "" + ++cntlast);
        sb.append("\r\nListed from " + ++cntbeg + " to " + cntlast + ", total is " + cnt + ".");
        if (cntlast < cnt) {
            sb.append(" Use \"lf\" for next page.");
        }
        sb.append("\r\n\u001b[01m\u001b[30m");
        sb.append("Legend: S - autosave, E - external, H - hidden, Good/Bad - status");
        sb.append("\u001b[0m");
        return sb.toString();
    }

    private String getFlagsText(Tag tag) {
        return ((tag.hasFlags(1) ? " S" : "") + (tag.hasFlags(2) ? " H" : "") + (tag.hasFlags(4) ? " E" : "")).trim();
    }

    private String getStatusText(Tag tag) {
        if (tag.hasFlags(8)) {
            if (tag.getStatus() == Tag.Status.Good) {
                return STATUS_GOOD;
            }
            if (tag.getStatus() == Tag.Status.Bad) {
                return STATUS_BAD;
            }
        }
        return "";
    }
}

