/*
 * Decompiled with CFR 0.152.
 */
package promauto.jroboplc.core.tags;

import java.time.LocalDateTime;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import promauto.jroboplc.core.tags.RefItem;
import promauto.utils.CRC;

public class RefGroup {
    private final List<RefItem> items = new LinkedList<RefItem>();
    private List<RefItem> itemsCrc = null;
    private RefItem itemCrcSum = null;
    private LocalDateTime dtRead = LocalDateTime.now();
    private boolean linked = false;

    RefGroup() {
    }

    public void clear() {
        this.items.clear();
        this.itemsCrc = null;
        this.itemCrcSum = null;
    }

    public LocalDateTime getDtRead() {
        return this.dtRead;
    }

    public RefItem createItem(String modulename, String tagname) {
        RefItem item = new RefItem(this, modulename, tagname);
        this.items.add(item);
        return item;
    }

    public RefItem createItemCrc(String modulename, String tagname) {
        RefItem item = this.createItem(modulename, tagname);
        this.addItemCrc(item);
        return item;
    }

    public RefItem createItemCrcSum(String modulename, String tagname) {
        RefItem item;
        this.itemCrcSum = item = this.createItem(modulename, tagname);
        return item;
    }

    public RefItem addItemCrc(RefItem item) {
        if (this.itemsCrc == null) {
            this.itemsCrc = new LinkedList<RefItem>();
        }
        this.itemsCrc.add(item);
        return item;
    }

    public void prepare() {
        for (RefItem item : this.items) {
            item.prepare();
        }
    }

    public boolean link() {
        for (RefItem item : this.items) {
            if (item.isOptional()) {
                if (this.linked || item.isLinked()) continue;
                item.link();
                continue;
            }
            if (item.link()) continue;
            this.linked = false;
            return false;
        }
        this.linked = true;
        return true;
    }

    public boolean isLinked() {
        return this.linked;
    }

    public boolean read() {
        boolean result = false;
        for (RefItem item : this.items) {
            result |= item.read();
        }
        this.dtRead = LocalDateTime.now();
        return result;
    }

    public boolean linkAndRead() {
        if (!this.link()) {
            return false;
        }
        this.read();
        return true;
    }

    public boolean checkCrc8() {
        if (this.itemCrcSum == null || this.itemsCrc == null) {
            return true;
        }
        int crc = CRC.getCrc8FromWordStream(this.itemsCrc.stream().map(a -> a.getValue().getInt()));
        return this.itemCrcSum.getValue().getInt() == crc;
    }

    public boolean checkCrc16() {
        if (this.itemCrcSum == null || this.itemsCrc == null) {
            return true;
        }
        int crc = CRC.getCrc16FromWordStream(this.itemsCrc.stream().map(a -> a.getValue().getInt()));
        return this.itemCrcSum.getValue().getInt() == crc;
    }

    public boolean checkCrc32() {
        if (this.itemCrcSum == null || this.itemsCrc == null) {
            return true;
        }
        long crc = CRC.getOctoCrc32FromTagStream(this.itemsCrc.stream().filter(RefItem::isLinked).map(RefItem::getTag));
        return this.itemCrcSum.isLinked() && this.itemCrcSum.getValue().getLong() == crc;
    }

    public void disableCrc() {
        if (this.itemsCrc != null) {
            this.itemsCrc.clear();
        }
        this.itemsCrc = null;
        this.itemCrcSum = null;
    }

    public String check() {
        return this.items.stream().filter(item -> !item.link()).map(RefItem::getInfo).collect(Collectors.joining("\r\n"));
    }

    public String checkln() {
        String res = this.check();
        return res.isEmpty() ? "" : "\r\n" + res;
    }
}

