/*
 * Decompiled with CFR 0.152.
 */
package promauto.jroboplc.core.tags;

import promauto.jroboplc.core.api.Tag;
import promauto.jroboplc.core.tags.TagBool;
import promauto.jroboplc.core.tags.TagDouble;
import promauto.jroboplc.core.tags.TagInt;
import promauto.jroboplc.core.tags.TagLong;
import promauto.jroboplc.core.tags.TagString;

public abstract class TagBase
implements Tag {
    private final String name;
    private volatile Tag.Status status = Tag.Status.Good;
    private Object object = null;
    private int flags;

    public static Tag create(Tag.Type type, String tagname, int flags) {
        switch (type) {
            case BOOL: {
                return new TagBool(tagname, false, flags);
            }
            case INT: {
                return new TagInt(tagname, 0, flags);
            }
            case LONG: {
                return new TagLong(tagname, 0L, flags);
            }
            case DOUBLE: {
                return new TagDouble(tagname, 0.0, flags);
            }
            case STRING: {
                return new TagString(tagname, "", flags);
            }
        }
        throw new IllegalArgumentException("Not supported tag type: " + type.name());
    }

    public TagBase(String name) {
        this.name = name;
    }

    public TagBase(String name, int flags) {
        this.name = name;
        this.flags = flags;
    }

    @Override
    public Tag.Status getStatus() {
        return this.status;
    }

    @Override
    public void setStatus(Tag.Status status) {
        if (this.status != status) {
            this.status = status;
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    public String toString() {
        return this.getString();
    }

    @Override
    public <T> T getObject() {
        return (T)this.object;
    }

    @Override
    public void setObject(Object object) {
        this.object = object;
    }

    @Override
    public int getFlags() {
        return this.flags;
    }

    @Override
    public void setFlags(int flags) {
        this.flags = flags;
    }

    @Override
    public void addFlag(int flag) {
        this.flags |= flag;
    }

    @Override
    public boolean hasFlags(int flags) {
        return (this.flags & flags) == flags;
    }

    @Override
    public void copyFlagsFrom(Tag tag) {
        this.flags = tag.getFlags();
    }
}

