/*
 * Decompiled with CFR 0.152.
 */
package promauto.jroboplc.core.tags;

import promauto.jroboplc.core.api.Tag;
import promauto.jroboplc.core.tags.TagPlain;

public class TagPlainLong
extends TagPlain {
    long value;

    public TagPlainLong(String name, long value) {
        super(name);
        this.value = value;
    }

    @Override
    public Tag.Type getType() {
        return Tag.Type.LONG;
    }

    @Override
    public boolean equalsValue(Tag tag) {
        return tag.getLong() == this.value;
    }

    @Override
    public void copyValueTo(Tag tag) {
        tag.setLong(this.value);
    }

    @Override
    public boolean getBool() {
        return this.value != 0L;
    }

    @Override
    public int getInt() {
        return (int)this.value;
    }

    @Override
    public long getLong() {
        return this.value;
    }

    @Override
    public double getDouble() {
        return this.value;
    }

    @Override
    public String getString() {
        return "" + this.value;
    }

    @Override
    public void setBool(boolean value) {
        this.value = value ? 1L : 0L;
    }

    @Override
    public void setOn() {
        this.value = 1L;
    }

    @Override
    public void setOff() {
        this.value = 0L;
    }

    @Override
    public void setInt(int value) {
        this.value = value;
    }

    @Override
    public void setLong(long value) {
        this.value = value;
    }

    @Override
    public void setDouble(double value) {
        this.value = (long)value;
    }

    @Override
    public void setString(String value) {
        try {
            this.value = Long.parseLong(value.trim());
        }
        catch (NumberFormatException e) {
            this.value = 0L;
        }
    }
}

