/*
 * Decompiled with CFR 0.152.
 */
package promauto.jroboplc.core.tags;

import promauto.jroboplc.core.api.Tag;
import promauto.jroboplc.core.tags.TagRW;

public class TagRWBool
extends TagRW {
    private volatile boolean valueRd;
    private boolean valueWr;
    private boolean valueWrLast = false;

    public TagRWBool(String name, boolean value, int flags) {
        super(name, flags);
        this.valueRd = value;
    }

    @Override
    public Tag.Type getType() {
        return Tag.Type.BOOL;
    }

    @Override
    public boolean getBool() {
        return this.valueRd;
    }

    @Override
    public int getInt() {
        return this.valueRd ? 1 : 0;
    }

    @Override
    public long getLong() {
        return this.valueRd ? 1L : 0L;
    }

    @Override
    public double getDouble() {
        return this.valueRd ? 1.0 : 0.0;
    }

    @Override
    public String getString() {
        return this.valueRd ? "on" : "off";
    }

    @Override
    public synchronized void setBool(boolean value) {
        this.valueWr = value;
        this.valueWrChanged = true;
    }

    @Override
    public synchronized void setOn() {
        this.valueWr = true;
        this.valueWrChanged = true;
    }

    @Override
    public synchronized void setOff() {
        this.valueWr = false;
        this.valueWrChanged = true;
    }

    @Override
    public synchronized void setInt(int value) {
        this.valueWr = value != 0;
        this.valueWrChanged = true;
    }

    @Override
    public synchronized void setLong(long value) {
        this.valueWr = value != 0L;
        this.valueWrChanged = true;
    }

    @Override
    public synchronized void setDouble(double value) {
        this.valueWr = value != 0.0;
        this.valueWrChanged = true;
    }

    @Override
    public synchronized void setString(String value) {
        this.valueWr = value.equals("on");
        this.valueWrChanged = true;
    }

    @Override
    public boolean getWriteValBool() {
        return this.valueWrLast;
    }

    @Override
    public int getWriteValInt() {
        return this.valueWrLast ? 1 : 0;
    }

    @Override
    public long getWriteValLong() {
        return this.valueWrLast ? 1L : 0L;
    }

    @Override
    public double getWriteValDouble() {
        return this.valueWrLast ? 1.0 : 0.0;
    }

    @Override
    public String getWriteValString() {
        return this.valueWrLast ? "on" : "off";
    }

    @Override
    public void setReadValBool(boolean value) {
        this.valueRd = value;
    }

    @Override
    public void setReadValInt(int value) {
        this.valueRd = value != 0;
    }

    @Override
    public void setReadValLong(long value) {
        this.valueRd = value != 0L;
    }

    @Override
    public void setReadValDouble(double value) {
        this.valueRd = value != 0.0;
    }

    @Override
    public void setReadValString(String value) throws NumberFormatException {
        this.valueRd = value.equals("on");
    }

    @Override
    public boolean equalsValue(Tag tag) {
        return tag.getBool() == this.valueRd;
    }

    @Override
    public void copyValueTo(Tag tag) {
        tag.setBool(this.valueRd);
    }

    @Override
    protected void copyWriteToLastWrite() {
        this.valueWrChanged = false;
        this.valueWrLast = this.valueWr;
    }

    @Override
    protected void copyWriteToRead() {
        this.valueRd = this.valueWr;
    }

    @Override
    public void copyLastWriteToRead() {
        this.valueRd = this.valueWrLast;
    }
}

