/*
 * Decompiled with CFR 0.152.
 */
package promauto.jroboplc.core.tags;

import promauto.jroboplc.core.api.Tag;
import promauto.jroboplc.core.tags.TagRW;

public class TagRWString
extends TagRW {
    private volatile String valueRd;
    private String valueWr;
    private String valueWrLast = "";

    public TagRWString(String name, String value, int flags) {
        super(name, flags);
        this.setReadValString(value);
    }

    @Override
    public Tag.Type getType() {
        return Tag.Type.STRING;
    }

    @Override
    public boolean getBool() {
        return this.valueRd.equals("on");
    }

    @Override
    public int getInt() {
        try {
            return Integer.parseInt(this.valueRd);
        }
        catch (NumberFormatException e) {
            return 0;
        }
    }

    @Override
    public long getLong() {
        try {
            return Long.parseLong(this.valueRd);
        }
        catch (NumberFormatException e) {
            return 0L;
        }
    }

    @Override
    public double getDouble() {
        try {
            return Double.parseDouble(this.valueRd);
        }
        catch (NumberFormatException e) {
            return 0.0;
        }
    }

    @Override
    public String getString() {
        return this.valueRd;
    }

    @Override
    public synchronized void setBool(boolean value) {
        this.valueWr = value ? "on" : "off";
        this.valueWrChanged = true;
    }

    @Override
    public synchronized void setOn() {
        this.valueWr = "on";
        this.valueWrChanged = true;
    }

    @Override
    public synchronized void setOff() {
        this.valueWr = "off";
        this.valueWrChanged = true;
    }

    @Override
    public synchronized void setInt(int value) {
        this.valueWr = "" + value;
        this.valueWrChanged = true;
    }

    @Override
    public synchronized void setLong(long value) {
        this.valueWr = "" + value;
        this.valueWrChanged = true;
    }

    @Override
    public synchronized void setDouble(double value) {
        this.valueWr = "" + value;
        this.valueWrChanged = true;
    }

    @Override
    public synchronized void setString(String value) {
        this.valueWr = value.length() <= 4096 ? value : value.substring(0, 4096);
        this.valueWrChanged = true;
    }

    @Override
    public boolean getWriteValBool() {
        return this.valueWrLast.equals("on");
    }

    @Override
    public int getWriteValInt() {
        try {
            return Integer.parseInt(this.valueWrLast);
        }
        catch (NumberFormatException e) {
            return 0;
        }
    }

    @Override
    public long getWriteValLong() {
        try {
            return Long.parseLong(this.valueWrLast);
        }
        catch (NumberFormatException e) {
            return 0L;
        }
    }

    @Override
    public double getWriteValDouble() {
        try {
            return Double.parseDouble(this.valueWrLast);
        }
        catch (NumberFormatException e) {
            return 0.0;
        }
    }

    @Override
    public String getWriteValString() {
        return this.valueWrLast;
    }

    @Override
    public void setReadValBool(boolean value) {
        this.valueRd = value ? "on" : "off";
    }

    @Override
    public void setReadValInt(int value) {
        this.valueRd = "" + value;
    }

    @Override
    public void setReadValLong(long value) {
        this.valueRd = "" + value;
    }

    @Override
    public void setReadValDouble(double value) {
        this.valueRd = "" + value;
    }

    @Override
    public void setReadValString(String value) {
        this.valueRd = value == null ? "" : (value.length() <= 4096 ? value : value.substring(0, 4096));
    }

    @Override
    public boolean equalsValue(Tag tag) {
        return tag.getString().equals(this.valueRd);
    }

    @Override
    public void copyValueTo(Tag tag) {
        tag.setString(this.valueRd);
    }

    @Override
    protected void copyWriteToLastWrite() {
        this.valueWrChanged = false;
        this.valueWrLast = this.valueWr;
    }

    @Override
    protected void copyWriteToRead() {
        this.valueRd = this.valueWr;
    }

    @Override
    public void copyLastWriteToRead() {
        this.valueRd = this.valueWrLast;
    }
}

