/*
 * Decompiled with CFR 0.152.
 */
package promauto.jroboplc.plugin.database;

import java.sql.SQLException;
import java.sql.Statement;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import promauto.jroboplc.plugin.database.DatabaseModule;
import promauto.jroboplc.plugin.database.Dbscr;
import promauto.jroboplc.plugin.database.DbscrAction;

public class DbscrActionIf
extends DbscrAction {
    private static Pattern pattern = Pattern.compile("((?:not)?)\\s*(\\w+)\\((.*)\\)");
    private boolean not;
    private String cmd;
    private String argline;
    private String[] args;
    private BooleanSupplierThr func;

    @Override
    public boolean init(Dbscr dbscr, String conf) {
        super.init(dbscr, conf);
        Matcher m = pattern.matcher(conf);
        if (!m.find()) {
            return false;
        }
        this.not = !m.group(1).isEmpty();
        this.cmd = m.group(2).trim();
        this.argline = m.group(3).trim();
        this.args = this.argline.split("\\s*,\\s*");
        DatabaseModule db = dbscr.getDatabase();
        this.func = null;
        switch (this.cmd) {
            case "has_domain": {
                this.func = st -> db.hasDomain(st, this.getArg(0), this.getArg(1)) ^ this.not;
                break;
            }
            case "has_schema": {
                this.func = st -> db.hasSchema(st, this.getArg(0)) ^ this.not;
                break;
            }
            case "has_table": {
                this.func = st -> db.hasTable(st, this.getArg(0), this.getArg(1)) ^ this.not;
                break;
            }
            case "has_column": {
                this.func = st -> db.hasColumn(st, this.getArg(0), this.getArg(1), this.getArg(2)) ^ this.not;
                break;
            }
            case "has_constraint": {
                this.func = st -> db.hasConstraint(st, this.getArg(0), this.getArg(1), this.getArg(2)) ^ this.not;
                break;
            }
            case "has_index": {
                this.func = st -> db.hasIndex(st, this.getArg(0), this.getArg(1)) ^ this.not;
                break;
            }
            case "has_trigger": {
                this.func = st -> db.hasTrigger(st, this.getArg(0), this.getArg(1)) ^ this.not;
                break;
            }
            case "has_procedure": {
                this.func = st -> db.hasProcedure(st, this.getArg(0), this.getArg(1)) ^ this.not;
                break;
            }
            case "has_record": {
                this.func = st -> db.hasRecord(st, dbscr.injectParameters(this.argline)) ^ this.not;
                break;
            }
            default: {
                return false;
            }
        }
        return true;
    }

    private String getArg(int idx) {
        if (idx < this.args.length) {
            return this.dbscr.injectParameters(this.args[idx]);
        }
        return "";
    }

    @Override
    public boolean execute(Statement statement) throws SQLException {
        if (this.func == null) {
            return false;
        }
        return this.func.execute(statement);
    }

    @Override
    public boolean isCondition() {
        return true;
    }

    @FunctionalInterface
    public static interface BooleanSupplierThr {
        public boolean execute(Statement var1) throws SQLException;
    }
}

