/*
 * Decompiled with CFR 0.152.
 */
package promauto.jroboplc.plugin.jrbustcp;

import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.group.ChannelGroup;
import io.netty.channel.group.DefaultChannelGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.handler.ipfilter.IpFilterRuleType;
import io.netty.handler.ipfilter.IpSubnetFilter;
import io.netty.handler.ipfilter.IpSubnetFilterRule;
import io.netty.handler.logging.LogLevel;
import io.netty.handler.logging.LoggingHandler;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslContextBuilder;
import io.netty.handler.ssl.util.SelfSignedCertificate;
import io.netty.util.AttributeKey;
import io.netty.util.ResourceLeakDetector;
import io.netty.util.concurrent.EventExecutor;
import io.netty.util.concurrent.GlobalEventExecutor;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.BasicConfigurator;
import promauto.jroboplc.core.AbstractModule;
import promauto.jroboplc.core.api.Configuration;
import promauto.jroboplc.core.api.Plugin;
import promauto.jroboplc.plugin.jrbustcp.ServerInitializer;
import promauto.jroboplc.plugin.jrbustcp.ServerSession;

public class JrbustcpServerModule
extends AbstractModule {
    protected static final AttributeKey<ServerSession> CHDATA = AttributeKey.valueOf((String)"CHDATA");
    private int port;
    private boolean ssl;
    private String compress;
    private int idleTimeout;
    private boolean logging;
    private boolean auth;
    private IpSubnetFilter ipSubnetFilter;
    private EventLoopGroup bossGroup = null;
    private EventLoopGroup workerGroup = null;
    private final ChannelGroup clientChannels = new DefaultChannelGroup((EventExecutor)GlobalEventExecutor.INSTANCE);
    private boolean bound;

    protected JrbustcpServerModule(Plugin plugin, String name) {
        super(plugin, name);
        this.taskable = false;
    }

    public int getPort() {
        return this.port;
    }

    public String getCompress() {
        return this.compress;
    }

    public int getIdleTimeout() {
        return this.idleTimeout;
    }

    public boolean isLogging() {
        return this.logging;
    }

    public boolean isAuth() {
        return this.auth;
    }

    public void setAuth(boolean auth) {
        this.auth = auth;
    }

    public ChannelHandler getIpSubnetFilter() {
        return this.ipSubnetFilter;
    }

    public ChannelGroup getClientChannels() {
        return this.clientChannels;
    }

    @Override
    protected boolean loadModule(Object conf) {
        Configuration cm = this.env.getConfiguration();
        this.port = cm.get(conf, "port", 0);
        this.ssl = cm.get(conf, "ssl", false);
        this.compress = cm.get(conf, "compress", "");
        this.idleTimeout = cm.get(conf, "idleTimeout_s", 180);
        this.logging = cm.get(conf, "logging", false);
        this.auth = cm.get(conf, "auth", false);
        this.ipSubnetFilter = this.createIpFilter(cm.getStringList(conf, "ipfilter"));
        this.bound = false;
        return true;
    }

    private IpSubnetFilter createIpFilter(List<String> strRules) {
        Pattern p = Pattern.compile("^((?:[0-9]{1,3}\\.){3}[0-9]{1,3}){0,1}(?:\\/(\\d*)){0,1}\\s*(accept|deny)$");
        ArrayList<IpSubnetFilterRule> rules = new ArrayList<IpSubnetFilterRule>();
        boolean acceptIfNotFound = true;
        for (String strRule : strRules) {
            Matcher m = p.matcher(strRule);
            if (m.matches()) {
                IpFilterRuleType type;
                String ip = m.group(1);
                int cidr = m.group(2) == null ? 32 : Integer.parseInt(m.group(2));
                IpFilterRuleType ipFilterRuleType = type = m.group(3).equals("accept") ? IpFilterRuleType.ACCEPT : IpFilterRuleType.REJECT;
                if (ip == null) {
                    acceptIfNotFound = type == IpFilterRuleType.ACCEPT;
                    continue;
                }
                rules.add(new IpSubnetFilterRule(ip, cidr, type));
                continue;
            }
            this.env.printError(this.logger, this.name, "Bad rule in ipfilter: " + strRule);
        }
        return new IpSubnetFilter(acceptIfNotFound, rules);
    }

    @Override
    public String getInfo() {
        if (this.enable) {
            ArrayList<String[]> list = new ArrayList<String[]>();
            String s = String.format("%sp%d%s%s%s", this.bound ? "" : "\u001b[31m\u001b[01mNOT BOUND! \u001b[0m", this.port, this.ssl ? " SSL" : "", this.compress.isEmpty() ? "" : " " + this.compress, this.auth ? " AUTH" : "");
            list.add(new String[]{s, "", ""});
            long totalRead = 0L;
            long totalWritten = 0L;
            for (Channel ch : this.clientChannels) {
                String[] r = new String[3];
                list.add(r);
                ServerSession sess = (ServerSession)ch.attr(CHDATA).get();
                r[0] = ch.remoteAddress() + " " + sess.getInfo();
                long rd = sess.getTrafficHandler().getCounterRead();
                long wr = sess.getTrafficHandler().getCounterWritten();
                r[1] = rd + "";
                r[2] = wr + "";
                totalRead += rd;
                totalWritten += wr;
            }
            String[] r = (String[])list.get(0);
            r[1] = totalRead + "";
            r[2] = totalWritten + "";
            int[] lens = new int[]{0, 0, 0};
            list.stream().forEach(ss -> {
                for (int i = 0; i < 3; ++i) {
                    lens[i] = Math.max(lens[i], ss[i].length());
                }
            });
            StringBuilder sb = new StringBuilder();
            list.stream().forEach(ss -> {
                String fmt = "%-" + lens[0] + "s   %s%s%" + lens[1] + "s / %" + lens[2] + "s B/s%s\r\n";
                String row = String.format(fmt, ss[0], sb.length() > 0 ? "" : "\u001b[01m", "\u001b[32m", ss[1], ss[2], "\u001b[0m");
                sb.append(row);
            });
            return sb.toString();
        }
        return "disabled";
    }

    @Override
    protected boolean prepareModule() {
        if (this.logging) {
            BasicConfigurator.configure();
            ResourceLeakDetector.setLevel((ResourceLeakDetector.Level)ResourceLeakDetector.Level.PARANOID);
        }
        try {
            SslContext sslCtx = null;
            if (this.ssl) {
                SelfSignedCertificate ssc = new SelfSignedCertificate();
                sslCtx = SslContextBuilder.forServer((File)ssc.certificate(), (File)ssc.privateKey()).build();
            }
            if (this.bossGroup == null) {
                this.bossGroup = new NioEventLoopGroup(1);
            }
            if (this.workerGroup == null) {
                this.workerGroup = new NioEventLoopGroup();
            }
            ServerBootstrap b = new ServerBootstrap();
            ((ServerBootstrap)((ServerBootstrap)b.group(this.bossGroup, this.workerGroup).channel(NioServerSocketChannel.class)).handler((ChannelHandler)new LoggingHandler(LogLevel.INFO))).childHandler((ChannelHandler)new ServerInitializer(this, sslCtx));
            b.bind(this.port).sync();
            this.bound = true;
        }
        catch (Exception e) {
            this.bound = false;
            this.env.printError(this.logger, e, this.name);
        }
        return true;
    }

    @Override
    protected boolean closedownModule() {
        if (this.bossGroup != null && this.workerGroup != null) {
            this.bossGroup.shutdownGracefully();
            this.workerGroup.shutdownGracefully();
            try {
                this.bossGroup.terminationFuture().sync();
                this.workerGroup.terminationFuture().sync();
            }
            catch (InterruptedException e) {
                this.env.printError(this.logger, e, this.name);
            }
            this.bossGroup = null;
            this.workerGroup = null;
        }
        this.bound = false;
        return true;
    }

    @Override
    protected boolean reload() {
        JrbustcpServerModule tmp = new JrbustcpServerModule(this.plugin, this.name);
        if (!tmp.load()) {
            return false;
        }
        this.closedownModule();
        this.copySettingsFrom(tmp);
        this.port = tmp.port;
        this.ssl = tmp.ssl;
        this.compress = tmp.compress;
        this.idleTimeout = tmp.idleTimeout;
        this.auth = tmp.auth;
        this.ipSubnetFilter = tmp.ipSubnetFilter;
        if (this.enable && this.env.isRunning()) {
            this.prepareModule();
        }
        return true;
    }
}

