/*
 * Decompiled with CFR 0.152.
 */
package promauto.jroboplc.plugin.kkmansvr;

import java.sql.Statement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import promauto.jroboplc.core.AbstractModule;
import promauto.jroboplc.core.api.ANSI;
import promauto.jroboplc.core.api.Configuration;
import promauto.jroboplc.core.api.Database;
import promauto.jroboplc.core.api.Module;
import promauto.jroboplc.core.api.Plugin;
import promauto.jroboplc.core.api.Signal;
import promauto.jroboplc.core.api.Tag;
import promauto.jroboplc.core.api.TagRepository;
import promauto.jroboplc.core.tags.TagRW;
import promauto.jroboplc.plugin.kkmansvr.DataService;
import promauto.jroboplc.plugin.kkmansvr.DataServiceImpl;
import promauto.jroboplc.plugin.kkmansvr.KkmansvrPlugin;
import promauto.jroboplc.plugin.kkmansvr.Line;

public class KkmansvrModule
extends AbstractModule
implements Signal.Listener {
    private final Logger logger = LoggerFactory.getLogger(KkmansvrModule.class);
    public static final String DBSCR_KKMANSVR = "dbscr/dbscr.kkmansvr.yml";
    public static final String KKMANSVR_INIT_1 = "kkmansvr.init1";
    public static final String KKMANSVR_INIT_2 = "kkmansvr.init2";
    public static final String TABLE_REPO = "KM_REPO";
    private DataService service = new DataServiceImpl();
    private Line line;
    private TagRepository repo;
    private Database database;
    private String databaseModuleName;
    private boolean connected;
    private boolean emulated;
    private boolean needInit;
    private Tag tagConnected;

    public KkmansvrModule(Plugin plugin, String name) {
        super(plugin, name);
        this.line = new Line(this.service, name);
    }

    public TagRepository getRepo() {
        return this.repo;
    }

    @Override
    public final boolean loadModule(Object conf) {
        Configuration cm = this.env.getConfiguration();
        this.emulated = cm.get(conf, "emulate", false);
        this.databaseModuleName = cm.get(conf, "database", "db");
        this.line.load(conf, this.tagtable);
        this.tagConnected = this.tagtable.createBool("connected", false);
        return true;
    }

    @Override
    public final boolean prepareModule() {
        if (this.emulated) {
            return true;
        }
        this.database = this.env.getModuleManager().getModule(this.databaseModuleName, Database.class);
        if (this.database == null) {
            this.env.printError(this.logger, this.name, "Database not found:", this.databaseModuleName);
            return false;
        }
        this.database.addSignalListener(this);
        this.service.setDb(this.database);
        this.repo = this.database.createTagRepository("", TABLE_REPO);
        this.line.setRepo(this.repo);
        if (this.database.loadScriptFromResource(KkmansvrPlugin.class, DBSCR_KKMANSVR) == null) {
            return false;
        }
        this.needInit = true;
        return true;
    }

    @Override
    public void onSignal(Module sender, Signal signal) {
        if (signal.type == Signal.SignalType.CONNECTED && !this.connected) {
            this.needInit = true;
            this.postSignal(Signal.SignalType.RELOADED);
        }
        if (signal.type == Signal.SignalType.DISCONNECTED) {
            this.connected = false;
            this.tagConnected.setBool(false);
        }
    }

    private void init() {
        this.connected = false;
        this.tagConnected.setBool(false);
        if (this.emulated || this.database == null || !this.database.isConnected()) {
            return;
        }
        this.connected = this.database.executeScript((String)KKMANSVR_INIT_1).success && this.database.executeScript((String)KKMANSVR_INIT_2).success;
        try (Statement st = this.service.createStatement();){
            this.connected &= this.repo.init() && this.line.init();
            this.service.commit();
        }
        catch (Exception e) {
            this.env.printError(this.logger, e, this.name);
            this.service.rollback();
        }
        if (!this.connected) {
            this.env.printError(this.logger, this.name, "Initialization error");
        }
        this.tagConnected.setBool(this.connected);
        this.needInit = false;
    }

    @Override
    public boolean executeModule() {
        if (this.emulated) {
            this.tagtable.getMap().values().stream().filter(tag -> tag instanceof TagRW).forEach(tag -> ((TagRW)tag).acceptWriteValue());
            return true;
        }
        if (this.database == null || !this.database.isConnected()) {
            return true;
        }
        if (this.needInit) {
            this.init();
        }
        if (this.connected) {
            try (Statement st = this.service.createStatement();){
                this.line.execute();
                this.repo.persist();
                this.service.commit();
            }
            catch (Exception e) {
                this.env.printError(this.logger, e, this.name);
                this.service.rollback();
                this.connected = false;
                this.tagConnected.setBool(false);
                this.needInit = true;
            }
        }
        return true;
    }

    @Override
    public boolean closedownModule() {
        this.connected = false;
        this.tagConnected.setBool(false);
        if (this.database != null) {
            this.database.removeSignalListener(this);
        }
        return true;
    }

    @Override
    public String getInfo() {
        if (!this.enable) {
            return "disabled";
        }
        if (this.emulated) {
            return "emulated";
        }
        return String.format("%s%s, %s\r\n%s", this.connected ? "" : ANSI.redBold("NOT CONNECTED! "), this.line.getInfoLine(), this.databaseModuleName, this.line.getInfoDosers());
    }

    @Override
    public String check() {
        return this.line.check();
    }

    @Override
    protected boolean reload() {
        KkmansvrModule tmp = new KkmansvrModule(this.plugin, this.name);
        if (!tmp.load()) {
            return false;
        }
        this.closedown();
        this.copySettingsFrom(tmp);
        this.tagtable.removeAll();
        tmp.tagtable.values().forEach(tag -> this.tagtable.add(tag));
        tmp.tagtable.clear();
        this.tagConnected = tmp.tagConnected;
        this.service = tmp.service;
        this.line = tmp.line;
        this.prepare();
        return true;
    }
}

