/*
 * Decompiled with CFR 0.152.
 */
package promauto.jroboplc.plugin.kkormsvr;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import promauto.jroboplc.core.TagTable;
import promauto.jroboplc.core.api.EnvironmentInst;
import promauto.jroboplc.core.api.Tag;
import promauto.jroboplc.core.tags.RefGroup;
import promauto.jroboplc.core.tags.RefItem;
import promauto.jroboplc.core.tags.TagRW;
import promauto.jroboplc.plugin.kkormsvr.KkDoser;
import promauto.jroboplc.plugin.kkormsvr.KkTask;
import promauto.jroboplc.plugin.kkormsvr.KkormsvrModule;

public class KkStorage {
    private final Logger logger = LoggerFactory.getLogger(KkStorage.class);
    public final KkormsvrModule module;
    private final KkDoser doser;
    private int id;
    private int addr;
    private int stornum;
    private String name;
    private RefItem refSumWeight;
    RefItem refReqWeight;
    private RefItem refSetWeight;
    private long sumWeight = -1L;
    long reqWeight;
    private int productId;
    private String prmSumWeight;
    private String prmReqWeight;
    private String prmProductId;
    private Tag tagReqWeight;
    private TagRW tagProductName;

    KkStorage(KkDoser doser) {
        this.doser = doser;
        this.module = doser.module;
    }

    boolean load(int addr, Object numname) {
        try {
            this.addr = addr;
            if (numname instanceof Integer) {
                this.stornum = (Integer)numname;
                this.name = this.stornum + " \u0411\u0443\u043d\u043a\u0435\u0440";
            } else {
                Pattern p = Pattern.compile("(\\d+)\\s*,\\s*(\\S+.*)");
                Matcher m = p.matcher(numname.toString());
                if (!m.find()) {
                    throw new IllegalArgumentException();
                }
                this.stornum = Integer.parseInt(m.group(1));
                this.name = m.group(2);
            }
        }
        catch (Exception e) {
            EnvironmentInst.get().printError(this.logger, this.module.getName(), this.doser.getName(), "Bad storage num / name: " + addr + ":" + numname);
            return false;
        }
        TagTable tt = this.module.getTagTable();
        this.tagProductName = tt.createRWString(this.doser.prefix() + "Product" + addr, "");
        this.tagReqWeight = tt.createLong(this.doser.prefix() + "ReqWeight" + addr, 0L);
        return true;
    }

    void createRefs(RefGroup refgr, String bindModuleName) {
        this.refSumWeight = refgr.createItemCrc(bindModuleName, "SumWeight" + this.addr);
        this.refReqWeight = refgr.createItem(bindModuleName, "ReqWeight" + this.addr);
        this.refSetWeight = refgr.createItem(bindModuleName, "SetWeight" + this.addr);
    }

    void initLiveData() {
        this.prmSumWeight = this.doser.prefix() + "SumWeight" + this.addr;
        this.prmReqWeight = this.doser.prefix() + "ReqWeight" + this.addr;
        this.prmProductId = this.doser.prefix() + "ProcudtId" + this.addr;
    }

    void readLiveData() {
        this.sumWeight = this.module.livedata.getLong(this.prmSumWeight, this.sumWeight);
        this.reqWeight = this.module.livedata.getLong(this.prmReqWeight, this.reqWeight);
        this.productId = this.module.livedata.getInt(this.prmProductId, this.productId);
    }

    void updateLiveData() {
        this.module.livedata.set(this.prmSumWeight, this.sumWeight);
        this.module.livedata.set(this.prmReqWeight, this.reqWeight);
        this.module.livedata.set(this.prmProductId, this.productId);
    }

    void init() throws SQLException {
        Statement st = this.module.getStatement();
        String sql = String.format("select id, name from kk_storage where stornum=%d", this.stornum);
        try (ResultSet rs = st.executeQuery(sql);){
            if (rs.next()) {
                this.id = rs.getInt("id");
                if (!rs.getString("name").equals(this.name)) {
                    sql = String.format("update kk_storage set name='%s' where id=%d", this.name, this.id);
                    st.executeUpdate(sql);
                }
            } else {
                sql = String.format("insert into kk_storage (stornum, name) values (%d, '%s')", this.stornum, this.name);
                this.id = this.module.getDatabase().insertReturningId(st, sql, new String[0]);
            }
        }
        sql = String.format("select 1 from kk_linestor where line_id=%d and storage_id=%d", this.doser.line.getId(), this.id);
        rs = st.executeQuery(sql);
        var4_4 = null;
        try {
            if (!rs.next()) {
                sql = String.format("insert into kk_linestor (line_id, storage_id, kg) values (%d, %d, 0)", this.doser.line.getId(), this.id);
                st.executeUpdate(sql);
            }
        }
        catch (Throwable throwable) {
            var4_4 = throwable;
            throw throwable;
        }
        finally {
            if (rs != null) {
                if (var4_4 != null) {
                    try {
                        rs.close();
                    }
                    catch (Throwable throwable) {
                        var4_4.addSuppressed(throwable);
                    }
                } else {
                    rs.close();
                }
            }
        }
        sql = String.format("delete from kk_linestor where line_id<>%d and storage_id=%d", this.doser.line.getId(), this.id);
        st.executeUpdate(sql);
        if (this.productId > 0) {
            sql = String.format("select name from kk_product where id=%d", this.productId);
            rs = st.executeQuery(sql);
            var4_4 = null;
            try {
                if (rs.next()) {
                    this.tagProductName.setReadValString(rs.getString(1));
                }
            }
            catch (Throwable throwable) {
                var4_4 = throwable;
                throw throwable;
            }
            finally {
                if (rs != null) {
                    if (var4_4 != null) {
                        try {
                            rs.close();
                        }
                        catch (Throwable throwable) {
                            var4_4.addSuppressed(throwable);
                        }
                    } else {
                        rs.close();
                    }
                }
            }
        }
    }

    void execute() throws SQLException {
        long weight;
        this.refSetWeight.getTag().setLong(this.reqWeight);
        if (this.sumWeight == -1L) {
            this.sumWeight = this.refSumWeight.getValue().getLong();
        }
        if ((weight = this.refSumWeight.getValue().getLong() - this.sumWeight) != 0L) {
            if (weight < 0L) {
                weight += this.doser.getSumWeightMax() + 1L;
            }
            this.doser.line.saveWeight(this.id, this.productId, this.doser.getGroup().getCycleCnt(), weight, this.sumWeight, this.refSumWeight.getValue().getLong());
            this.sumWeight = this.refSumWeight.getValue().getLong();
        }
        this.updateTags();
    }

    private void updateTags() {
        this.tagReqWeight.setLong(this.reqWeight);
    }

    void applyTask(KkTask task) {
        KkTask.Detail detail = task.details.get(this.id);
        if (detail != null) {
            this.reqWeight = detail.weight;
            this.productId = detail.productId;
            this.tagProductName.setReadValString(detail.productName);
            detail.applied = true;
        } else {
            this.reqWeight = 0L;
            this.productId = 0;
            this.tagProductName.setReadValString("");
        }
    }

    public String getInfo() {
        return String.format("      %2d: sum=%-10d set=%-10d %d/%s [%s]", this.addr, this.sumWeight, this.reqWeight, this.stornum, this.name, this.tagProductName);
    }

    public int getAddr() {
        return this.addr;
    }

    public int getNum() {
        return this.stornum;
    }

    public String getName() {
        return this.name;
    }

    public String getProduct() {
        return this.tagProductName.getString();
    }
}

