/*
 * Decompiled with CFR 0.152.
 */
package promauto.jroboplc.plugin.kkormsvr;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import promauto.jroboplc.core.AbstractModule;
import promauto.jroboplc.core.api.ANSI;
import promauto.jroboplc.core.api.Configuration;
import promauto.jroboplc.core.api.Database;
import promauto.jroboplc.core.api.Module;
import promauto.jroboplc.core.api.Plugin;
import promauto.jroboplc.core.api.Signal;
import promauto.jroboplc.core.api.Tag;
import promauto.jroboplc.plugin.kkormsvr.CmdImport;
import promauto.jroboplc.plugin.kkormsvr.CmdSweep;
import promauto.jroboplc.plugin.kkormsvr.KkLine;
import promauto.jroboplc.plugin.kkormsvr.KkormsvrPlugin;
import promauto.jroboplc.plugin.kkormsvr.LiveData;

public class KkormsvrModule
extends AbstractModule
implements Signal.Listener {
    private final Logger logger = LoggerFactory.getLogger(KkormsvrModule.class);
    private Database database;
    private String databaseModuleName;
    private List<KkLine> lines = new ArrayList<KkLine>();
    private Statement statement;
    private boolean connected;
    private Tag tagConnected;
    public final LiveData livedata;
    private DateTimeFormatter formatter;
    private boolean emulated;

    public KkormsvrModule(Plugin plugin, String name) {
        super(plugin, name);
        this.env.getCmdDispatcher().addCommand(this, CmdImport.class);
        this.env.getCmdDispatcher().addCommand(this, CmdSweep.class);
        this.livedata = new LiveData(this);
    }

    public Database getDatabase() {
        return this.database;
    }

    public Statement getStatement() {
        return this.statement;
    }

    @Override
    public final boolean loadModule(Object conf) {
        Configuration cm = this.env.getConfiguration();
        this.emulated = cm.get(conf, "emulate", false);
        this.databaseModuleName = cm.get(conf, "database", "db");
        Iterator<Object> iterator = cm.toList(cm.get(conf, "lines")).iterator();
        while (iterator.hasNext()) {
            KkLine line = new KkLine(this);
            Object lineconf = iterator.next();
            if (!line.load(lineconf)) {
                return false;
            }
            this.lines.add(line);
        }
        this.tagConnected = this.tagtable.createBool("connected", false);
        return true;
    }

    @Override
    public final boolean prepareModule() {
        if (this.emulated) {
            return true;
        }
        Module module = this.env.getModuleManager().getModule(this.databaseModuleName);
        if (module == null) {
            this.env.printError(this.logger, this.name, "Not found a database module:", this.databaseModuleName);
            return false;
        }
        if (!(module instanceof Database)) {
            this.env.printError(this.logger, this.name, "Not a database:", this.databaseModuleName);
            return false;
        }
        this.database = (Database)module;
        this.database.addSignalListener(this);
        this.formatter = this.database.getTimestampFormatter();
        String resourceName = "dbscr/dbscr.kkormsvr.yml";
        if (this.database.loadScriptFromResource(KkormsvrPlugin.class, resourceName) == null) {
            return false;
        }
        this.lines.forEach(KkLine::prepare);
        this.init();
        return true;
    }

    @Override
    public void onSignal(Module sender, Signal signal) {
        if (this.emulated) {
            return;
        }
        if (signal.type == Signal.SignalType.CONNECTED) {
            if (!this.connected) {
                this.init();
                this.postSignal(Signal.SignalType.RELOADED);
            }
        } else if (signal.type == Signal.SignalType.DISCONNECTED) {
            this.connected = false;
            this.tagConnected.setBool(false);
        }
    }

    private void init() {
        this.connected = false;
        this.tagConnected.setBool(false);
        if (!this.enable || this.database == null || !this.database.isConnected()) {
            return;
        }
        boolean res = true;
        res &= this.database.executeScript((String)"kkormsvr.init1").success;
        res &= this.database.executeScript((String)"kkormsvr.init2").success;
        this.connected = res &= this.initLines();
        this.tagConnected.setBool(this.connected);
        if (!res) {
            this.env.printError(this.logger, this.name, "Initialization error");
        }
    }

    private boolean initLines() {
        boolean result = true;
        try (Statement st = this.database.getConnection().createStatement();){
            this.statement = st;
            this.livedata.load();
            for (KkLine line : this.lines) {
                line.loadLiveData();
            }
            for (KkLine line : this.lines) {
                line.init();
            }
            this.database.commit();
        }
        catch (SQLException e) {
            this.env.printError(this.logger, e, this.name);
            this.database.rollback();
            result = false;
        }
        this.statement = null;
        return result;
    }

    @Override
    public boolean executeModule() {
        if (this.emulated) {
            return true;
        }
        if (!this.connected || !this.database.isConnected()) {
            return true;
        }
        Connection con = this.database.getConnection();
        try (Statement st = con.createStatement();){
            this.statement = st;
            for (KkLine line : this.lines) {
                line.execute();
            }
            this.livedata.update();
            st.close();
            this.database.commit();
        }
        catch (Exception e) {
            this.env.printError(this.logger, e, this.name);
            this.database.rollback();
        }
        this.statement = null;
        return true;
    }

    @Override
    public boolean closedownModule() {
        if (this.enable) {
            this.connected = false;
            this.tagConnected.setBool(false);
            if (this.database != null) {
                this.database.removeSignalListener(this);
            }
        }
        return true;
    }

    public DateTimeFormatter getFormatter() {
        return this.formatter;
    }

    @Override
    public String getInfo() {
        if (!this.enable) {
            return "disabled";
        }
        if (this.emulated) {
            return "emulated";
        }
        return "database=" + this.databaseModuleName + " " + (this.connected ? "" : ANSI.redBold("NOT CONNECTED! ")) + "\r\n" + this.lines.stream().map(KkLine::getInfo).collect(Collectors.joining("\r\n"));
    }

    @Override
    public String check() {
        return this.lines.stream().map(KkLine::getProblems).filter(s -> !s.isEmpty()).collect(Collectors.joining("\r\n \r\n"));
    }

    @Override
    protected boolean reload() {
        KkormsvrModule tmp = new KkormsvrModule(this.plugin, this.name);
        if (!tmp.load()) {
            return false;
        }
        this.closedown();
        this.copySettingsFrom(tmp);
        this.tagtable.removeAll();
        tmp.tagtable.values().forEach(tag -> this.tagtable.add(tag));
        tmp.tagtable.clear();
        this.tagConnected = tmp.tagConnected;
        this.lines = tmp.lines;
        this.prepare();
        return true;
    }
}

