/*
 * Decompiled with CFR 0.152.
 */
package promauto.jroboplc.plugin.motohr;

import java.sql.SQLException;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import promauto.jroboplc.core.api.Configuration;
import promauto.jroboplc.core.api.Tag;
import promauto.jroboplc.core.exceptions.ConfigurationNotValidException;
import promauto.jroboplc.plugin.motohr.Context;
import promauto.jroboplc.plugin.motohr.CounterType;
import promauto.jroboplc.plugin.motohr.Mach;
import promauto.jroboplc.plugin.motohr.MachState;

public class MachGroup {
    public static Set<String> cacheMachName;
    private final Context ctx;
    public final List<CounterType> counterTypes;
    public final Pattern patternTag;
    public final Pattern patternDescr;
    public final Pattern patternIncludeTag;
    public final Pattern patternExcludeTag;
    public final Pattern patternIncludeDescr;
    public final Pattern patternExcludeDescr;
    public final String prefix;
    public final String replDescr;

    public MachGroup(Context ctx, Object conf) throws ConfigurationNotValidException {
        this.ctx = ctx;
        this.counterTypes = new LinkedList<CounterType>();
        Configuration cm = ctx.env.getConfiguration();
        this.patternTag = Pattern.compile(cm.get(conf, "expr.tag", ".*\\.MCHB_(.*)_Plata"));
        this.patternDescr = Pattern.compile(cm.get(conf, "expr.descr", "(.*)(MCHB.*)(_Plata)"));
        this.replDescr = cm.get(conf, "repl.descr", "$1$2.descr");
        this.prefix = cm.get(conf, "prefix", "");
        String exprIncludeTag = cm.get(conf, "include.tag", "");
        String exprExcludeTag = cm.get(conf, "exclude.tag", "");
        String exprIncludeDescr = cm.get(conf, "include.descr", "");
        String exprExcludeDescr = cm.get(conf, "exclude.descr", "");
        this.patternIncludeTag = this.compilePattern(exprIncludeTag);
        this.patternExcludeTag = this.compilePattern(exprExcludeTag);
        this.patternIncludeDescr = this.compilePattern(exprIncludeDescr);
        this.patternExcludeDescr = this.compilePattern(exprExcludeDescr);
        for (String ctname : cm.getStringList(conf, "counters")) {
            CounterType ct = ctx.counterTypes.get(ctname);
            if (ct == null) {
                cm.throwConfigurationNotValidException("MachGroup has unknown counter type: " + ctname);
                continue;
            }
            if (this.counterTypes.contains(ct)) continue;
            this.counterTypes.add(ct);
        }
    }

    private Pattern compilePattern(String expr) {
        if (expr.isEmpty()) {
            return null;
        }
        return Pattern.compile(expr);
    }

    public static void initAll(Context ctx) throws SQLException {
        ctx.machs.forEach(Mach::remove);
        ctx.machs.clear();
        cacheMachName = new HashSet<String>();
        MachState.cache = ctx.service.getMachStates();
        Mach.cacheDescrs = ctx.service.getMachDescrs();
        for (MachGroup mg : ctx.machGroups) {
            mg.init();
        }
        for (Mach mach : ctx.machs) {
            mach.init();
        }
        MachState.cache.clear();
        Mach.cacheDescrs.clear();
        cacheMachName.clear();
    }

    public void init() throws SQLException {
        Map<String, Tag> alltags = this.ctx.env.getModuleManager().getTagsAll();
        for (String tagname : alltags.keySet()) {
            String descrTagname;
            Tag tagDescr;
            Matcher matcherTag = this.patternTag.matcher(tagname);
            if (!matcherTag.find() || !this.checkPattern(this.patternIncludeTag, tagname, true) || !this.checkPattern(this.patternExcludeTag, tagname, false)) continue;
            Tag tag = alltags.get(tagname);
            String name = this.prefix + matcherTag.group(1);
            String descr = "";
            Matcher matcherDescr = this.patternDescr.matcher(tagname);
            if (matcherDescr.find() && (tagDescr = alltags.get(descrTagname = matcherDescr.replaceFirst(this.replDescr))) != null) {
                descr = tagDescr.getString();
            }
            if (!this.checkPattern(this.patternIncludeDescr, descr, true) || !this.checkPattern(this.patternExcludeDescr, descr, false) || cacheMachName.contains(name)) continue;
            Mach mach = new Mach(this.ctx, tag, tagname, name, descr);
            this.ctx.machs.add(mach);
            cacheMachName.add(mach.name);
        }
    }

    private boolean checkPattern(Pattern pattern, String text, boolean match) {
        return pattern == null || pattern.matcher(text).matches() == match;
    }
}

