/*
 * Decompiled with CFR 0.152.
 */
package promauto.jroboplc.plugin.motohr;

import java.sql.SQLException;
import java.time.LocalDateTime;
import java.time.temporal.ChronoUnit;
import promauto.jroboplc.core.TagTable;
import promauto.jroboplc.core.tags.TagRW;
import promauto.jroboplc.plugin.motohr.Context;

public class SysUtil {
    private final Context ctx;
    private TagRW tagSysUtil;
    private String[] args;
    private String answer;

    public SysUtil(Context ctx) {
        this.ctx = ctx;
    }

    public void load() {
        TagTable tt = this.ctx.tagtable;
        this.tagSysUtil = tt.createRWString("system.util", "");
    }

    public void execute() throws SQLException {
        if (!this.tagSysUtil.hasWriteValue()) {
            return;
        }
        this.answer = "";
        try {
            this.args = this.tagSysUtil.getWriteValString().split(" ");
            switch (this.args[0]) {
                case "help": {
                    this.doHelp();
                    break;
                }
                case "sweep-interval": {
                    this.doSweepInterval();
                    break;
                }
                case "sweep-stat": {
                    this.doSweepStat();
                    break;
                }
                case "pack-mach": {
                    this.doPackMach();
                    break;
                }
                case "reinit": {
                    this.doReinit();
                }
            }
        }
        catch (Exception e) {
            this.answer = e.getMessage();
        }
        this.tagSysUtil.setReadValString(this.answer);
    }

    private void doHelp() {
        this.answer = "help   \npack-mach   \nsweep-interval <yyyymm>   \nsweep-stat <yyyymm>   \nreinit";
    }

    private void doSweepInterval() throws SQLException {
        if (this.args.length != 2) {
            return;
        }
        int ym = Integer.parseInt(this.args[1]);
        LocalDateTime dt = LocalDateTime.of(Math.abs(ym / 100), ym % 100, 1, 0, 0).plus(1L, ChronoUnit.MONTHS);
        int res = this.ctx.service.sweepInterval(dt);
        this.answer = "Deleted " + res + " records from MH_INTERVAL";
    }

    private void doSweepStat() throws SQLException {
        if (this.args.length != 2) {
            return;
        }
        int period = Integer.parseInt(this.args[1]) * 100 + 31;
        int res = this.ctx.service.sweepStat(period);
        this.answer = "Deleted " + res + " records from MH_STAT";
    }

    private void doPackMach() throws SQLException {
        int res = this.ctx.service.packMach();
        this.answer = "Deleted " + res + " records from MH_MACH";
    }

    private void doReinit() {
        this.ctx.module.raiseNeedInit();
    }
}

