/*
 * Decompiled with CFR 0.152.
 */
package promauto.jroboplc.plugin.peripherial;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import promauto.jroboplc.core.api.Configuration;
import promauto.jroboplc.core.api.Plugin;
import promauto.jroboplc.core.api.Tag;
import promauto.jroboplc.core.tags.TagRW;
import promauto.jroboplc.plugin.peripherial.PeripherialModule;
import promauto.jroboplc.plugin.peripherial.SchuleFlowModule;
import promauto.utils.CRC;

public class MercuryM230Module
extends PeripherialModule {
    private final Logger logger = LoggerFactory.getLogger(SchuleFlowModule.class);
    private static int MERCURY_RD_SERIAL_CNT = 120;
    protected Tag tagSerialNumberH;
    protected Tag tagSerialNumberL;
    protected Tag tagDayManuf;
    protected Tag tagMonthManuf;
    protected Tag tagYearManuf;
    protected Tag tagSessionOpened;
    protected Tag tagPSumAfterResetH;
    protected Tag tagPSumAfterResetL;
    protected Tag tagPSumForYearH;
    protected Tag tagPSumForYearL;
    protected Tag tagCrc;
    protected TagRW tagWesSvrState;
    protected Tag[] crcTags;
    protected int askingCnt = 120;
    private static int BUFF_SIZE = 60;
    protected int[] buffin = new int[BUFF_SIZE];
    protected int[] buffout = new int[BUFF_SIZE];
    protected int accessLevel = 1;
    protected String password = "11111";

    public MercuryM230Module(Plugin plugin, String name) {
        super(plugin, name);
    }

    @Override
    public boolean loadPeripherialModule(Object conf) {
        Configuration cm = this.env.getConfiguration();
        this.accessLevel = cm.get(conf, "access", 1);
        this.password = cm.get(conf, "password", "111111");
        this.tagCrc = this.tagtable.createInt("Crc", 0);
        this.tagSerialNumberH = this.tagtable.createInt("SerialNumberH", 0, 8);
        this.tagSerialNumberL = this.tagtable.createInt("SerialNumberL", 0, 8);
        this.tagDayManuf = this.tagtable.createInt("DayManuf", 0, 8);
        this.tagMonthManuf = this.tagtable.createInt("MonthManuf", 0, 8);
        this.tagYearManuf = this.tagtable.createInt("YearManuf", 0, 8);
        this.tagSessionOpened = this.tagtable.createInt("SessionOpened", 0, 8);
        this.tagPSumAfterResetH = this.tagtable.createInt("PSumAfterResetH", 0, 8);
        this.tagPSumAfterResetL = this.tagtable.createInt("PSumAfterResetL", 0, 8);
        this.tagPSumForYearH = this.tagtable.createInt("PSumForYearH", 0, 8);
        this.tagPSumForYearL = this.tagtable.createInt("PSumForYearL", 0, 8);
        this.tagWesSvrState = this.tagtable.createRWInt("WesSvrState", 0);
        this.crcTags = new Tag[]{this.tagSerialNumberH, this.tagSerialNumberL, this.tagPSumAfterResetH, this.tagPSumAfterResetL};
        this.initCrc16Tags();
        return true;
    }

    @Override
    public boolean executePeripherialModule() {
        boolean result = true;
        if (!this.emulated) {
            try {
                this.buffout[0] = this.netaddr;
                this.buffout[1] = 1;
                this.buffout[2] = 1;
                this.buffout[3] = 1;
                this.buffout[4] = 1;
                this.buffout[5] = 1;
                this.buffout[6] = 1;
                this.buffout[7] = 1;
                this.buffout[8] = 1;
                int crc = CRC.getCrc16(this.buffout, 9);
                this.buffout[9] = crc & 0xFF;
                this.buffout[10] = crc >> 8 & 0xFF;
                result = this.request(11, 4);
                if (result) {
                    this.tagSessionOpened.setInt(1);
                    this.buffout[0] = this.netaddr;
                    this.buffout[1] = 5;
                    this.buffout[2] = 0;
                    this.buffout[3] = 0;
                    crc = CRC.getCrc16(this.buffout, 4);
                    this.buffout[4] = crc & 0xFF;
                    this.buffout[5] = crc >> 8 & 0xFF;
                    result = this.request(6, 19);
                    if (result) {
                        int pH = 0;
                        pH = (this.buffin[2] << 8) + this.buffin[1];
                        int pL = 0;
                        pL = (this.buffin[4] << 8) + this.buffin[3];
                        this.tagPSumAfterResetH.setInt(pH);
                        this.tagPSumAfterResetL.setInt(pL);
                        if (this.askingCnt >= MERCURY_RD_SERIAL_CNT) {
                            this.buffout[0] = this.netaddr;
                            this.buffout[1] = 8;
                            this.buffout[2] = 0;
                            crc = CRC.getCrc16(this.buffout, 3);
                            this.buffout[3] = crc & 0xFF;
                            this.buffout[4] = crc >> 8 & 0xFF;
                            result = this.request(5, 10);
                            if (result) {
                                this.tagSerialNumberH.setInt((this.buffin[2] << 8) + this.buffin[1]);
                                this.tagSerialNumberL.setInt((this.buffin[4] << 8) + this.buffin[3]);
                                this.tagDayManuf.setInt(this.buffin[5]);
                                this.tagMonthManuf.setInt(this.buffin[6]);
                                this.tagYearManuf.setInt(this.buffin[7]);
                            }
                            this.askingCnt = 0;
                        } else {
                            ++this.askingCnt;
                        }
                    }
                } else {
                    this.tagSessionOpened.setInt(0);
                }
            }
            catch (Exception e) {
                this.env.printError(this.logger, e, this.name);
                result = false;
            }
        }
        return result;
    }

    @Override
    protected void initCrc16Tags() {
        super.initCrc16Tags();
        for (Tag tag : this.crcTags) {
            this.crc16Tags.add(tag);
        }
        this.crc16Tags.add(this.tagError);
    }

    private boolean request(int iSizeOut, int iSizeIn) throws Exception {
        if (this.port == null) {
            return false;
        }
        for (int trynum = 0; trynum < this.retrial; ++trynum) {
            this.port.discard();
            this.port.writeBytes(this.buffout, iSizeOut);
            int n = this.port.readBytes(this.buffin, iSizeIn);
            int crc = CRC.getCrc16(this.buffin, iSizeIn - 2);
            if ((crc & 0xFF) == this.buffin[iSizeIn - 2] && (crc >> 8 & 0xFF) == this.buffin[iSizeIn - 1] && this.buffin[0] == this.netaddr) {
                return true;
            }
            boolean badcrc = true;
            if (this.canLogError()) {
                int cntRead = Math.abs(n);
                this.logError(trynum, badcrc, this.buffout, BUFF_SIZE, this.buffin, cntRead, "");
            }
            try {
                Thread.sleep(20L);
                continue;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        this.tagErrorCnt.setInt(this.tagErrorCnt.getInt() + 1);
        return false;
    }
}

