/*
 * Decompiled with CFR 0.152.
 */
package promauto.jroboplc.plugin.peripherial;

import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import promauto.jroboplc.core.api.Plugin;
import promauto.jroboplc.core.tags.TagRW;
import promauto.jroboplc.plugin.peripherial.PeripherialModule;
import promauto.jroboplc.plugin.peripherial.ProtocolModbus;

public class OwenMu110_16rModule
extends PeripherialModule {
    private final Logger logger = LoggerFactory.getLogger(OwenMu110_16rModule.class);
    protected ProtocolModbus protocol = new ProtocolModbus(this);
    protected TagRW tagTOut;
    protected TagRW[] tagOut = null;
    protected int reqOut;
    protected int curOut;
    protected final int size;
    protected final int regOut;
    protected final int regTOut;

    public OwenMu110_16rModule(Plugin plugin, String name) {
        super(plugin, name);
        this.size = 16;
        this.regOut = 50;
        this.regTOut = 48;
    }

    @Override
    public boolean loadPeripherialModule(Object conf) {
        this.tagTOut = this.protocol.addWriteTag(48, this.tagtable.createRWInt("TOut", 0, 8));
        if (this.tagOut == null) {
            this.tagOut = new TagRW[this.size];
        }
        for (int i = 0; i < this.size; ++i) {
            this.tagOut[i] = this.tagtable.createRWInt(String.format("out%02d", i), 0, 8);
        }
        this.reqOut = 0;
        return true;
    }

    @Override
    protected void initChannelMap(List<String> chtags) {
        for (int i = 0; i < this.size; ++i) {
            this.addChannelMapTag(chtags, this.tagOut[i], "" + i);
        }
    }

    @Override
    public boolean executePeripherialModule() {
        if (this.emulated) {
            this.tagTOut.acceptWriteValue();
            for (int i = 0; i < this.size; ++i) {
                this.tagOut[i].acceptWriteValue();
            }
            return true;
        }
        boolean result = true;
        try {
            if (result) {
                result = this.protocol.sendWriteTags(16);
            }
            if (result) {
                for (int i = 0; i < this.size; ++i) {
                    if (!this.tagOut[i].hasWriteValue()) continue;
                    if (this.tagOut[i].getWriteValBool()) {
                        this.reqOut |= 1 << i;
                        continue;
                    }
                    this.reqOut &= ~(1 << i);
                }
            }
            result &= this.writeOutputs();
            if ((result &= this.readOutputs()) && (this.firstPass || this.tagError.getBool()) && (result = this.protocol.requestCmd3(this.regTOut, 1))) {
                this.tagTOut.setReadValInt(this.protocol.getAnswerWord(0));
            }
        }
        catch (Exception e) {
            this.env.printError(this.logger, e, this.name);
            result = false;
        }
        return result;
    }

    protected boolean writeOutputs() throws Exception {
        if (this.curOut == this.reqOut) {
            return true;
        }
        return this.protocol.requestCmd10(this.regOut, 1, this.reqOut);
    }

    protected boolean readOutputs() throws Exception {
        if (!this.protocol.requestCmd3(this.regOut, 1)) {
            return false;
        }
        this.curOut = this.protocol.getAnswerWord(0);
        for (int i = 0; i < this.size; ++i) {
            this.tagOut[i].setReadValInt(this.curOut >> i & 1);
        }
        return true;
    }

    @Override
    protected boolean reload() {
        OwenMu110_16rModule tmp = new OwenMu110_16rModule(this.plugin, this.name);
        if (!tmp.load()) {
            return false;
        }
        this.copySettingsFrom(tmp);
        this.reqOut = tmp.reqOut;
        this.curOut = tmp.curOut;
        return true;
    }
}

