/*
 * Decompiled with CFR 0.152.
 */
package promauto.jroboplc.plugin.peripherial;

import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import promauto.jroboplc.core.api.Plugin;
import promauto.jroboplc.core.tags.TagRW;
import promauto.jroboplc.plugin.peripherial.PeripherialModule;
import promauto.jroboplc.plugin.peripherial.ProtocolModbus;

public class OwenMu110_8iModule
extends PeripherialModule {
    private final Logger logger = LoggerFactory.getLogger(OwenMu110_8iModule.class);
    protected ProtocolModbus protocol = new ProtocolModbus(this);
    protected TagRW tagTOut;
    protected TagRW[] tagOut = null;
    protected TagRW[] tagAlm = null;
    protected final int size;
    protected final int regOut;
    protected final int regAlm;
    protected final int regTOut;

    public OwenMu110_8iModule(Plugin plugin, String name) {
        super(plugin, name);
        this.size = 8;
        this.regOut = 0;
        this.regAlm = 16;
        this.regTOut = 48;
    }

    @Override
    public boolean loadPeripherialModule(Object conf) {
        this.tagTOut = this.protocol.addWriteTag(48, this.tagtable.createRWInt("TOut", 0, 8));
        if (this.tagOut == null) {
            this.tagOut = new TagRW[this.size];
            this.tagAlm = new TagRW[this.size];
        }
        for (int i = 0; i < this.size; ++i) {
            this.tagOut[i] = this.protocol.addWriteTag(this.regOut + i, this.tagtable.createRWInt(String.format("out%02d", i), 0, 8));
            this.tagAlm[i] = this.protocol.addWriteTag(this.regOut + i, this.tagtable.createRWInt(String.format("alm%02d", i), 0, 9));
        }
        return true;
    }

    @Override
    protected void initChannelMap(List<String> chtags) {
        for (int i = 0; i < this.size; ++i) {
            this.addChannelMapTag(chtags, this.tagOut[i], "" + i);
        }
    }

    @Override
    public boolean executePeripherialModule() {
        if (this.emulated) {
            this.tagTOut.acceptWriteValue();
            for (int i = 0; i < this.size; ++i) {
                this.tagOut[i].acceptWriteValue();
                this.tagAlm[i].acceptWriteValue();
            }
            return true;
        }
        boolean result = true;
        try {
            if (result) {
                result = this.protocol.sendWriteTags(16);
            }
            if ((result &= this.read(this.tagOut, this.regOut)) && (this.firstPass || this.tagError.getBool())) {
                result = this.protocol.requestCmd3(this.regTOut, 1);
                if (result) {
                    this.tagTOut.setReadValInt(this.protocol.getAnswerWord(0));
                }
                result &= this.read(this.tagAlm, this.regAlm);
            }
        }
        catch (Exception e) {
            this.env.printError(this.logger, e, this.name);
            result = false;
        }
        return result;
    }

    protected boolean read(TagRW[] tags, int addr) throws Exception {
        if (!this.protocol.requestCmd3(addr, this.size)) {
            return false;
        }
        for (int i = 0; i < this.size; ++i) {
            tags[i].setReadValInt(this.protocol.getAnswerWord(i));
        }
        return true;
    }
}

