/*
 * Decompiled with CFR 0.152.
 */
package promauto.jroboplc.plugin.peripherial;

import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import promauto.jroboplc.core.api.Configuration;
import promauto.jroboplc.core.api.Plugin;
import promauto.jroboplc.core.api.Tag;
import promauto.jroboplc.core.tags.TagRW;
import promauto.jroboplc.plugin.peripherial.PeripherialModule;
import promauto.jroboplc.plugin.peripherial.ProtocolAA55;

public class PaPdatModule
extends PeripherialModule {
    private final Logger logger = LoggerFactory.getLogger(PaPdatModule.class);
    protected ProtocolAA55 protocol = new ProtocolAA55(this);
    private static final int INP_SIZE = 64;
    private static final int PACKS_AMOUNT = 4;
    private static final int PACK_SIZE = 16;
    private static final int RPT = 3;
    private static final float RPTA = 4000000.0f;
    private static final int DEL = 141;
    private static final int SUB = 4000;
    protected Tag[] inps = new Tag[64];
    protected Tag[] frqs = new Tag[64];
    private final int[] buffin = new int[17];
    private final int[] buffout = new int[2];
    private final int[] tmp = new int[64];
    private TagRW tagFirmware;
    private Tag tagResetCnt;
    private int resetCntPeriod;
    private boolean noFreq;

    public PaPdatModule(Plugin plugin, String name) {
        super(plugin, name);
    }

    @Override
    public boolean loadPeripherialModule(Object conf) {
        Configuration cm = this.env.getConfiguration();
        this.resetCntPeriod = cm.get(conf, "resetCntPeriod_s", 0) * 1000;
        this.noFreq = cm.get(conf, "noFreq", false);
        for (int i = 0; i < 64; ++i) {
            this.inps[i] = this.tagtable.createInt((i < 10 ? "inp0" : "inp") + i, 0, 8);
            if (this.noFreq) continue;
            this.frqs[i] = this.tagtable.createInt((i < 10 ? "frq0" : "frq") + i, 0, 8);
        }
        this.tagFirmware = this.tagtable.createRWString("firmware", "");
        this.tagResetCnt = this.tagtable.createInt("resetcnt", 0);
        return true;
    }

    @Override
    protected void initChannelMap(List<String> chtags) {
        for (int i = 0; i < 64; ++i) {
            this.addChannelMapTag(chtags, this.inps[i], "" + i);
            if (this.noFreq) continue;
            this.addChannelMapTag(chtags, this.frqs[i], i + "a");
        }
    }

    @Override
    public boolean executePeripherialModule() {
        if (this.emulated) {
            return true;
        }
        boolean result = true;
        try {
            if (result && (this.firstPass || this.tagError.getBool())) {
                result = this.protocol.requestFirmware(this.tagFirmware);
            }
            if (result) {
                this.buffout[0] = 85;
                this.buffout[1] = 160 + this.netaddr;
                result = this.protocol.request(this.buffout, 2, this.buffin, 9, 0);
                if (result) {
                    int mask = 1;
                    int i = 0;
                    while (i < 64) {
                        if (mask > 128) {
                            mask = 1;
                        }
                        this.tmp[i] = (this.buffin[i / 8] & mask) > 0 ? 1 : 0;
                        ++i;
                        mask <<= 1;
                    }
                    for (i = 0; i < 64; ++i) {
                        this.inps[i].setInt(this.tmp[ProtocolAA55.pRksDatConv[i]]);
                    }
                }
            }
            if (result && !this.noFreq) {
                this.buffout[0] = 85;
                int cmd = 32;
                this.buffout[1] = cmd + this.netaddr;
                int idx = 0;
                for (int pack = 0; pack < 4; ++pack) {
                    if (this.protocol.request(this.buffout, 2, this.buffin, 17, 0)) {
                        int i = 0;
                        while (i < 16) {
                            this.tmp[idx] = Math.round(4000000.0f / (float)(this.buffin[i] * 141 + 4000));
                            ++i;
                            ++idx;
                        }
                    } else {
                        result = false;
                        break;
                    }
                    this.buffout[1] = (cmd += 32) + this.netaddr;
                }
                if (result) {
                    for (int i = 0; i < 64; ++i) {
                        this.frqs[i].setInt(this.tmp[ProtocolAA55.pRksDatConv[i]]);
                    }
                }
            }
            result &= this.protocol.requestResetCnt(this.tagResetCnt, this.resetCntPeriod);
        }
        catch (Exception e) {
            this.env.printError(this.logger, e, this.name);
            result = false;
        }
        return result;
    }

    @Override
    protected boolean reload() {
        PaPdatModule tmp = new PaPdatModule(this.plugin, this.name);
        if (!tmp.load() || !tmp.prepare()) {
            return false;
        }
        this.copySettingsFrom(tmp);
        if (!this.noFreq && tmp.noFreq) {
            for (Tag tag : this.frqs) {
                this.tagtable.remove(tag);
            }
        }
        if (this.noFreq && !tmp.noFreq) {
            for (int i = 0; i < this.frqs.length; ++i) {
                this.frqs[i] = tmp.frqs[i];
                this.tagtable.add(this.frqs[i]);
            }
        }
        this.noFreq = tmp.noFreq;
        this.resetCntPeriod = tmp.resetCntPeriod;
        return true;
    }
}

