/*
 * Decompiled with CFR 0.152.
 */
package promauto.jroboplc.plugin.peripherial;

import java.time.LocalDateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import promauto.jroboplc.core.api.Plugin;
import promauto.jroboplc.core.api.Tag;
import promauto.jroboplc.core.tags.TagRW;
import promauto.jroboplc.plugin.peripherial.PeripherialModule;
import promauto.jroboplc.plugin.peripherial.ProtocolModbus;

public class PaRFIDReaderModule
extends PeripherialModule {
    private static final int TAGS_IN_RECORD = 5;
    private static final int REGS_IN_RECORD = 4;
    private static final int RECORDS_SIZE = 1;
    private final Logger logger = LoggerFactory.getLogger(PaRFIDReaderModule.class);
    protected ProtocolModbus protocol = new ProtocolModbus(this);
    protected Tag tagCrc;
    protected TagRW tagVersion;
    protected TagRW tagLed0;
    protected TagRW tagLed1;
    protected TagRW tagLed2;
    protected Tag tagState;
    protected Tag tagReadCnt;
    protected Tag tagShiftCnt;
    protected TagRW tagSvrLive;
    private long wesSvrLiveTimer;
    protected Record[] records = new Record[1];
    private int[] buffer = new int[5];
    protected Tag[] crcTags = new Tag[8];
    private boolean needReadVersion;
    private int counter;

    public PaRFIDReaderModule(Plugin plugin, String name) {
        super(plugin, name);
    }

    @Override
    public boolean loadPeripherialModule(Object conf) {
        this.tagCrc = this.tagtable.createInt("crc", 0);
        this.tagVersion = this.tagtable.createRWInt("version", 256, 8);
        this.tagLed0 = this.protocol.addWriteTag(4090, this.tagtable.createRWInt("led0", 0, 8));
        this.tagLed1 = this.protocol.addWriteTag(4094, this.tagtable.createRWInt("led1", 0, 8));
        this.tagLed2 = this.protocol.addWriteTag(4095, this.tagtable.createRWInt("led2", 0, 8));
        int j = 0;
        this.crcTags[j++] = this.tagState = this.tagtable.createInt("state", 0, 8);
        this.crcTags[j++] = this.tagReadCnt = this.tagtable.createInt("cnt.read", 0, 8);
        this.crcTags[j++] = this.tagShiftCnt = this.tagtable.createInt("cnt.shift", 0, 8);
        for (int i = 0; i < 1; ++i) {
            Record r = new Record();
            r.tagCode0 = this.createCrcTagIntRW(j++, "rec" + i + ".code0");
            r.tagCode1 = this.createCrcTagIntRW(j++, "rec" + i + ".code1");
            r.tagCode2 = this.createCrcTagIntRW(j++, "rec" + i + ".code2");
            r.tagDate = this.createCrcTagIntRW(j++, "rec" + i + ".date");
            r.tagTime = this.createCrcTagIntRW(j++, "rec" + i + ".time");
            this.records[i] = r;
        }
        this.protocol.adjustBuffers(0, this.crcTags.length * 2);
        this.tagSvrLive = this.tagtable.createRWInt("SvrLive", 0, 8);
        return true;
    }

    private TagRW createCrcTagIntRW(int idxCrcTag, String tagname) {
        TagRW tag = this.tagtable.createRWInt(tagname, 0, 8);
        this.crcTags[idxCrcTag] = tag;
        return tag;
    }

    @Override
    protected boolean preparePeripherialModule() {
        this.needReadVersion = true;
        this.counter = -1;
        return true;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public boolean executePeripherialModule() {
        result = true;
        if (this.emulated) {
            this.tagVersion.acceptWriteValue();
            this.tagLed0.acceptWriteValue();
            this.tagLed1.acceptWriteValue();
            this.tagLed2.acceptWriteValue();
            for (Record rec : this.records) {
                rec.tagCode0.acceptWriteValue();
                rec.tagCode1.acceptWriteValue();
                rec.tagCode2.acceptWriteValue();
                rec.tagDate.acceptWriteValue();
                rec.tagTime.acceptWriteValue();
            }
        } else {
            try {
                result = this.protocol.sendWriteTags(6);
                if (result && this.needReadVersion && (result = this.protocol.requestCmd3(257, 1))) {
                    this.tagVersion.setReadValInt(this.protocol.getAnswerWord(0));
                    this.needReadVersion = false;
                }
                tmpCounter = this.counter;
                hasDataInBuffer = false;
                curdt = null;
                while (result) {
                    result = this.protocol.requestCmd3(4096, 2);
                    if (!result) continue;
                    this.tagState.setInt(this.protocol.getAnswerWord(0));
                    if (tmpCounter == this.protocol.getAnswerWord(1)) break;
                    tmpCounter = this.protocol.getAnswerWord(1);
                    curdt = LocalDateTime.now();
                    result = result != false && this.readBuffer(4098, 0, 4) != false;
                    hasDataInBuffer = true;
                }
                if (result && hasDataInBuffer) {
                    this.counter = tmpCounter;
                    this.tagReadCnt.setInt(this.counter & 255);
                    this.tagShiftCnt.setInt(this.counter >> 8 & 255);
                    j = 0;
                    for (i = 0; i < 1; ++i) {
                        if (this.buffer[j + 3] == 65535) {
                            this.records[i].tagCode0.setReadValInt(0);
                            this.records[i].tagCode1.setReadValInt(0);
                            this.records[i].tagCode2.setReadValInt(0);
                            this.records[i].tagDate.setReadValInt(0);
                            this.records[i].tagTime.setReadValInt(0);
                            j += 4;
                            continue;
                        }
                        this.records[i].tagCode0.setReadValInt(this.buffer[j++]);
                        this.records[i].tagCode1.setReadValInt(this.buffer[j++]);
                        this.records[i].tagCode2.setReadValInt(this.buffer[j++]);
                        ldt = curdt.minusSeconds(this.buffer[j++]);
                        this.records[i].tagDate.setReadValInt(ldt.getYear() % 100 * 10000 + ldt.getMonthValue() * 100 + ldt.getDayOfMonth());
                        this.records[i].tagTime.setReadValInt(ldt.getHour() * 10000 + ldt.getMinute() * 100 + ldt.getSecond());
                    }
                }
                if (result) ** GOTO lbl69
                this.needReadVersion = true;
            }
            catch (Exception e) {
                this.env.printError(this.logger, e, new String[]{this.name});
                result = false;
            }
        }
lbl69:
        // 4 sources

        this.calcTagCrc8(this.crcTags, this.tagCrc, this.protocol.buffin);
        this.wesSvrLiveTimer = PaRFIDReaderModule.updateWesSvrState(this.tagSvrLive, this.wesSvrLiveTimer);
        return result;
    }

    private boolean readBuffer(int regaddr, int offset, int size) throws Exception {
        if (!this.protocol.requestCmd3(regaddr, size)) {
            return false;
        }
        for (int i = 0; i < size; ++i) {
            this.buffer[offset + i] = this.protocol.getAnswerWord(i);
        }
        return true;
    }

    private class Record {
        public TagRW tagCode0;
        public TagRW tagCode1;
        public TagRW tagCode2;
        public TagRW tagDate;
        public TagRW tagTime;

        private Record() {
        }
    }
}

