/*
 * Decompiled with CFR 0.152.
 */
package promauto.jroboplc.plugin.peripherial;

import promauto.jroboplc.plugin.peripherial.PeripherialModule;
import promauto.utils.Numbers;

public class ProtocolOmronFins {
    private static final int BUFFIN_STATUS_OFFSET = 2;
    private static final int BUFFIN_DATA_OFFSET = 4;
    public int[] buffin = new int[0];
    public int[] buffout = new int[0];
    private int answerStatus = 0;
    private PeripherialModule module;

    public ProtocolOmronFins(PeripherialModule module) {
        this.module = module;
    }

    public static int getElementSize(int r) {
        if (r >= 48 && r <= 51 || r == 2 || r >= 32 && r <= 44 || r == 6 || r == 7) {
            return 1;
        }
        if (r >= 176 && r <= 179 || r == 130 || r >= 160 && r <= 172 || r == 152 || r == 7) {
            return 2;
        }
        return 0;
    }

    public boolean isAnswerStatusOk() {
        return this.buffin.length >= 4 && this.buffin[2] == 0 && this.buffin[3] == 0;
    }

    private void updateLastBadAnswerStatus() {
        if (this.answerStatus == 0 && this.buffin.length >= 4) {
            this.answerStatus = Numbers.bytesToWord(this.buffin, 2);
        }
    }

    public int getLastBadAnswerStatus() {
        return this.answerStatus;
    }

    public void resetLastBadAnswerStatus() {
        this.answerStatus = 0;
    }

    public int getDataByte(int pos) {
        return this.buffin[pos + 4];
    }

    public int getDataWord(int pos) {
        return Numbers.bytesToWord(this.buffin, pos + 4);
    }

    public int getAnswerInt(int pos) {
        return Numbers.bytesToInt(this.buffin, pos + 4);
    }

    public void adjustBuffout(int size) {
        if (this.buffout.length < size) {
            this.buffout = new int[size];
        }
    }

    public void adjustBuffin(int size) {
        if (this.buffin.length < size) {
            this.buffin = new int[size];
        }
    }

    public boolean request0101(int region, int elementsize, int addressbit, int num) throws Exception {
        this.adjustBuffout(8);
        this.buffout[0] = 1;
        this.buffout[1] = 1;
        this.buffout[2] = region;
        this.buffout[3] = addressbit >> 12 & 0xFF;
        this.buffout[4] = addressbit >> 4 & 0xFF;
        this.buffout[5] = addressbit & 0xF;
        this.buffout[6] = num >> 8 & 0xFF;
        this.buffout[7] = num & 0xFF;
        return this.request(8, elementsize * num + 4);
    }

    public boolean request0102(int region, int elementsize, int addressbit, int num, int begidx, int lastidx, SetDataBuffoutFunction setdata) throws Exception {
        int sizeout = elementsize * num + 8;
        this.adjustBuffout(sizeout);
        this.buffout[0] = 1;
        this.buffout[1] = 2;
        this.buffout[2] = region;
        this.buffout[3] = addressbit >> 12 & 0xFF;
        this.buffout[4] = addressbit >> 4 & 0xFF;
        this.buffout[5] = addressbit & 0xF;
        this.buffout[6] = num >> 8 & 0xFF;
        this.buffout[7] = num & 0xFF;
        int k = 8;
        for (int i = begidx; i <= lastidx; ++i) {
            k += setdata.apply(i, k);
        }
        return this.request(sizeout, 4);
    }

    public boolean request0104(int num, int datasizein, int begidx, int lastidx, SetDataBuffoutFunction setdata) throws Exception {
        int sizeout = num * 4 + 2;
        this.adjustBuffout(sizeout);
        this.buffout[0] = 1;
        this.buffout[1] = 4;
        int k = 2;
        for (int i = begidx; i <= lastidx; ++i) {
            k += setdata.apply(i, k);
        }
        return this.request(sizeout, datasizein + 4);
    }

    public boolean request(int sizeout, int sizein) throws Exception {
        this.adjustBuffin(sizein);
        for (int trynum = 0; trynum < this.module.retrial; ++trynum) {
            this.module.port.discard();
            this.module.delayBeforeWrite();
            this.module.port.writeBytes(this.buffout, sizeout);
            int cntRead = this.module.port.readBytes(this.buffin, sizein);
            if (cntRead == sizein) {
                this.updateLastBadAnswerStatus();
                return true;
            }
            if (this.module.canLogError()) {
                this.module.logError(trynum, false, this.buffout, sizeout, this.buffin, cntRead, "inp len expected = " + sizein);
            }
            this.module.delayAfterError();
        }
        this.module.tagErrorCnt.setInt(this.module.tagErrorCnt.getInt() + 1);
        return false;
    }

    @FunctionalInterface
    public static interface SetDataBuffoutFunction {
        public int apply(int var1, int var2);
    }
}

