/*
 * Decompiled with CFR 0.152.
 */
package promauto.jroboplc.plugin.peripherial;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import promauto.jroboplc.core.api.Configuration;
import promauto.jroboplc.core.api.Plugin;
import promauto.jroboplc.core.api.Tag;
import promauto.jroboplc.core.tags.TagRW;
import promauto.jroboplc.plugin.peripherial.PeripherialModule;
import promauto.jroboplc.plugin.peripherial.ProtocolTenzom;

@Deprecated
public class TenzomTb09Module
extends PeripherialModule {
    private final Logger logger = LoggerFactory.getLogger(TenzomTb09Module.class);
    protected ProtocolTenzom protocol = new ProtocolTenzom(this);
    protected Tag tagSumWeightHigh;
    protected Tag tagSumWeightLow;
    protected Tag tagSumWeight;
    protected Tag tagSumNumHigh;
    protected Tag tagSumNumLow;
    protected Tag tagSumNum;
    protected Tag tagLastWeightHigh;
    protected Tag tagLastWeightLow;
    protected Tag tagLastWeight;
    protected Tag tagLastTimeHigh;
    protected Tag tagLastTimeLow;
    protected Tag tagLastTime;
    protected Tag tagOutputHigh;
    protected Tag tagOutputLow;
    protected Tag tagOutput;
    protected TagRW tagVersion;
    protected TagRW tagWesSvrState;
    private long wesSvrStateTimer;

    public TenzomTb09Module(Plugin plugin, String name) {
        super(plugin, name);
    }

    @Override
    public boolean loadPeripherialModule(Object conf) {
        Configuration cm = this.env.getConfiguration();
        int version = cm.get(conf, "version", 0);
        super.initCrc16Tags();
        this.tagSumWeightHigh = this.tagtable.createInt("SumWeightHigh", 0, 8);
        this.crc16Tags.add(this.tagSumWeightHigh);
        this.tagSumWeightLow = this.tagtable.createInt("SumWeightLow", 0, 8);
        this.crc16Tags.add(this.tagSumWeightLow);
        this.tagSumNumHigh = this.tagtable.createInt("SumNumHigh", 0, 8);
        this.crc16Tags.add(this.tagSumNumHigh);
        this.tagSumNumLow = this.tagtable.createInt("SumNumLow", 0, 8);
        this.crc16Tags.add(this.tagSumNumLow);
        this.tagLastWeightHigh = this.tagtable.createInt("LastWeightHigh", 0, 8);
        this.crc16Tags.add(this.tagLastWeightHigh);
        this.tagLastWeightLow = this.tagtable.createInt("LastWeightLow", 0, 8);
        this.crc16Tags.add(this.tagLastWeightLow);
        this.tagLastTimeHigh = this.tagtable.createInt("LastTimeHigh", 0, 8);
        this.crc16Tags.add(this.tagLastTimeHigh);
        this.tagLastTimeLow = this.tagtable.createInt("LastTimeLow", 0, 8);
        this.crc16Tags.add(this.tagLastTimeLow);
        this.tagOutputHigh = this.tagtable.createInt("OutputHigh", 0, 8);
        this.crc16Tags.add(this.tagOutputHigh);
        this.tagOutputLow = this.tagtable.createInt("OutputLow", 0, 8);
        this.crc16Tags.add(this.tagOutputLow);
        this.crc16Tags.add(this.tagError);
        this.tagSumWeight = this.tagtable.createInt("SumWeight ", 0, 8);
        this.tagSumNum = this.tagtable.createInt("SumNum", 0, 8);
        this.tagLastWeight = this.tagtable.createInt("LastWeight", 0, 8);
        this.tagLastTime = this.tagtable.createInt("LastTime", 0, 8);
        this.tagOutput = this.tagtable.createInt("Output", 0, 8);
        this.tagVersion = this.tagtable.createRWInt("Version", version, 8);
        this.tagWesSvrState = this.tagtable.createRWInt("WesSvrState", 0);
        return true;
    }

    @Override
    public boolean executePeripherialModule() {
        boolean result = true;
        if (this.emulated) {
            this.tagVersion.acceptWriteValue();
        } else {
            try {
                if (result && (result = this.protocol.requestA(200, 134))) {
                    long w = this.protocol.getBCDValue(8, 5);
                    this.tagSumWeightHigh.setInt((int)(w >> 16));
                    this.tagSumWeightLow.setInt((int)(w & 0xFFFFL));
                    w = this.protocol.getBCDValue(this.tagVersion.getInt() == 0 ? 13 : 18, 5);
                    this.tagSumNumHigh.setInt((int)(w >> 16));
                    this.tagSumNumLow.setInt((int)(w & 0xFFFFL));
                    w = this.tagVersion.getInt() == 0 ? this.protocol.getBCDValue(18, 5) : 0L;
                    this.tagLastWeightHigh.setInt((int)(w >> 16));
                    this.tagLastWeightLow.setInt((int)(w & 0xFFFFL));
                    w = this.protocol.getBCDValue(23, 5);
                    this.tagOutputHigh.setInt((int)(w >> 16));
                    this.tagOutputLow.setInt((int)(w & 0xFFFFL));
                    w = this.protocol.getBCDValue(28, 5);
                    this.tagLastTimeHigh.setInt((int)(w >> 16));
                    this.tagLastTimeLow.setInt((int)(w & 0xFFFFL));
                }
            }
            catch (Exception e) {
                this.env.printError(this.logger, e, this.name);
                result = false;
            }
        }
        this.setDWordTag(this.tagSumWeight, this.tagSumWeightHigh, this.tagSumWeightLow);
        this.setDWordTag(this.tagSumNum, this.tagSumNumHigh, this.tagSumNumLow);
        this.setDWordTag(this.tagLastWeight, this.tagLastWeightHigh, this.tagLastWeightLow);
        this.setDWordTag(this.tagLastTime, this.tagLastTimeHigh, this.tagLastTimeLow);
        this.setDWordTag(this.tagOutput, this.tagOutputHigh, this.tagOutputLow);
        this.wesSvrStateTimer = TenzomTb09Module.updateWesSvrState(this.tagWesSvrState, this.wesSvrStateTimer);
        return result;
    }

    private void setDWordTag(Tag tag, Tag high, Tag low) {
        tag.setInt((int)(((long)high.getInt() << 16) + (long)low.getInt() & Integer.MAX_VALUE));
    }

    @Override
    protected boolean reload() {
        TenzomTb09Module tmp = new TenzomTb09Module(this.plugin, this.name);
        if (!tmp.load()) {
            return false;
        }
        this.copySettingsFrom(tmp);
        this.tagVersion.setReadValInt(tmp.tagVersion.getInt());
        return true;
    }
}

