/*
 * Decompiled with CFR 0.152.
 */
package promauto.jroboplc.plugin.peripherial;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import promauto.jroboplc.core.api.Plugin;
import promauto.jroboplc.core.api.Tag;
import promauto.jroboplc.plugin.peripherial.PaGeliosFlowModule;
import promauto.jroboplc.plugin.peripherial.PeripherialModule;
import promauto.utils.CRC;
import promauto.utils.Numbers;

public class TvhPulsarmModule
extends PeripherialModule {
    private final Logger logger = LoggerFactory.getLogger(PaGeliosFlowModule.class);
    protected Tag tagCounter;
    private int[] buffin = new int[20];
    private int[] buffout = new int[20];

    public TvhPulsarmModule(Plugin plugin, String name) {
        super(plugin, name);
    }

    @Override
    public boolean loadPeripherialModule(Object conf) {
        this.tagCounter = this.tagtable.createInt("counter", 0, 8);
        return true;
    }

    @Override
    public boolean preparePeripherialModule() {
        return true;
    }

    private boolean request(int sizeout, int sizein) throws Exception {
        int b = 0;
        for (int trynum = 0; trynum < this.retrial; ++trynum) {
            this.port.discard();
            this.delayBeforeWrite();
            this.port.writeBytes(this.buffout, sizeout);
            int cntRead = 0;
            boolean badcrc = false;
            boolean badreq = false;
            for (int i = 0; i < sizein && (b = this.port.readByte()) >= 0; ++i) {
                this.buffin[i] = b;
                ++cntRead;
            }
            if (b >= 0) {
                int crc2;
                int crc1 = CRC.getCrc16(this.buffin, sizein - 2);
                if (crc1 != (crc2 = this.buffin[sizein - 1] << 8 | this.buffin[sizein - 2])) {
                    badcrc = true;
                } else {
                    return true;
                }
            }
            if (this.canLogError()) {
                this.logError(trynum, badcrc, this.buffout, sizeout, this.buffin, cntRead, badreq ? "BadRequest" : "");
            }
            this.delayAfterError();
        }
        this.tagErrorCnt.setInt(this.tagErrorCnt.getInt() + 1);
        return false;
    }

    @Override
    public boolean executePeripherialModule() {
        if (!this.emulated) {
            try {
                Numbers.intToBytes(this.netaddr, this.buffout, 0);
                this.buffout[4] = 1;
                this.buffout[5] = 14;
                this.buffout[6] = 1;
                this.buffout[7] = 0;
                this.buffout[8] = 0;
                this.buffout[9] = 0;
                this.buffout[10] = 0;
                this.buffout[11] = 1;
                int crc = CRC.getCrc16(this.buffout, 12);
                this.buffout[12] = crc & 0xFF;
                this.buffout[13] = crc >> 8 & 0xFF;
                if (!this.request(14, 14)) {
                    return false;
                }
                int netaddr1 = Numbers.bytesToInt(this.buffin, 0);
                if (netaddr1 != this.netaddr || this.buffin[4] != 1 || this.buffin[5] != 14) {
                    return false;
                }
                this.tagCounter.setInt(Numbers.bytesToIntReverse(this.buffin, 6));
            }
            catch (Exception e) {
                this.env.printError(this.logger, e, this.name);
                return false;
            }
        }
        return true;
    }
}

