/*
 * Decompiled with CFR 0.152.
 */
package promauto.jroboplc.plugin.roboplant;

import promauto.jroboplc.core.api.Tag;
import promauto.jroboplc.plugin.roboplant.ConnectDevice;
import promauto.jroboplc.plugin.roboplant.Connector;
import promauto.jroboplc.plugin.roboplant.Device;
import promauto.jroboplc.plugin.roboplant.Input;

public class DeviceDZR12
extends ConnectDevice {
    public static final int MAXSIZE = 12;
    Input inpInput;
    Input inpSuspend;
    Input inpTrigRes;
    Input inpLoad;
    Input inpUnload;
    Tag tagNetAddress;
    Tag tagComPort;
    Tag tagMaxShnkNum;
    Tag tagErrorFlag;
    Tag tagErrorCounter;
    Tag tagEnable;
    Tag tagStatus;
    Tag tagTaskCode;
    Tag tagCurStorNum;
    Tag tagResStorNum;
    Tag tagCurStorWesHigh;
    Tag tagCurStorWesLow;
    Tag tagCurStage;
    Tag tagInputs;
    Tag tagOutputs;
    Tag tagCmd;
    Tag tagErrCode;
    Tag[] tagsCounterHigh = new Tag[12];
    Tag[] tagsCounterLow = new Tag[12];
    Tag[] tagsNominalCurHigh = new Tag[12];
    Tag[] tagsNominalCurLow = new Tag[12];

    @Override
    public void prepareTags(Device.RefBool res) {
        int i;
        this.inpInput = this.getInput("Input", res);
        this.inpSuspend = this.getInput("Suspend", res);
        this.inpTrigRes = this.getInput("TrigRes", res);
        this.inpLoad = this.getInput("Load", res);
        this.inpUnload = this.getInput("Unload", res);
        this.tagNetAddress = this.getOutputTag("NetAddress", res);
        this.tagComPort = this.getOutputTag("ComPort", res);
        this.tagMaxShnkNum = this.getOutputTag("MaxShnkNum", res);
        this.tagErrorFlag = this.getOutputTag("ErrorFlag", res);
        this.tagErrorCounter = this.getOutputTag("ErrorCounter", res);
        this.tagEnable = this.getOutputTag("Enable", res);
        this.tagStatus = this.getOutputTag("Status", res);
        this.tagTaskCode = this.getOutputTag("TaskCode", res);
        this.tagCurStorNum = this.getOutputTag("CurStorNum", res);
        this.tagResStorNum = this.getOutputTag("ResStorNum", res);
        this.tagCurStorWesHigh = this.getOutputTag("CurStorWesHigh", res);
        this.tagCurStorWesLow = this.getOutputTag("CurStorWesLow", res);
        this.tagCurStage = this.getOutputTag("CurStage", res);
        this.tagInputs = this.getOutputTag("Inputs", res);
        this.tagOutputs = this.getOutputTag("Outputs", res);
        this.tagCmd = this.getOutputTag("Cmd", res);
        this.tagErrCode = this.getOutputTag("ErrCode", res);
        for (i = 0; i < 12; ++i) {
            this.tagsCounterHigh[i] = this.getOutputTag(String.format("Counter%02dHigh", i), res);
            this.tagsCounterLow[i] = this.getOutputTag(String.format("Counter%02dLow", i), res);
            this.tagsNominalCurHigh[i] = this.getOutputTag(String.format("NominalCur%02dHigh", i), res);
            this.tagsNominalCurLow[i] = this.getOutputTag(String.format("NominalCur%02dLow", i), res);
        }
        this.connector.connect("NetAddress", "SYSTEM.NetAddress", Connector.Mode.READ, res);
        this.connector.connect("ComPort", "SYSTEM.ComPort", Connector.Mode.READ, res);
        this.connector.connect("MaxShnkNum", "Size", Connector.Mode.READ, res);
        this.connector.connect("ErrorFlag", "SYSTEM.ErrorFlag", Connector.Mode.READ, res);
        this.connector.connect("ErrorCounter", "SYSTEM.ErrorCount", Connector.Mode.READ, res);
        this.connector.connect("Enable", "Enable", Connector.Mode.WRITE, res);
        this.connector.connect("Status", "Status", Connector.Mode.READ, res);
        this.connector.connect("TaskCode", "Task", Connector.Mode.READ, res);
        this.connector.connect("CurStorNum", "CurStorNum", Connector.Mode.READ, res);
        this.connector.connect("ResStorNum", "RestStorNum", Connector.Mode.READ, res);
        this.connector.connect("CurStorWesHigh", "CurStorWesHigh", Connector.Mode.READ, res);
        this.connector.connect("CurStorWesLow", "CurStorWesLow", Connector.Mode.READ, res);
        this.connector.connect("CurStage", "CurStage", Connector.Mode.READ, res);
        this.connector.connect("Inputs", "Inputs", Connector.Mode.READ, res);
        this.connector.connect("Outputs", "Outputs", Connector.Mode.READ, res);
        this.connector.connect("Cmd", "Cmd", Connector.Mode.MANUAL, res);
        this.connector.connect("ErrCode", "ErrorCode", Connector.Mode.READ, res);
        for (i = 0; i < 12; ++i) {
            this.connector.connect(String.format("Counter%02dHigh", i), "SumWesHigh" + i, Connector.Mode.READ, res);
            this.connector.connect(String.format("Counter%02dLow", i), "SumWesLow" + i, Connector.Mode.READ, res);
            this.connector.connect(String.format("NominalCur%02dHigh", i), "TaskWesHigh" + i, Connector.Mode.READ, res);
            this.connector.connect(String.format("NominalCur%02dLow", i), "TaskWesLow" + i, Connector.Mode.READ, res);
        }
        if (res.value) {
            this.resetState();
        }
    }

    protected void resetState() {
        this.tagCmd.setInt(100);
    }

    @Override
    public boolean execute() {
        Tag tagCmdBind;
        super.execute();
        int cmd = this.tagCmd.getInt();
        if (this.inpLoad.tag.getBool() && this.tagStatus.getInt() == 1) {
            cmd = 2;
        } else if (this.inpUnload.tag.getBool() && this.tagStatus.getInt() == 3) {
            cmd = 4;
        }
        if (cmd < 100 && (tagCmdBind = this.connector.getTagBind(this.tagCmd)) != null) {
            tagCmdBind.setInt(cmd);
            this.tagCmd.setInt(cmd + 100);
        }
        return true;
    }
}

