/*
 * Decompiled with CFR 0.152.
 */
package promauto.jroboplc.plugin.serial;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.Socket;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import promauto.jroboplc.core.api.Configuration;
import promauto.jroboplc.core.api.EnvironmentInst;
import promauto.jroboplc.core.api.SerialPort;
import promauto.jroboplc.core.tags.TagRW;
import promauto.jroboplc.plugin.serial.SerialManagerModule;
import promauto.utils.CRC;
import promauto.utils.Numbers;

public class SerialPortModbusTcp
implements SerialPort {
    final Logger logger = LoggerFactory.getLogger(SerialPortModbusTcp.class);
    private Socket socketData;
    private InputStream inputData;
    private OutputStream outputData;
    private volatile boolean valid = true;
    private volatile boolean opened = false;
    private String host;
    private int port;
    private InetSocketAddress addrData;
    private static final int BUFFIN_SIZE = 2048;
    private int[] buffin = new int[2048];
    private int buffinPos;
    private int buffinActualSize;
    private int id;
    private int timeout_ms;
    private boolean noTcpDelay;
    private boolean connectionLost = false;
    private long connectionLostTime = 0L;
    private long recon_ms = 3000L;
    private long liveness = 0L;
    private SerialManagerModule module;
    private TagRW tagOpened;
    private int transactSent;

    public SerialPortModbusTcp(SerialManagerModule module) {
        this.module = module;
        this.transactSent = 0;
    }

    public synchronized boolean load(Object conf) {
        Configuration cm = EnvironmentInst.get().getConfiguration();
        this.id = cm.get(conf, "id", 0);
        this.recon_ms = cm.get(conf, "recon_ms", 3000);
        this.timeout_ms = cm.get(conf, "timeout", 200);
        this.noTcpDelay = cm.get(conf, "no_tcpdelay", true);
        this.host = cm.get(conf, "host", "");
        this.port = cm.get(conf, "port", 502);
        this.addrData = new InetSocketAddress(this.host, this.port);
        this.tagOpened = this.module.getTagOpened(this.id);
        return true;
    }

    @Override
    public int getId() {
        return this.id;
    }

    @Override
    public synchronized boolean setParams(int baud, int databits, int parity, int stopbits, int timeout) {
        boolean reopen = this.timeout_ms != timeout;
        this.timeout_ms = timeout;
        boolean res = true;
        if (reopen &= this.opened) {
            this.close();
            res = this.open();
        }
        return res;
    }

    @Override
    public synchronized boolean open() {
        return this.open(false);
    }

    public synchronized boolean open(boolean silent) {
        if (this.opened) {
            return true;
        }
        this.opened = this.connectSocket(silent);
        if (!this.opened) {
            this.connectionLost = true;
            this.disconnectSocket();
        } else {
            this.connectionLost = false;
            this.tagOpened.setReadValInt(1);
        }
        return this.opened;
    }

    protected boolean connectSocket(boolean silent) {
        this.resetBuffin();
        try {
            this.socketData = null;
            this.socketData = new Socket();
            this.socketData.setSoTimeout(this.timeout_ms);
            this.socketData.setTcpNoDelay(this.noTcpDelay);
            this.socketData.connect(this.addrData, this.timeout_ms);
            this.inputData = this.socketData.getInputStream();
            this.outputData = this.socketData.getOutputStream();
        }
        catch (Exception e) {
            if (!silent) {
                EnvironmentInst.get().printError(this.logger, e, this.module.getName(), "Connect socket:", this.getDescr());
            }
            return false;
        }
        return true;
    }

    private void disconnectSocket() {
        this.resetBuffin();
        if (this.socketData != null) {
            try {
                this.socketData.close();
            }
            catch (Exception e) {
                EnvironmentInst.get().printError(this.logger, e, this.module.getName(), "Disconnect socket:", this.getDescr());
            }
            this.socketData = null;
        }
        this.opened = false;
        this.tagOpened.setReadValInt(0);
    }

    @Override
    public synchronized void close() {
        if (!this.opened) {
            return;
        }
        this.disconnectSocket();
        this.connectionLost = false;
    }

    private void checkLiveness() {
        boolean ok = this.socketData.isBound();
        ok &= !this.socketData.isClosed();
        ok &= this.socketData.isConnected();
        ok &= !this.socketData.isInputShutdown();
        if (ok &= !this.socketData.isOutputShutdown()) {
            if (this.liveness == 0L) {
                this.liveness = System.currentTimeMillis();
                return;
            }
            if (System.currentTimeMillis() - this.liveness < this.recon_ms) {
                return;
            }
        }
        this.liveness = 0L;
        if (this.opened) {
            this.disconnectSocket();
            if (this.open(true)) {
                return;
            }
            EnvironmentInst.get().printError(this.logger, this.module.getName(), this.getDescr(), "Connection lost");
            this.connectionLost = true;
            this.connectionLostTime = System.currentTimeMillis();
        }
    }

    private void affirmLiveness() {
        this.liveness = 0L;
    }

    private String getDescr() {
        return "Serial port " + this.id + " (ModbusTcp " + this.host + ":" + this.port + ")";
    }

    private boolean restoreConnectionIfLost() {
        if (!this.connectionLost) {
            return true;
        }
        if (System.currentTimeMillis() - this.connectionLostTime < this.recon_ms) {
            return false;
        }
        if (this.open(true)) {
            EnvironmentInst.get().printInfo(this.logger, this.getDescr(), "Connection restored");
            return true;
        }
        this.connectionLostTime = System.currentTimeMillis();
        return false;
    }

    @Override
    public boolean isOpened() {
        return this.opened;
    }

    @Override
    public boolean isValid() {
        return this.valid;
    }

    @Override
    public void setInvalid() {
        this.valid = false;
    }

    @Override
    public int getAvailable() throws IOException {
        return this.inputData.available();
    }

    private boolean updateAnswer() {
        if (!this.restoreConnectionIfLost() || !this.opened) {
            return false;
        }
        if (this.isBuffinAvailable() && !this.receiveAnswer()) {
            this.checkLiveness();
            return false;
        }
        this.affirmLiveness();
        return true;
    }

    private boolean receiveAnswer() {
        byte[] buff = this.readBytes(6);
        if (buff == null) {
            return false;
        }
        int transactReceived = Numbers.bytesToWord(buff, 0);
        if (transactReceived != this.transactSent) {
            return false;
        }
        int msgLen = Numbers.bytesToWord(buff, 4);
        if (msgLen - 2 > 2048) {
            return false;
        }
        buff = this.readBytes(msgLen);
        if (buff == null) {
            return false;
        }
        for (int i = 0; i < msgLen; ++i) {
            this.buffin[i] = buff[i] & 0xFF;
        }
        this.buffinPos = 0;
        this.buffinActualSize = msgLen + 2;
        int crc = CRC.getCrc16(buff);
        this.buffin[msgLen] = crc & 0xFF;
        this.buffin[msgLen + 1] = crc >> 8 & 0xFF;
        return true;
    }

    private byte[] readBytes(int size) {
        long time = System.currentTimeMillis();
        int p = 0;
        byte[] buff = new byte[size];
        try {
            do {
                if ((p += this.inputData.read(buff, p, size - p)) != size) continue;
                return buff;
            } while (System.currentTimeMillis() - time < (long)this.timeout_ms);
            return null;
        }
        catch (IOException iOException) {
            return null;
        }
    }

    private int getByteFromBuffin() {
        return this.buffin[this.buffinPos++];
    }

    private boolean isBuffinAvailable() {
        return this.buffinPos >= this.buffinActualSize;
    }

    private void resetBuffin() {
        this.buffinPos = 0;
        this.buffinActualSize = 0;
    }

    @Override
    public synchronized int readByte() {
        if (!this.updateAnswer()) {
            return -1;
        }
        if (this.isBuffinAvailable()) {
            return -1;
        }
        return this.getByteFromBuffin();
    }

    @Override
    public synchronized int readBytes(int[] buff, int size) {
        if (!this.updateAnswer()) {
            return 0;
        }
        if (this.isBuffinAvailable()) {
            return 0;
        }
        int n = Math.min(this.buffinActualSize - this.buffinPos, size);
        for (int i = 0; i < n; ++i) {
            buff[i] = this.getByteFromBuffin();
        }
        return n;
    }

    @Override
    public synchronized int readBytesDelim(int[] buff, int delim) {
        return 0;
    }

    @Override
    public synchronized String readString(int size) {
        return "";
    }

    @Override
    public synchronized String readStringDelim(int delim) {
        return "";
    }

    @Override
    public synchronized boolean writeByte(int data) {
        return false;
    }

    @Override
    public synchronized boolean writeBytes(int[] data, int size) {
        if (!this.restoreConnectionIfLost()) {
            return false;
        }
        if (!this.opened) {
            return false;
        }
        this.resetBuffin();
        ++this.transactSent;
        this.transactSent &= 0xFFFF;
        int bufflen = size + 4;
        byte[] buff = new byte[bufflen];
        buff[0] = (byte)(this.transactSent >> 8 & 0xFF);
        buff[1] = (byte)(this.transactSent & 0xFF);
        buff[2] = 0;
        buff[3] = 0;
        int msglen = size - 2;
        buff[4] = (byte)(msglen >> 8 & 0xFF);
        buff[5] = (byte)(msglen & 0xFF);
        int i = 6;
        for (int j = 0; j < msglen; ++j) {
            buff[i] = (byte)data[j];
            ++i;
        }
        try {
            this.outputData.write(buff);
        }
        catch (IOException e) {
            this.checkLiveness();
            return false;
        }
        return true;
    }

    @Override
    public synchronized boolean writeString(String data) {
        return false;
    }

    @Override
    public synchronized boolean discard() {
        if (!this.opened) {
            return false;
        }
        this.resetBuffin();
        try {
            if (this.inputData.available() > 0) {
                this.inputData.skip(this.inputData.available());
            }
        }
        catch (IOException e) {
            return false;
        }
        return true;
    }

    @Override
    public String getInfo() {
        return String.format("%d: modbustcp %s:%d %d %s", this.id, this.host, this.port, this.timeout_ms, this.opened ? "opened" : "closed");
    }
}

