/*
 * Decompiled with CFR 0.152.
 */
package promauto.jroboplc.plugin.tcpserver;

import promauto.jroboplc.core.AbstractCommand;
import promauto.jroboplc.core.api.Console;
import promauto.jroboplc.core.api.Environment;
import promauto.jroboplc.core.api.EnvironmentInst;
import promauto.jroboplc.core.api.Plugin;
import promauto.jroboplc.core.api.TcpServerChannel;
import promauto.jroboplc.core.api.TcpServerPort;

public class CmdLog
extends AbstractCommand {
    private TcpServerPort port;
    private boolean value;
    private String valuestr;

    @Override
    public String getName() {
        return "log";
    }

    @Override
    public String getUsage() {
        return "portnum on|off";
    }

    @Override
    public String getDescription() {
        return "turns on/off logging";
    }

    protected boolean parseArgs(Environment env, String args) {
        String[] ss = args.split("\\s* \\s*");
        if (ss.length != 2) {
            return false;
        }
        int portnum = 0;
        try {
            portnum = Integer.parseInt(ss[0]);
        }
        catch (NumberFormatException e) {
            return false;
        }
        this.valuestr = ss[1];
        if (this.valuestr.equals("on")) {
            this.value = true;
        } else if (this.valuestr.equals("off")) {
            this.value = false;
        } else {
            return false;
        }
        this.port = env.getTcpServer().getPortByNum(portnum);
        return this.port != null;
    }

    @Override
    public String execute(Console console, Plugin plugin, String args) {
        Environment env = EnvironmentInst.get();
        if (!this.parseArgs(env, args)) {
            return this.getRefuseAnswer(plugin);
        }
        StringBuilder sb = new StringBuilder("Setting logging ");
        sb.append(this.valuestr);
        sb.append(" to port ");
        sb.append(this.port.getPortnum());
        sb.append(":\r\n");
        for (TcpServerChannel tcpServerChannel : this.port.getChannels()) {
            if (tcpServerChannel.isLogEnable() == this.value) {
                sb.append("already ");
            } else {
                sb.append("set to ");
                tcpServerChannel.setLogEnable(this.value);
            }
            sb.append(this.valuestr);
            sb.append(" - ");
            sb.append(tcpServerChannel);
            sb.append("\r\n");
        }
        return sb.toString();
    }
}

