/*
 * Decompiled with CFR 0.152.
 */
package promauto.jroboplc.plugin.tcpserver;

import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.handler.codec.DelimiterBasedFrameDecoder;
import io.netty.handler.codec.Delimiters;
import io.netty.handler.codec.string.StringDecoder;
import io.netty.handler.codec.string.StringEncoder;
import java.util.HashMap;
import java.util.Map;
import promauto.jroboplc.core.AbstractModule;
import promauto.jroboplc.core.api.Configuration;
import promauto.jroboplc.core.api.EnvironmentInst;
import promauto.jroboplc.core.api.Plugin;
import promauto.jroboplc.core.api.TcpServer;
import promauto.jroboplc.core.api.TcpServerChannel;
import promauto.jroboplc.core.api.TcpServerPort;
import promauto.jroboplc.core.api.TcpSubscriber;
import promauto.jroboplc.plugin.tcpserver.TcpServerPortImpl;
import promauto.jroboplc.plugin.tcpserver.TextHandler;

public class TcpServerModule
extends AbstractModule
implements TcpServer,
Runnable {
    private static final int TEXT_FRAME_SIZE_MAX = 16384;
    private static final int DISCONNECT_TIMEOUT_MS = 10000;
    private volatile boolean running = false;
    protected Map<Integer, TcpServerPortImpl> portnums = new HashMap<Integer, TcpServerPortImpl>();
    protected Map<Integer, TcpServerPortImpl> porttcps = new HashMap<Integer, TcpServerPortImpl>();
    private EventLoopGroup bossGroup = null;
    private EventLoopGroup workerGroup = null;
    private Thread thread = null;

    public TcpServerModule(Plugin plugin, String name) {
        super(plugin, name);
        this.env.setTcpServer(this);
        this.taskable = false;
    }

    @Override
    public boolean loadModule(Object conf) {
        Configuration cm = EnvironmentInst.get().getConfiguration();
        for (Object portconf : cm.toList(cm.get(conf, "ports"))) {
            TcpServerPortImpl port = new TcpServerPortImpl();
            port.load(portconf);
            this.portnums.put(port.getPortnum(), port);
            this.porttcps.put(port.getPorttcp(), port);
        }
        return true;
    }

    @Override
    public boolean prepareModule() {
        return this.start();
    }

    @Override
    public boolean closedownModule() {
        return this.stop();
    }

    @Override
    public TcpServerPort getPortByNum(int portnum) {
        return this.portnums.get(portnum);
    }

    @Override
    public TcpServerPort getPortByTcp(int porttcp) {
        return this.porttcps.get(porttcp);
    }

    @Override
    public TcpServerPort getPortBySubscriber(TcpSubscriber subscriber) {
        for (TcpServerPort tcpServerPort : this.portnums.values()) {
            if (tcpServerPort.getSubscriber() != subscriber) continue;
            return tcpServerPort;
        }
        return null;
    }

    @Override
    public boolean subscribe(int portnum, TcpSubscriber subscriber) {
        TcpServerPort port = this.env.getTcpServer().getPortByNum(portnum);
        if (port == null) {
            this.env.printError(this.logger, this.name, "Subscribe port not found:", "" + portnum);
            return false;
        }
        port.setSubscriber(subscriber);
        return true;
    }

    public boolean start() {
        if (this.running) {
            return false;
        }
        this.running = true;
        boolean result = true;
        if (this.bossGroup == null) {
            this.bossGroup = new NioEventLoopGroup();
        }
        if (this.workerGroup == null) {
            this.workerGroup = new NioEventLoopGroup();
        }
        HashMap<String, ServerBootstrap> bootstraps = new HashMap<String, ServerBootstrap>();
        bootstraps.put("text", this.createBootstrap((ChannelHandler)new ChannelInitializer<SocketChannel>(){

            public void initChannel(SocketChannel ch) throws Exception {
                ch.pipeline().addLast("framer", (ChannelHandler)new DelimiterBasedFrameDecoder(16384, Delimiters.lineDelimiter()));
                ch.pipeline().addLast("decoder", (ChannelHandler)new StringDecoder());
                ch.pipeline().addLast("encoder", (ChannelHandler)new StringEncoder());
                ch.pipeline().addLast(new ChannelHandler[]{new TextHandler(TcpServerModule.this)});
            }
        }));
        for (TcpServerPortImpl port : this.portnums.values()) {
            if (!port.isEnabled()) continue;
            try {
                ServerBootstrap bs = (ServerBootstrap)bootstraps.get(port.getFormat());
                if (bs == null) {
                    this.env.printError(this.logger, this.name, "Bad tcpserver port format:", port.getFormat());
                    result = false;
                    break;
                }
                bs.bind(port.getPorttcp()).sync();
            }
            catch (Exception e) {
                EnvironmentInst.get().printError(this.logger, e, this.name, "Tcp channel error");
                result = false;
            }
        }
        if (result) {
            if (this.thread == null) {
                this.thread = new Thread(this);
            }
            this.thread.setName("thread-" + this.name);
            this.thread.start();
        }
        return result;
    }

    private ServerBootstrap createBootstrap(ChannelHandler handler) {
        ServerBootstrap bs = new ServerBootstrap();
        ((ServerBootstrap)((ServerBootstrap)bs.group(this.bossGroup, this.workerGroup).channel(NioServerSocketChannel.class)).childHandler(handler).option(ChannelOption.SO_BACKLOG, (Object)128)).childOption(ChannelOption.SO_KEEPALIVE, (Object)true);
        return bs;
    }

    public boolean stop() {
        if (!this.running) {
            return false;
        }
        this.running = false;
        this.bossGroup.shutdownGracefully();
        this.workerGroup.shutdownGracefully();
        try {
            this.bossGroup.terminationFuture().sync();
            this.workerGroup.terminationFuture().sync();
        }
        catch (InterruptedException e) {
            this.env.printError(this.logger, e, this.name);
        }
        this.bossGroup = null;
        this.workerGroup = null;
        try {
            if (this.thread != null) {
                this.thread.join(10000L);
                this.thread = null;
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return true;
    }

    @Override
    public boolean disconnect(int portnum) {
        if (!this.running) {
            return false;
        }
        TcpServerPortImpl port = this.portnums.get(portnum);
        if (port == null) {
            return false;
        }
        try {
            if (port.close(10000L)) {
                long t = System.currentTimeMillis();
                while (System.currentTimeMillis() - t < 10000L) {
                    if (port.isDisconnected()) {
                        return true;
                    }
                    Thread.sleep(1L);
                }
            }
        }
        catch (Exception e) {
            this.env.printError(this.logger, e, this.name);
        }
        return false;
    }

    @Override
    public String getInfo() {
        if (!this.enable) {
            return "disabled";
        }
        StringBuilder sb = new StringBuilder();
        for (TcpServerPort tcpServerPort : this.portnums.values()) {
            sb.append(tcpServerPort.getPortnum());
            sb.append(": tcp=");
            sb.append(tcpServerPort.getPorttcp());
            if (tcpServerPort.isEnabled()) {
                if (tcpServerPort.getSubscriber() == null) {
                    sb.append(", unused\r\n");
                    continue;
                }
                sb.append(", connected ");
                sb.append(tcpServerPort.getChannels().size());
                sb.append(" clients\r\n");
                for (TcpServerChannel tcpServerChannel : tcpServerPort.getChannels()) {
                    sb.append("  ");
                    sb.append(tcpServerChannel);
                    sb.append("\r\n");
                }
                continue;
            }
            sb.append(", disabled\r\n");
        }
        return sb.toString();
    }

    @Override
    protected boolean reload() {
        new Thread(() -> this.reloadModule()).start();
        return true;
    }

    protected boolean reloadModule() {
        boolean valid = new TcpServerModule(this.plugin, this.name).load();
        this.env.setTcpServer(this);
        if (!valid) {
            return false;
        }
        if (this.running) {
            this.stop();
        }
        Map<Integer, TcpServerPortImpl> portnums_old = this.portnums;
        Map<Integer, TcpServerPortImpl> porttcps_old = this.porttcps;
        this.portnums = new HashMap<Integer, TcpServerPortImpl>();
        this.porttcps = new HashMap<Integer, TcpServerPortImpl>();
        if (this.load()) {
            for (TcpServerPort tcpServerPort : portnums_old.values()) {
                TcpServerPort port_new = this.portnums.get(tcpServerPort.getPortnum());
                if (port_new == null) continue;
                port_new.setSubscriber(tcpServerPort.getSubscriber());
            }
            portnums_old.clear();
            porttcps_old.clear();
            if (this.enable && this.env.isRunning()) {
                return this.start();
            }
            return true;
        }
        this.portnums = portnums_old;
        this.porttcps = porttcps_old;
        return false;
    }

    @Override
    public void run() {
        try {
            while (this.running) {
                Thread.sleep(1000L);
                for (TcpServerPort tcpServerPort : this.portnums.values()) {
                    if (!tcpServerPort.isEnabled() || tcpServerPort.getSubscriber() == null) continue;
                    for (TcpServerChannel tcpServerChannel : tcpServerPort.getChannels()) {
                        tcpServerChannel.checkAlive();
                    }
                }
            }
        }
        catch (InterruptedException e) {
            EnvironmentInst.get().printError(this.logger, e, this.name);
        }
    }
}

