/*
 * Decompiled with CFR 0.152.
 */
package promauto.jroboplc.plugin.wessvr;

import promauto.jroboplc.core.tags.RefItem;
import promauto.jroboplc.plugin.wessvr.DeviceBase;
import promauto.jroboplc.plugin.wessvr.WessvrModule;

public class DeviceAtara
extends DeviceBase {
    public static final String MODTYPE = "Atara";
    protected RefItem refCrc;
    protected RefItem refWeightPHigh;
    protected RefItem refWeightPLow;
    protected RefItem refCurWeight;
    protected RefItem refOutput;

    public DeviceAtara(WessvrModule module) {
        super(module);
        this.sizeSumWeight = 0x100000000L;
        this.sizeSumNum = 0x100000000L;
    }

    @Override
    public String getModtype() {
        return MODTYPE;
    }

    @Override
    protected void createRefs() {
        super.createRefs();
        this.refCrc = this.refs.createItemCrcSum(this.name, "Crc16");
        this.addVldZero(this.addVldFFFF(this.refs.createItemCrc(this.name, "WeightTHigh")));
        this.addVldZero(this.addVldFFFF(this.refs.createItemCrc(this.name, "WeightTLow")));
        this.refWeightPHigh = this.refs.createItemCrc(this.name, "WeightPHigh");
        this.addVldZero(this.addVldFFFF(this.refWeightPHigh));
        this.refWeightPLow = this.refs.createItemCrc(this.name, "WeightPLow");
        this.addVldZero(this.addVldFFFF(this.refWeightPLow));
        this.refs.addItemCrc(this.refErrorFlag);
        this.refCurWeight = this.refs.createItem(this.name, "CurWeight");
        this.refOutput = this.refs.createItem(this.name, "Output");
    }

    @Override
    protected long getSumWeight() {
        return ((long)this.refWeightPHigh.getValue().getInt() << 16) + (long)this.refWeightPLow.getValue().getInt();
    }

    @Override
    protected boolean updateValuesArcval() {
        if (this.arcvalValues[0] == this.getSumWeight()) {
            return false;
        }
        this.arcvalValues[0] = this.getSumWeight();
        return true;
    }

    @Override
    protected double getArcoutValue() {
        return this.refOutput.getValue().getDouble();
    }
}

