/*
 * Decompiled with CFR 0.152.
 */
package promauto.jroboplc.plugin.wessvr;

import promauto.jroboplc.core.tags.RefItem;
import promauto.jroboplc.plugin.wessvr.DeviceBase;
import promauto.jroboplc.plugin.wessvr.WessvrModule;

public class DeviceCentaURZ
extends DeviceBase {
    public static final String MODTYPE = "CentaURZ";
    protected RefItem refCrc;
    protected RefItem refSumWeightHigh;
    protected RefItem refSumWeightLow;
    protected RefItem refOutput;

    public DeviceCentaURZ(WessvrModule module) {
        super(module);
        this.sizeSumWeight = 0x100000000L;
        this.sizeSumNum = 0x100000000L;
    }

    @Override
    public String getModtype() {
        return MODTYPE;
    }

    @Override
    protected void createRefs() {
        super.createRefs();
        this.refCrc = this.refs.createItemCrcSum(this.name, "Crc");
        this.refSumWeightHigh = this.refs.createItemCrc(this.name, "SumWeightHigh");
        this.addVldZero(this.addVldFFFF(this.refSumWeightHigh));
        this.refSumWeightLow = this.refs.createItemCrc(this.name, "SumWeightLow");
        this.addVldZero(this.addVldFFFF(this.refSumWeightLow));
        this.refOutput = this.refs.createItem(this.name, "Output");
    }

    @Override
    protected boolean checkCrc() {
        return this.refs.checkCrc8();
    }

    @Override
    protected long getSumWeight() {
        return ((long)this.refSumWeightHigh.getValue().getInt() << 16) + (long)this.refSumWeightLow.getValue().getInt();
    }

    @Override
    protected long getSumNum() {
        return 0L;
    }

    @Override
    protected boolean updateValuesStatus() {
        return true;
    }

    @Override
    protected boolean updateValuesArcval() {
        if (this.arcvalValues[0] == this.getSumWeight()) {
            return false;
        }
        this.arcvalValues[0] = this.getSumWeight();
        return true;
    }

    @Override
    protected double getArcoutValue() {
        return this.refOutput.getValue().getDouble();
    }
}

