/*
 * Decompiled with CFR 0.152.
 */
package promauto.utils;

public class Numbers {
    public static final int[] hexDigit = new int[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 65, 66, 67, 68, 69, 70};
    public static final char[] hexDigitChar = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    public static int bytesToInt(int[] data, int index) {
        return data[index] << 24 | data[index + 1] << 16 | data[index + 2] << 8 | data[index + 3];
    }

    public static int bytesToIntReverse(int[] data, int index) {
        return data[index + 3] << 24 | data[index + 2] << 16 | data[index + 1] << 8 | data[index];
    }

    @Deprecated
    public static long bytesToUInt(int[] data, int index) {
        return (long)data[index] << 24 | (long)data[index + 1] << 16 | (long)data[index + 2] << 8 | (long)data[index + 3];
    }

    public static int bytesToWord(int[] data, int index) {
        return data[index] << 8 | data[index + 1];
    }

    public static long bytesToDWord(int[] data, int index) {
        return (long)data[index] << 24 | (long)(data[index + 1] << 16) | (long)(data[index + 2] << 8) | (long)data[index + 3];
    }

    public static int bytesToWord(byte[] data, int index) {
        return (data[index] & 0xFF) << 8 | data[index + 1] & 0xFF;
    }

    public static int asciiToInt(int[] src, int beg, int end) {
        int result = 0;
        for (int i = beg; i < end; ++i) {
            result = result * 10 + Numbers.asciiDigitToInt(src[i]);
        }
        return result;
    }

    public static long wordsToLong(int high, int low) {
        return high << 16 | low;
    }

    public static int asciiDigitToInt(int digit) {
        if (digit > 48 && digit < 58) {
            return digit - 48;
        }
        if (digit > 64 && digit < 71) {
            return digit - 55;
        }
        if (digit > 96 && digit < 103) {
            return digit - 87;
        }
        return 0;
    }

    public static int asciiByteToInt(int[] data, int idx) {
        return (Numbers.asciiDigitToInt(data[idx]) << 4) + Numbers.asciiDigitToInt(data[idx + 1]);
    }

    public static int asciiWordToInt(int[] data, int idx) {
        return (Numbers.asciiDigitToInt(data[idx]) << 12) + (Numbers.asciiDigitToInt(data[idx + 1]) << 8) + (Numbers.asciiDigitToInt(data[idx + 2]) << 4) + Numbers.asciiDigitToInt(data[idx + 3]);
    }

    public static long asciiDWordToLong(int[] data, int idx) {
        return (Numbers.asciiDigitToInt(data[idx]) << 28) + (Numbers.asciiDigitToInt(data[idx + 1]) << 24) + (Numbers.asciiDigitToInt(data[idx + 2]) << 20) + (Numbers.asciiDigitToInt(data[idx + 3]) << 16) + (Numbers.asciiDigitToInt(data[idx + 4]) << 12) + (Numbers.asciiDigitToInt(data[idx + 5]) << 8) + (Numbers.asciiDigitToInt(data[idx + 6]) << 4) + Numbers.asciiDigitToInt(data[idx + 7]);
    }

    public static void intToAsciiByte(int value, int[] dst, int idx) {
        dst[idx] = hexDigitChar[value >> 4 & 0xF];
        dst[idx + 1] = hexDigitChar[value & 0xF];
    }

    public static void intToAsciiWord(int value, int[] dst, int idx) {
        Numbers.intToAsciiByte(value >> 8 & 0xFF, dst, idx);
        Numbers.intToAsciiByte(value & 0xFF, dst, idx + 2);
    }

    public static void longToAsciiDWord(long value, int[] dst, int idx) {
        Numbers.intToAsciiWord((int)(value >> 16 & 0xFFFFL), dst, idx);
        Numbers.intToAsciiWord((int)(value & 0xFFFFL), dst, idx + 4);
    }

    public static int hexToInt(int[] data, int idx, int len) {
        int v = 0;
        while (true) {
            v += Numbers.asciiDigitToInt(data[idx++]);
            if (--len <= 0) break;
            v <<= 4;
        }
        return v;
    }

    public static int hexToInt(byte[] data, int idx, int len) {
        int v = 0;
        while (true) {
            v += Numbers.asciiDigitToInt(data[idx++] & 0xFF);
            if (--len <= 0) break;
            v <<= 4;
        }
        return v;
    }

    public static long hexToLong(byte[] data, int idx, int len) {
        long v = 0L;
        while (true) {
            v += (long)Numbers.asciiDigitToInt(data[idx++] & 0xFF);
            if (--len <= 0) break;
            v <<= 4;
        }
        return v;
    }

    public static void wordToBytes(int value, int[] data, int idx) {
        data[idx] = value >> 8 & 0xFF;
        data[idx + 1] = value & 0xFF;
    }

    public static void intToBytes(int value, int[] data, int idx) {
        data[idx] = value >> 24 & 0xFF;
        data[idx + 1] = value >> 16 & 0xFF;
        data[idx + 2] = value >> 8 & 0xFF;
        data[idx + 3] = value & 0xFF;
    }

    public static void intToBytesReverse(int value, int[] data, int idx) {
        data[idx + 3] = value >> 24 & 0xFF;
        data[idx + 2] = value >> 16 & 0xFF;
        data[idx + 1] = value >> 8 & 0xFF;
        data[idx] = value & 0xFF;
    }

    public static void dwordToBytes(long value, int[] data, int idx) {
        data[idx] = (int)(value >> 24 & 0xFFL);
        data[idx + 1] = (int)(value >> 16 & 0xFFL);
        data[idx + 2] = (int)(value >> 8 & 0xFFL);
        data[idx + 3] = (int)(value & 0xFFL);
    }

    public static void intToHexByte(int value, int[] data, int idx) {
        data[idx] = hexDigit[value >> 4 & 0xF];
        data[idx + 1] = hexDigit[value & 0xF];
    }

    public static void intToHexWord(int value, int[] data, int idx) {
        data[idx + 3] = hexDigit[value & 0xF];
        data[idx + 2] = hexDigit[(value >>= 4) & 0xF];
        data[idx + 1] = hexDigit[(value >>= 4) & 0xF];
        data[idx] = hexDigit[(value >>= 4) & 0xF];
    }

    public static int intToHex(int val, int[] buff, int offset) {
        int last;
        int mag = 32 - Integer.numberOfLeadingZeros(val);
        int len = Math.max((mag + 3) / 4, 1);
        int charPos = last = len + offset;
        do {
            buff[--charPos] = hexDigit[val & 0xF];
        } while ((val >>>= 4) != 0 && charPos > 0);
        return last;
    }

    public static char[] toHexChars(int val) {
        int mag = 32 - Integer.numberOfLeadingZeros(val);
        int len = Math.max((mag + 3) / 4, 1);
        char[] buf = new char[len];
        int charPos = len;
        do {
            buf[--charPos] = hexDigitChar[val & 0xF];
        } while ((val >>>= 4) != 0 && charPos > 0);
        return buf;
    }

    public static String toHexString(int val) {
        return new String(Numbers.toHexChars(val));
    }

    public static char[] toHexChars(long val, int size) {
        char[] buf = new char[size];
        do {
            buf[--size] = hexDigitChar[(int)(val & 0xFL)];
            val >>>= 4;
        } while (size > 0);
        return buf;
    }

    public static String toHexString(long val, int size) {
        return new String(Numbers.toHexChars(val, size));
    }

    public static float decodeFloat16(int code) {
        int mant = code & 0x3FF;
        int exp = code & 0x7C00;
        if (exp == 31744) {
            exp = 261120;
        } else if (exp != 0) {
            if (mant == 0 && (exp += 114688) > 115712) {
                return Float.intBitsToFloat((code & 0x8000) << 16 | exp << 13 | 0x3FF);
            }
        } else if (mant != 0) {
            exp = 115712;
            do {
                exp -= 1024;
            } while (((mant <<= 1) & 0x400) == 0);
            mant &= 0x3FF;
        }
        return Float.intBitsToFloat((code & 0x8000) << 16 | (exp | mant) << 13);
    }

    public static int encodeFloat16(float value) {
        int fbits = Float.floatToIntBits(value);
        int sign = fbits >>> 16 & 0x8000;
        int val = (fbits & Integer.MAX_VALUE) + 4096;
        if (val >= 1199570944) {
            if ((fbits & Integer.MAX_VALUE) >= 1199570944) {
                if (val < 2139095040) {
                    return sign | 0x7C00;
                }
                return sign | 0x7C00 | (fbits & 0x7FFFFF) >>> 13;
            }
            return sign | 0x7BFF;
        }
        if (val >= 0x38800000) {
            return sign | val - 0x38000000 >>> 13;
        }
        if (val < 0x33000000) {
            return sign;
        }
        val = (fbits & Integer.MAX_VALUE) >>> 23;
        return sign | (fbits & 0x7FFFFF | 0x800000) + (0x800000 >>> val - 102) >>> 126 - val;
    }

    public static float decodeFloat32(int code) {
        return Float.intBitsToFloat(code);
    }

    public static int encodeFloat32(float value) {
        return Float.floatToIntBits(value);
    }

    public static double decodeDouble64(long code) {
        return Double.longBitsToDouble(code);
    }

    public static long encodeDouble64(double value) {
        return Double.doubleToLongBits(value);
    }

    public static int limit(int value, int valmin, int valmax) {
        return Math.min(Math.max(value, valmin), valmax);
    }

    public static boolean compareIntArrays(int[] a, int[] b, int size) {
        for (int i = 0; i < size; ++i) {
            if (a[i] == b[i]) continue;
            return false;
        }
        return true;
    }
}

