/*
 * Decompiled with CFR 0.152.
 */
package org.tanukisoftware.wrapper.test;

import java.io.File;
import org.tanukisoftware.wrapper.WrapperManager;
import org.tanukisoftware.wrapper.WrapperProcessConfig;
import org.tanukisoftware.wrapper.test.Main;
import org.tanukisoftware.wrapper.test.RuntimeExec;

public class ExecSignals {
    private static boolean m_bashForwardsSignals = false;
    private static boolean m_debug = false;
    private static boolean m_autoClose = true;
    private static final boolean m_powershellPresent = new File("C:\\Windows\\System32\\WindowsPowerShell").exists();
    private static final int CRASH_DELAY_S = 1;
    private static final long CRASH_DELAY_MS = 1000L;
    private static final int CTRL_C_DELAY_S = 2;
    private static final long CTRL_C_DELAY_MS = 2000L;
    private static final int CHILD_SLEEP_TIME_S = 10;
    private static final long CHILD_SLEEP_TIME_MS = 10000L;
    private static final int CHILD_KILL_TIMEOUT_S = 5;
    private static final long CHILD_KILL_TIMEOUT_MS = 5000L;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void doTest(String command, String testId, long timeoutMS, boolean newProcessGroup, int startType, int expectedExitCode, long expectedTimeMs) {
        RuntimeExec.beginCase(testId);
        try {
            if (!WrapperProcessConfig.isSupported((int)startType)) {
                System.out.println(Main.getRes().getString("{0} startType {1} not supported", (Object)testId, (Object)Integer.toString(startType)));
                return;
            }
            WrapperProcessConfig wrapperProcessConfig = new WrapperProcessConfig().setNewProcessGroup(newProcessGroup).setAutoCloseInputStreams(m_autoClose).setStartType(startType);
            try {
                RuntimeExec.handleWrapperProcess(testId, command, wrapperProcessConfig, timeoutMS, true, false, false, 2, expectedExitCode, m_debug);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        finally {
            RuntimeExec.endCase(testId, expectedTimeMs);
        }
    }

    private static void doTests(String executable, boolean newProcessGroup, int startType) {
        boolean executableExists = new File(executable).exists();
        StringBuffer sb = new StringBuffer();
        if (startType == 1) {
            sb.append("PosixSpawn");
        } else if (startType == 2) {
            sb.append("Fork");
        } else if (startType == 3) {
            sb.append("VFork");
        } else {
            sb.append("Dynamic");
        }
        sb.append(" ");
        if (newProcessGroup) {
            sb.append("NewProcessGroup");
        } else {
            sb.append("SharedProcessGroup");
        }
        sb.append(" ");
        String context = sb.toString();
        if (executableExists) {
            ExecSignals.doTest(executable + " 3 " + 10, context + "NoIgnore Destroy " + 2 + "s : ", 2000L, newProcessGroup, startType, RuntimeExec.EXIT_CODE_TERM_CTRL_C, 2000L);
            ExecSignals.doTest(executable + " -ignoresignals 3 " + 10, context + "Ignore Destroy " + 2 + "s : ", 2000L, newProcessGroup, startType, RuntimeExec.EXIT_CODE_KILLED, 2000L + (WrapperManager.isWindows() ? 0L : 5000L));
            ExecSignals.doTest(executable + " -crash 3 " + 1, context + "NoIgnore Crash : ", 0L, newProcessGroup, startType, RuntimeExec.EXIT_CODE_CRASH, 1000L);
            ExecSignals.doTest(executable + " -ignoresignals -crash 3 " + 1, context + "Ignore Crash  : ", 0L, newProcessGroup, startType, RuntimeExec.EXIT_CODE_CRASH, 1000L);
        } else {
            ExecSignals.doTest(executable + " 3 " + 10, context + "NoIgnore Destroy " + 2 + "s : ", 2000L, newProcessGroup, startType, RuntimeExec.EXIT_CODE_COMMAND_NOT_FOUND, 0L);
        }
        if (WrapperManager.isWindows()) {
            if (executableExists) {
                ExecSignals.doTest("cmd /c \"" + executable + " 3 " + 10 + "\"", context + "CMD Destroy " + 2 + "s : ", 2000L, newProcessGroup, startType, RuntimeExec.EXIT_CODE_TERM_CTRL_C, 10000L);
                if (m_powershellPresent) {
                    ExecSignals.doTest("powershell.exe \"" + executable + " 3 " + 10 + "\"", context + "PowerShell Destroy " + 2 + "s : ", 2000L, newProcessGroup, startType, RuntimeExec.EXIT_CODE_TERM_CTRL_C, 10000L);
                }
                ExecSignals.doTest("cmd /c \"" + executable + " -ignoresignals 3 " + 10 + "\"", context + "CMD Destroy " + 2 + "s : ", 2000L, newProcessGroup, startType, RuntimeExec.EXIT_CODE_TERM_CTRL_C, 10000L);
                if (m_powershellPresent) {
                    ExecSignals.doTest("powershell.exe \"" + executable + " -ignoresignals 3 " + 10 + "\"", context + "PowerShell Destroy " + 2 + "s : ", 2000L, newProcessGroup, startType, RuntimeExec.EXIT_CODE_TERM_CTRL_C, 10000L);
                }
            } else {
                ExecSignals.doTest("cmd /c \"" + executable + " 3 " + 10 + "\"", context + "Bash Destroy " + 2 + "s : ", 2000L, newProcessGroup, startType, RuntimeExec.EXIT_CODE_COMMAND_NOT_FOUND, 0L);
            }
        } else if (executableExists) {
            long expectedTimeMs;
            ExecSignals.doTest("bash -c \"" + executable + " 3 " + 10 + "\"", context + "Bash Destroy " + 2 + "s : ", 2000L, newProcessGroup, startType, RuntimeExec.EXIT_CODE_TERM_CTRL_C, 2000L);
            if (!WrapperManager.isZOS()) {
                expectedTimeMs = m_bashForwardsSignals ? 2000L : (newProcessGroup ? 2000L : (m_autoClose ? 2000L : 10000L));
                ExecSignals.doTest("bash -c \"export FOO=bar;" + executable + " 3 " + 10 + "\"", context + "Bash+env Destroy " + 2 + "s : ", 2000L, newProcessGroup, startType, RuntimeExec.EXIT_CODE_TERM_CTRL_C, expectedTimeMs);
            } else {
                ExecSignals.doTest("bash -c \"export FOO=bar;" + executable + " 3 " + 10 + "\"", context + "Bash+env Destroy " + 2 + "s : ", 2000L, newProcessGroup, startType, RuntimeExec.EXIT_CODE_TERM_CTRL_C, 2000L);
            }
            ExecSignals.doTest("bash -c \"" + executable + " -ignoresignals 3 " + 10 + "\"", context + "Bash Ignore Destroy " + 2 + "s : ", 2000L, newProcessGroup, startType, RuntimeExec.EXIT_CODE_KILLED, 7000L);
            ExecSignals.doTest("bash -c \"" + executable + " -crash 3 " + 1 + "\"", context + "Bash NoIgnore Crash : ", 0L, newProcessGroup, startType, RuntimeExec.EXIT_CODE_CRASH, 1000L);
            ExecSignals.doTest("bash -c \"" + executable + " -ignoresignals -crash 3 " + 1 + "\"", context + "Bash Ignore Crash  : ", 0L, newProcessGroup, startType, RuntimeExec.EXIT_CODE_CRASH, 1000L);
            if (!WrapperManager.isZOS()) {
                int expectedExitCode;
                if (m_bashForwardsSignals) {
                    expectedTimeMs = 7000L;
                    expectedExitCode = RuntimeExec.EXIT_CODE_KILLED;
                } else {
                    expectedTimeMs = newProcessGroup ? 7000L : (m_autoClose ? 2000L : 10000L);
                    expectedExitCode = RuntimeExec.EXIT_CODE_TERM_CTRL_C;
                }
                ExecSignals.doTest("bash -c \"export FOO=bar;" + executable + " -ignoresignals 3 " + 10 + "\"", context + "Bash+env Ignore Destroy " + 2 + "s : ", 2000L, newProcessGroup, startType, expectedExitCode, expectedTimeMs);
            } else {
                ExecSignals.doTest("bash -c \"export FOO=bar;" + executable + " -ignoresignals 3 " + 10 + "\"", context + "Bash+env Ignore Destroy " + 2 + "s : ", 2000L, newProcessGroup, startType, RuntimeExec.EXIT_CODE_TERM_CTRL_C, newProcessGroup ? 7000L : 2000L);
            }
            ExecSignals.doTest("bash -c \"export FOO=bar;" + executable + " -crash 3 " + 1 + "\"", context + "Bash+env NoIgnore Crash : ", 0L, newProcessGroup, startType, RuntimeExec.EXIT_CODE_CRASH, 1000L);
            ExecSignals.doTest("bash -c \"export FOO=bar;" + executable + " -ignoresignals -crash 3 " + 1 + "\"", context + "Bash+env Ignore Crash  : ", 0L, newProcessGroup, startType, RuntimeExec.EXIT_CODE_CRASH, 1000L);
        } else {
            ExecSignals.doTest("bash -c \"" + executable + " 3 " + 10 + "\"", context + "Bash Destroy " + 2 + "s : ", 2000L, newProcessGroup, startType, RuntimeExec.EXIT_CODE_COMMAND_NOT_FOUND, 0L);
            ExecSignals.doTest("bash -c \"export FOO=bar;" + executable + " 3 " + 10 + "\"", context + "Bash+env Destroy " + 2 + "s : ", 2000L, newProcessGroup, startType, RuntimeExec.EXIT_CODE_COMMAND_NOT_FOUND, 0L);
        }
    }

    public static void main(String[] args) {
        String doesnotexist;
        String simplewaiter;
        RuntimeExec.c_testsPerformed = 0;
        RuntimeExec.c_testsFailed = 0;
        if (WrapperManager.isWindows()) {
            simplewaiter = "..\\test\\simplewaiter.exe";
            doesnotexist = "..\\test\\doesnotexist.exe";
        } else {
            simplewaiter = "../test/simplewaiter";
            doesnotexist = "../test/doesnotexist";
        }
        if (!WrapperManager.isWindows()) {
            if (args.length > 0 && "true".equals(args[0])) {
                System.out.println(Main.getRes().getString("Detected that Bash forwards signals to its child processes."));
                m_bashForwardsSignals = true;
            }
            if (args.length > 1) {
                if ("true".equals(args[1])) {
                    System.out.println(Main.getRes().getString("Using Auto-close mode to read the pipes."));
                    m_autoClose = true;
                } else {
                    System.out.println(Main.getRes().getString("Using Blocking mode to read the pipes."));
                    m_autoClose = false;
                }
            }
            if (args.length > 2 && "true".equals(args[2])) {
                System.out.println(Main.getRes().getString("DEBUG mode enabled."));
                m_debug = true;
            }
        }
        ExecSignals.doTests(simplewaiter, true, 4);
        ExecSignals.doTests(doesnotexist, true, 4);
        if (!WrapperManager.isWindows()) {
            ExecSignals.doTests(simplewaiter, false, 4);
            ExecSignals.doTests(doesnotexist, false, 4);
            if (WrapperProcessConfig.isSupported((int)2)) {
                ExecSignals.doTests(simplewaiter, true, 2);
                ExecSignals.doTests(simplewaiter, false, 2);
                ExecSignals.doTests(doesnotexist, true, 2);
                ExecSignals.doTests(doesnotexist, false, 2);
            }
            if (WrapperProcessConfig.isSupported((int)3)) {
                ExecSignals.doTests(simplewaiter, true, 3);
                ExecSignals.doTests(simplewaiter, false, 3);
                ExecSignals.doTests(doesnotexist, true, 3);
                ExecSignals.doTests(doesnotexist, false, 3);
            }
            if (WrapperProcessConfig.isSupported((int)1)) {
                ExecSignals.doTests(simplewaiter, true, 1);
                ExecSignals.doTests(simplewaiter, false, 1);
                ExecSignals.doTests(doesnotexist, true, 1);
                ExecSignals.doTests(doesnotexist, false, 1);
            }
        }
        int nbTestsFailed = RuntimeExec.c_testsFailed;
        int nbTestsPassed = RuntimeExec.c_testsPerformed - nbTestsFailed;
        System.out.println("");
        System.out.println(Main.getRes().getString("[PASSED] {0}", (Object)Integer.toString(nbTestsPassed)));
        System.out.println(Main.getRes().getString("[FAILED] {0}", (Object)Integer.toString(nbTestsFailed)));
        if (nbTestsFailed > 0) {
            System.exit(1);
        }
    }
}

