/*
 * Decompiled with CFR 0.152.
 */
package org.tanukisoftware.wrapper.test;

import org.tanukisoftware.wrapper.WrapperManager;
import org.tanukisoftware.wrapper.test.LongRunningBackgroundThreads;
import org.tanukisoftware.wrapper.test.Main;

public class LongRunningWithShutdownHook
implements Runnable {
    private volatile int m_threadCount;

    public void run() {
        ++this.m_threadCount;
        int loops = 0;
        while (loops < 60) {
            System.out.println(Main.getRes().getString("{0} loop #{1}", new Object[]{Thread.currentThread().getName(), new Integer(++loops)}));
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException interruptedException) {}
        }
        System.out.println(Main.getRes().getString("{0} stopping", (Object)Thread.currentThread().getName()));
        --this.m_threadCount;
        if (this.m_threadCount <= 0) {
            System.out.println(Main.getRes().getString("The JVM and then the wrapper should exit now."));
        }
    }

    public static void main(String[] args) {
        System.out.println(Main.getRes().getString("This test is a combination of the 'Long-running Background Threads' test followed by the execution of shutdown hook."));
        System.out.println(Main.getRes().getString("This is to test the wrapper.jvm_exit.timeout property when the Wrapper requests the JVM to stop (e.g with a CTRL+C)."));
        System.out.println(Main.getRes().getString("Running as a service: {0}", (Object)new Boolean(WrapperManager.isLaunchedAsService())));
        System.out.println(Main.getRes().getString("Controlled by wrapper: {0}", (Object)new Boolean(WrapperManager.isControlledByNativeWrapper())));
        LongRunningBackgroundThreads app = new LongRunningBackgroundThreads();
        for (int i = 0; i < 2; ++i) {
            Thread thread = new Thread((Runnable)app, "App-Thread-" + i);
            thread.start();
        }
        Runtime.getRuntime().addShutdownHook(new Thread(){

            public void run() {
                System.out.println(Main.getRes().getString("Starting shutdown hook. Loop for 25 seconds."));
                System.out.println(Main.getRes().getString("Should timeout unless this property is set: wrapper.jvm_exit.timeout=30"));
                long start = System.currentTimeMillis();
                while (System.currentTimeMillis() - start < 25000L) {
                    try {
                        Thread.sleep(250L);
                    }
                    catch (InterruptedException e) {}
                }
                System.out.println(Main.getRes().getString("Shutdown hook complete. Should exit now."));
                System.out.println("GC BEGIN");
                System.gc();
                System.out.println("GC END");
                try {
                    Thread.sleep(2000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                System.out.println("DONE");
            }
        });
        System.out.println(Main.getRes().getString("Application complete.  Wrapper should stop, invoking the shutdown hooks."));
        System.out.println();
    }
}

