/*
 * Decompiled with CFR 0.152.
 */
package org.tanukisoftware.wrapper.test;

import java.io.File;
import org.tanukisoftware.wrapper.WrapperManager;
import org.tanukisoftware.wrapper.WrapperProcessConfig;
import org.tanukisoftware.wrapper.test.Main;
import org.tanukisoftware.wrapper.test.RuntimeExec;

public class ExecWorkingDir {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void doTest(String command, String chDir, int startType, boolean spawnChDir) {
        StringBuffer sb = new StringBuffer("'" + chDir + "' ");
        if (startType == 1) {
            sb.append("PosixSpawn");
        } else if (startType == 2) {
            sb.append("Fork");
        } else if (startType == 3) {
            sb.append("VFork");
        } else {
            sb.append("Dynamic");
        }
        sb.append(" ");
        if (spawnChDir) {
            sb.append("(spawnChDir) ");
        }
        String testId = sb.toString();
        RuntimeExec.beginCase(testId);
        try {
            if (!WrapperProcessConfig.isSupported((int)startType)) {
                System.out.println(Main.getRes().getString("{0} startType {1} not supported", (Object)testId, (Object)Integer.toString(startType)));
                return;
            }
            try {
                WrapperProcessConfig wrapperProcessConfig = new WrapperProcessConfig().setWorkingDirectory(new File(chDir)).setStartType(startType);
                RuntimeExec.handleWrapperProcess(testId, command, wrapperProcessConfig, 0L, true, false, false, 1, 0, false);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        finally {
            RuntimeExec.endCase(testId, 0L);
        }
    }

    public static void main(String[] args) {
        String command = WrapperManager.isWindows() ? "cmd /c cd" : "pwd";
        System.out.println("");
        System.out.println(Main.getRes().getString("Please check that each command run in its correct directory."));
        ExecWorkingDir.doTest(command, ".", 4, false);
        ExecWorkingDir.doTest(command, "..", 4, false);
        if (!WrapperManager.isWindows()) {
            ExecWorkingDir.doTest(command, ".", 1, false);
            ExecWorkingDir.doTest(command, "..", 1, false);
            ExecWorkingDir.doTest(command, ".", 2, false);
            ExecWorkingDir.doTest(command, "..", 2, false);
            ExecWorkingDir.doTest(command, ".", 3, false);
            ExecWorkingDir.doTest(command, "..", 3, false);
            System.setProperty("wrapper.child.allowCWDOnSpawn", "TRUE");
            ExecWorkingDir.doTest(command, ".", 4, true);
            ExecWorkingDir.doTest(command, "..", 4, true);
            ExecWorkingDir.doTest(command, ".", 1, true);
            ExecWorkingDir.doTest(command, "..", 1, true);
        }
    }
}

