/*
 * Decompiled with CFR 0.152.
 */
package promauto.jroboplc.core;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.Statement;
import java.util.HashSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import promauto.jroboplc.core.api.Console;
import promauto.jroboplc.core.api.Database;
import promauto.jroboplc.core.api.EnvironmentInst;

public class DbHelper {
    private static final Logger logger = LoggerFactory.getLogger(DbHelper.class);

    public static void clear(Console console, Database dbdst, String strTables) {
        String[] tbls = strTables.split("\\s*,\\s*");
        try (Statement st = dbdst.getConnection().createStatement();){
            for (String tbl : tbls) {
                console.print("clear " + tbl + ":");
                String sql = "delete from " + tbl;
                st.executeUpdate(sql);
                dbdst.commit();
                console.print(" OK\n");
            }
        }
        catch (Exception e) {
            EnvironmentInst.get().printError(logger, e, new String[0]);
            try {
                dbdst.rollback();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static void copygen(Console console, Database dbdst, String tbl, String gen, String id) {
        console.print("set " + gen + ":");
        String sql = "select max(" + id + ") from " + tbl;
        try (Statement st = dbdst.getConnection().createStatement();
             ResultSet rs = st.executeQuery(sql);){
            if (rs.next()) {
                int value = rs.getInt(1);
                sql = "ALTER SEQUENCE " + gen + " RESTART WITH " + value;
                st.executeUpdate(sql);
            }
            dbdst.commit();
        }
        catch (Exception e) {
            EnvironmentInst.get().printError(logger, e, new String[0]);
            try {
                dbdst.rollback();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        console.print(" OK\n");
    }

    public static void copytbl(Console console, Database dbsrc, Database dbdst, String tbl, String strColumns) {
        DbHelper.copytbl(console, dbsrc, dbdst, tbl, strColumns, "", "");
    }

    public static void copytbl(Console console, Database dbsrc, Database dbdst, String tbl, String strColumns, String checkIdField, String checkIdTable) {
        console.print("copy " + tbl + ": ");
        try (Statement stsrc = dbsrc.getConnection().createStatement();){
            Throwable throwable;
            ResultSet rs;
            String sql;
            if (!dbsrc.hasTable(stsrc, "", tbl)) {
                console.print("source table not found!\n");
                return;
            }
            boolean checkId = !checkIdField.isEmpty() && !checkIdTable.isEmpty();
            HashSet<Integer> ids = new HashSet<Integer>();
            if (checkId) {
                sql = "select " + checkIdField + " from " + checkIdTable;
                rs = stsrc.executeQuery(sql);
                throwable = null;
                try {
                    while (rs.next()) {
                        ids.add(rs.getInt(1));
                    }
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (rs != null) {
                        if (throwable != null) {
                            try {
                                rs.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                        } else {
                            rs.close();
                        }
                    }
                }
            }
            sql = "select " + strColumns + " from " + tbl;
            rs = stsrc.executeQuery(sql);
            throwable = null;
            try {
                int i;
                ResultSetMetaData md = rs.getMetaData();
                int n = md.getColumnCount();
                if (strColumns.equals("*")) {
                    strColumns = "";
                    for (i = 1; i <= n; ++i) {
                        strColumns = strColumns + (i > 1 ? ", " : "") + md.getColumnName(i);
                    }
                }
                sql = "insert into " + tbl + " (" + strColumns + ") values (";
                for (i = 1; i <= n; ++i) {
                    sql = sql + (i > 1 ? ", ?" : "?");
                }
                sql = sql + ')';
                boolean skip = false;
                int cnt1 = 0;
                int cnt2 = tbl.length() + 7;
                PreparedStatement dst = dbdst.getConnection().prepareStatement(sql);
                while (rs.next()) {
                    skip = false;
                    block44: for (int i2 = 1; i2 <= n; ++i2) {
                        if (checkId && md.getColumnName(i2).equals(checkIdField) && !ids.contains(rs.getInt(i2))) {
                            skip = true;
                            break;
                        }
                        switch (md.getColumnType(i2)) {
                            case -5: 
                            case 4: 
                            case 5: {
                                dst.setLong(i2, rs.getLong(i2));
                                continue block44;
                            }
                            case 93: {
                                dst.setTimestamp(i2, rs.getTimestamp(i2));
                                continue block44;
                            }
                            default: {
                                dst.setString(i2, rs.getString(i2));
                            }
                        }
                    }
                    if (skip) continue;
                    dst.executeUpdate();
                    if (cnt1++ <= 500) continue;
                    cnt1 = 0;
                    console.print("*");
                    dbdst.commit();
                    if (cnt2++ <= 80) continue;
                    cnt2 = 0;
                    console.print("\n");
                }
            }
            catch (Throwable throwable4) {
                throwable = throwable4;
                throw throwable4;
            }
            finally {
                if (rs != null) {
                    if (throwable != null) {
                        try {
                            rs.close();
                        }
                        catch (Throwable throwable5) {
                            throwable.addSuppressed(throwable5);
                        }
                    } else {
                        rs.close();
                    }
                }
            }
            dbdst.commit();
            dbsrc.commit();
            console.print(" OK\n");
        }
        catch (Exception e) {
            EnvironmentInst.get().printError(logger, e, new String[0]);
            try {
                dbsrc.rollback();
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                dbdst.rollback();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static void sweep(Console console, Database db, String table, String dtfield, int year) {
        String dt = year + ".12.31 23.59.59.999";
        String sql = "delete from " + table + " where " + dtfield + " <= '" + dt + "'";
        try (Statement st = db.getConnection().createStatement();){
            console.print("delete from " + table + "...");
            int cnt = st.executeUpdate(sql);
            db.commit();
            console.print(" " + cnt + " records\n");
        }
        catch (Exception e) {
            EnvironmentInst.get().printError(logger, e, new String[0]);
            try {
                db.rollback();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

