/*
 * Decompiled with CFR 0.152.
 */
package promauto.jroboplc.core;

import java.time.LocalDate;
import java.time.temporal.ChronoUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import promauto.jroboplc.core.api.Configuration;
import promauto.jroboplc.core.api.EnvironmentInst;

public class LoggerMode {
    final Logger logger = LoggerFactory.getLogger(LoggerMode.class);
    LocalDate ld = null;
    boolean fl = false;
    int val = 0;

    public LoggerMode() {
        Configuration cm = EnvironmentInst.get().getConfiguration();
        String s = cm.get(cm.getRoot(), "log.mode", "");
        s = s.trim();
        if (s.isEmpty()) {
            this.fl = true;
            this.ld = null;
            this.val = 0;
        } else {
            int a = Integer.parseInt(s.replace(",", ""), 8);
            int[] b = new int[4];
            for (int i = 0; i < 4; ++i) {
                b[i] = a % 100;
                a /= 100;
            }
            boolean bl = this.fl = b[0] + b[1] + b[2] == b[3];
            if (this.fl) {
                b[2] = b[2] + 2000;
                this.ld = LocalDate.of(b[2], b[1], b[0]);
                this.val = b[2] * 10000 + b[1] * 100 + b[0];
            } else {
                EnvironmentInst.get().printError(this.logger, "Bad logger mode!");
            }
        }
    }

    public int get() {
        return this.val;
    }

    public boolean isOk() {
        if (this.fl) {
            if (this.ld == null) {
                return true;
            }
            long d = LocalDate.now().until(this.ld, ChronoUnit.DAYS);
            if (d > 0L) {
                return true;
            }
        }
        return false;
    }
}

