/*
 * Decompiled with CFR 0.152.
 */
package promauto.jroboplc.core.tags;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import promauto.jroboplc.core.api.Configuration;
import promauto.jroboplc.core.api.EnvironmentInst;
import promauto.jroboplc.core.api.Module;
import promauto.jroboplc.core.api.Tag;

public class Ref {
    private final Logger logger = LoggerFactory.getLogger(Ref.class);
    private String refTagName;
    private String refModuleName;
    private String refModuleTagName;
    private Tag tag = null;
    private Module refModule;
    private boolean prepared = false;

    Ref() {
    }

    public boolean init(Object conf, String refname, Module module) {
        boolean res;
        assert (module != null);
        Configuration cm = EnvironmentInst.get().getConfiguration();
        String nameModuleTag = cm.get(conf, refname, "");
        int p = nameModuleTag.indexOf(58);
        if (p >= 0) {
            this.refModuleName = nameModuleTag.substring(0, p);
            this.refTagName = nameModuleTag.substring(p + 1);
        } else {
            this.refModuleName = module.getName();
            this.refTagName = nameModuleTag;
        }
        boolean bl = res = !this.refModuleName.isEmpty() && !this.refTagName.isEmpty();
        if (!res) {
            EnvironmentInst.get().printError(this.logger, "Bad refname: ", nameModuleTag);
        }
        this.prepared = false;
        return res;
    }

    public boolean init(String nameModuleTag) {
        int p = nameModuleTag.indexOf(58);
        if (p < 0) {
            EnvironmentInst.get().printError(this.logger, "Bad refname: ", nameModuleTag);
            return false;
        }
        this.init(nameModuleTag.substring(0, p), nameModuleTag.substring(p + 1));
        return true;
    }

    public boolean init(String nameLinkModule, String nameLinkTag) {
        assert (!nameLinkModule.isEmpty());
        assert (!nameLinkTag.isEmpty());
        this.refModuleName = nameLinkModule;
        this.refTagName = nameLinkTag;
        this.prepared = false;
        return true;
    }

    public boolean prepare() {
        this.refModule = EnvironmentInst.get().getModuleManager().getModule(this.refModuleName);
        if (this.refModule == null) {
            this.refModuleTagName = this.refModuleName + "." + this.refTagName;
        }
        this.prepared = true;
        return true;
    }

    public boolean link() {
        if (!this.prepared) {
            this.prepare();
        }
        this.tag = this.refModule == null ? EnvironmentInst.get().getModuleManager().searchExternalTag(this.refModuleTagName) : this.refModule.getTagTable().get(this.refTagName);
        return this.tag != null;
    }

    public boolean isValid() {
        return this.tag != null && this.tag.getStatus() != Tag.Status.Deleted;
    }

    public boolean linkIfNotValid() {
        return this.isValid() || this.link();
    }

    public String getName() {
        return this.refModuleName + ":" + this.refTagName;
    }

    public String getRefModuleName() {
        return this.refModuleName;
    }

    public String getRefTagName() {
        return this.refTagName;
    }

    public Tag getTag() {
        return this.tag;
    }

    public boolean getBool() {
        return this.tag != null && this.tag.getBool();
    }

    public int getInt() {
        return this.tag == null ? 0 : this.tag.getInt();
    }

    public long getLong() {
        return this.tag == null ? 0L : this.tag.getLong();
    }

    public double getDouble() {
        return this.tag == null ? 0.0 : this.tag.getDouble();
    }

    public String getString() {
        return this.tag == null ? "" : this.tag.getString();
    }

    public void setBool(boolean value) {
        if (this.tag != null) {
            this.tag.setBool(value);
        }
    }

    public void setInt(int value) {
        if (this.tag != null) {
            this.tag.setInt(value);
        }
    }

    public void setLong(long value) {
        if (this.tag != null) {
            this.tag.setLong(value);
        }
    }

    public void setDouble(double value) {
        if (this.tag != null) {
            this.tag.setDouble(value);
        }
    }

    public void setString(String value) throws NumberFormatException {
        if (this.tag != null) {
            this.tag.setString(value);
        }
    }

    public String check() {
        return this.isValid() ? "" : String.format("%s - %s not found", this.getName(), this.refModule == null ? "module" : "tagname");
    }

    public String checkLn() {
        String res = this.check();
        return res.isEmpty() ? "" : "\r\n" + res;
    }
}

