/*
 * Decompiled with CFR 0.152.
 */
package promauto.jroboplc.core.tags;

import promauto.jroboplc.core.api.Tag;
import promauto.jroboplc.core.tags.TagBase;

public class TagDouble
extends TagBase {
    private volatile double value;

    public TagDouble(String name, double value) {
        super(name);
        this.setDouble(value);
    }

    public TagDouble(String name, double value, int flags) {
        super(name, flags);
        this.setDouble(value);
    }

    @Override
    public Tag.Type getType() {
        return Tag.Type.DOUBLE;
    }

    @Override
    public boolean getBool() {
        return this.value != 0.0;
    }

    @Override
    public int getInt() {
        return (int)this.value;
    }

    @Override
    public long getLong() {
        return (long)this.value;
    }

    @Override
    public double getDouble() {
        return this.value;
    }

    @Override
    public String getString() {
        return "" + this.value;
    }

    @Override
    public void setBool(boolean value) {
        if (this.value != (value ? 1.0 : 0.0)) {
            this.value = value ? 1.0 : 0.0;
        }
    }

    @Override
    public void setOn() {
        if (this.value != 1.0) {
            this.value = 1.0;
        }
    }

    @Override
    public void setOff() {
        if (this.value != 0.0) {
            this.value = 0.0;
        }
    }

    @Override
    public void setInt(int value) {
        if (this.value != (double)value) {
            this.value = value;
        }
    }

    @Override
    public void setLong(long value) {
        if (this.value != (double)value) {
            this.value = value;
        }
    }

    @Override
    public void setDouble(double value) {
        if (this.value != value) {
            this.value = value;
        }
    }

    @Override
    public void setString(String value) {
        double parsed;
        try {
            parsed = Double.parseDouble(value.trim());
        }
        catch (NumberFormatException e) {
            parsed = 0.0;
        }
        if (this.value != parsed) {
            this.value = parsed;
        }
    }

    @Override
    public boolean equalsValue(Tag tag) {
        return tag.getDouble() == this.value;
    }

    @Override
    public void copyValueTo(Tag tag) {
        tag.setDouble(this.value);
    }
}

