/*
 * Decompiled with CFR 0.152.
 */
package promauto.jroboplc.core.tags;

import promauto.jroboplc.core.api.Tag;
import promauto.jroboplc.core.tags.TagPlain;

public class TagPlainBool
extends TagPlain {
    boolean value;

    public TagPlainBool(String name, boolean value) {
        super(name);
        this.value = value;
    }

    @Override
    public Tag.Type getType() {
        return Tag.Type.BOOL;
    }

    @Override
    public boolean equalsValue(Tag tag) {
        return tag.getBool() == this.value;
    }

    @Override
    public void copyValueTo(Tag tag) {
        tag.setBool(this.value);
    }

    @Override
    public boolean getBool() {
        return this.value;
    }

    @Override
    public int getInt() {
        return this.value ? 1 : 0;
    }

    @Override
    public long getLong() {
        return this.value ? 1L : 0L;
    }

    @Override
    public double getDouble() {
        return this.value ? 1.0 : 0.0;
    }

    @Override
    public String getString() {
        return this.value ? "on" : "off";
    }

    @Override
    public void setBool(boolean value) {
        this.value = value;
    }

    @Override
    public void setOn() {
        this.value = true;
    }

    @Override
    public void setOff() {
        this.value = false;
    }

    @Override
    public void setInt(int value) {
        this.value = value != 0;
    }

    @Override
    public void setLong(long value) {
        this.value = value != 0L;
    }

    @Override
    public void setDouble(double value) {
        this.value = value != 0.0;
    }

    @Override
    public void setString(String value) {
        this.value = value.equals("on");
    }
}

