/*
 * Decompiled with CFR 0.152.
 */
package promauto.jroboplc.core.tags;

import promauto.jroboplc.core.api.Tag;
import promauto.jroboplc.core.tags.TagPlain;

public class TagPlainInt
extends TagPlain {
    int value;

    public TagPlainInt(String name, int value) {
        super(name);
        this.value = value;
    }

    @Override
    public Tag.Type getType() {
        return Tag.Type.INT;
    }

    @Override
    public boolean equalsValue(Tag tag) {
        return tag.getInt() == this.value;
    }

    @Override
    public void copyValueTo(Tag tag) {
        tag.setInt(this.value);
    }

    @Override
    public boolean getBool() {
        return this.value != 0;
    }

    @Override
    public int getInt() {
        return this.value;
    }

    @Override
    public long getLong() {
        return this.value;
    }

    @Override
    public double getDouble() {
        return this.value;
    }

    @Override
    public String getString() {
        return "" + this.value;
    }

    @Override
    public void setBool(boolean value) {
        this.value = value ? 1 : 0;
    }

    @Override
    public void setOn() {
        this.value = 1;
    }

    @Override
    public void setOff() {
        this.value = 0;
    }

    @Override
    public void setInt(int value) {
        this.value = value;
    }

    @Override
    public void setLong(long value) {
        this.value = (int)value;
    }

    @Override
    public void setDouble(double value) {
        this.value = (int)value;
    }

    @Override
    public void setString(String value) {
        try {
            this.value = Integer.parseInt(value.trim());
        }
        catch (NumberFormatException e) {
            this.value = 0;
        }
    }
}

