/*
 * Decompiled with CFR 0.152.
 */
package promauto.jroboplc.plugin.arcsvr;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import promauto.jroboplc.core.AbstractModule;
import promauto.jroboplc.core.api.Configuration;
import promauto.jroboplc.core.api.Database;
import promauto.jroboplc.core.api.Module;
import promauto.jroboplc.core.api.Plugin;
import promauto.jroboplc.core.api.Signal;
import promauto.jroboplc.core.api.Tag;
import promauto.jroboplc.plugin.arcsvr.ArcsvrPlugin;
import promauto.jroboplc.plugin.arcsvr.ArcvalHolder;
import promauto.jroboplc.plugin.arcsvr.CmdNolink;
import promauto.jroboplc.plugin.arcsvr.CmdPack;
import promauto.jroboplc.plugin.arcsvr.CmdSweepmes;
import promauto.jroboplc.plugin.arcsvr.MesHolder;

public class ArcsvrModule
extends AbstractModule
implements Signal.Listener {
    private final Logger logger = LoggerFactory.getLogger(ArcsvrModule.class);
    private String databaseModuleName;
    private String schema;
    private Database database;
    protected ArcvalHolder arcvalHolder = new ArcvalHolder(this);
    protected MesHolder mesHolder = new MesHolder(this);
    private boolean connected;
    private Tag tagConnected;
    private boolean errorOnInit = false;
    private boolean reloading;
    private long lastTimeCycle;
    private volatile boolean needLink;
    private volatile boolean needInit;
    private String placename;

    public ArcsvrModule(Plugin plugin, String name) {
        super(plugin, name);
        this.env.getCmdDispatcher().addCommand(this, CmdPack.class);
        this.env.getCmdDispatcher().addCommand(this, CmdSweepmes.class);
        this.env.getCmdDispatcher().addCommand(this, CmdNolink.class);
    }

    public Database getDatabase() {
        return this.database;
    }

    public String getSchema() {
        return this.schema;
    }

    public String makeTableName(String table) {
        return this.database.makeSchemaObjectName(this.schema, table);
    }

    @Override
    public final boolean loadModule(Object conf) {
        Configuration cm = this.env.getConfiguration();
        this.databaseModuleName = cm.get(conf, "database", "db");
        this.schema = cm.get(conf, "schema", "");
        this.placename = cm.get(conf, "place", this.name);
        this.tagConnected = this.tagtable.get("connected");
        if (this.tagConnected == null) {
            this.tagConnected = this.tagtable.createBool("connected", false);
        }
        boolean res = this.arcvalHolder.load(conf);
        this.reloading = false;
        return res &= this.mesHolder.load(conf);
    }

    @Override
    public final boolean prepareModule() {
        String resourceName;
        Module db = this.env.getModuleManager().getModule(this.databaseModuleName);
        if (db == null) {
            this.env.printError(this.logger, this.name, "Database module is not found:", this.databaseModuleName);
            return false;
        }
        if (!(db instanceof Database)) {
            this.env.printError(this.logger, this.name, "Not a database:", this.databaseModuleName);
            return false;
        }
        if (this.reloading) {
            return true;
        }
        this.database = (Database)db;
        this.env.getModuleManager().getModules().stream().filter(m -> m != this).forEach(m -> m.addSignalListener(this));
        if (this.arcvalHolder.isEnable() && !this.database.hasScript("arcsvr_arcval_init") && this.database.loadScriptFromResource(ArcsvrPlugin.class, resourceName = "dbscr/dbscr.arcsvr_arcval.yml") == null) {
            return false;
        }
        if (this.mesHolder.isEnable() && !this.database.hasScript("arcsvr_arcmes_init") && this.database.loadScriptFromResource(ArcsvrPlugin.class, resourceName = "dbscr/dbscr.arcsvr_arcmes.yml") == null) {
            return false;
        }
        this.needLink = true;
        this.needInit = true;
        return true;
    }

    @Override
    public void onSignal(Module sender, Signal signal) {
        if (signal.type == Signal.SignalType.RELOADED) {
            this.needLink = true;
        } else if (sender == this.database) {
            if (signal.type == Signal.SignalType.CONNECTED) {
                this.needInit = true;
            } else if (signal.type == Signal.SignalType.DISCONNECTED) {
                this.connected = false;
                this.tagConnected.setBool(false);
            }
        }
    }

    private void link() {
        this.arcvalHolder.link();
        this.mesHolder.link();
        this.needLink = false;
    }

    private void init() {
        this.errorOnInit = false;
        this.connected = false;
        this.tagConnected.setBool(false);
        if (!this.enable || this.database == null || !this.database.isConnected()) {
            return;
        }
        boolean res = true;
        res &= this.arcvalHolder.init();
        this.errorOnInit = !(res &= this.mesHolder.init());
        this.connected = res;
        this.tagConnected.setBool(this.connected);
        if (this.errorOnInit) {
            this.env.printError(this.logger, this.name, "Initialization error");
        }
        this.needInit = false;
    }

    @Override
    public boolean closedownModule() {
        if (!this.enable || this.reloading) {
            return true;
        }
        this.connected = false;
        this.tagConnected.setBool(false);
        this.env.getModuleManager().getModules().stream().forEach(m -> m.removeSignalListener(this));
        this.arcvalHolder.closedown();
        this.mesHolder.closedown();
        return true;
    }

    @Override
    public boolean executeModule() {
        long t = System.currentTimeMillis();
        if (this.needLink) {
            this.link();
        }
        if (this.needInit) {
            this.init();
        }
        if (!this.connected) {
            return true;
        }
        try {
            this.arcvalHolder.execute();
            this.mesHolder.execute();
            this.database.commit();
        }
        catch (Exception e) {
            this.env.printError(this.logger, e, this.name);
            this.database.rollback();
        }
        this.lastTimeCycle = System.currentTimeMillis() - t;
        return true;
    }

    @Override
    public String getInfo() {
        if (!this.enable) {
            return "disabled";
        }
        StringBuilder sb = new StringBuilder();
        sb.append((this.errorOnInit ? "\u001b[31m\u001b[01mERROR! \u001b[0m" : "") + this.databaseModuleName + ", " + (this.schema.isEmpty() ? "" : "schema=" + this.schema + ", ") + (this.connected ? "connected" : "NOT CONNECTED!"));
        if (this.connected) {
            sb.append(", cycle=" + this.lastTimeCycle + ":");
            sb.append(this.arcvalHolder.getInfo());
            sb.append(this.mesHolder.getInfo());
        }
        return sb.toString();
    }

    @Override
    protected boolean reload() {
        ArcsvrModule tmp = new ArcsvrModule(this.plugin, this.name);
        boolean res = tmp.load();
        tmp.reloading = true;
        tmp.closedown();
        if (res &= tmp.prepare()) {
            Object conf = this.env.getConfiguration().getModuleConf(this.plugin.getPluginName(), this.name);
            this.closedown();
            if (this.load(conf) && this.prepare()) {
                res = true;
            }
        }
        return res;
    }

    public String pack(String arcname) {
        return this.arcvalHolder.pack(arcname);
    }

    public String showNolinks() {
        String s1 = this.arcvalHolder.showNolinks();
        String s2 = this.mesHolder.showNolinks();
        String s = (s1.isEmpty() ? "" : s1 + "\r\n") + (s2.isEmpty() ? "" : s2);
        return s.isEmpty() ? "" : s;
    }

    public String getPlaceName() {
        return this.placename;
    }
}

