/*
 * Decompiled with CFR 0.152.
 */
package promauto.jroboplc.plugin.database;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import promauto.jroboplc.core.TagTable;
import promauto.jroboplc.core.api.Configuration;
import promauto.jroboplc.core.api.Environment;
import promauto.jroboplc.core.api.EnvironmentInst;
import promauto.jroboplc.core.api.Tag;
import promauto.jroboplc.core.tags.TagRW;
import promauto.jroboplc.plugin.database.DatabaseModule;

public class Tabletag {
    private final Logger logger = LoggerFactory.getLogger(Tabletag.class);
    private final DatabaseModule module;
    private Access access;
    private String table;
    private String fldId;
    private String fldValue;
    private String fldName;
    private String where;
    private Map<Integer, TagRW> tags = new HashMap<Integer, TagRW>();
    private Tag.Type tagtype = Tag.Type.INT;
    private Environment env = EnvironmentInst.get();
    private String sql;

    public Tabletag(DatabaseModule module) {
        this.module = module;
    }

    public boolean load(Object conf) {
        Configuration cm = EnvironmentInst.get().getConfiguration();
        this.table = cm.get(conf, "table", "");
        this.fldId = cm.get(conf, "field.id", "id");
        this.fldName = cm.get(conf, "field.name", this.fldId);
        this.fldValue = cm.get(conf, "field.value", "");
        this.where = cm.get(conf, "where", "");
        try {
            this.access = Access.valueOf(cm.get(conf, "access", "RW").toUpperCase());
        }
        catch (IllegalArgumentException e) {
            this.env.printError(this.logger, e, this.module.getName());
            this.access = Access.RW;
            return false;
        }
        return true;
    }

    public boolean connect(Statement st) throws SQLException {
        boolean hasChanges = false;
        this.sql = String.format("select %s, %s, %s from %s", this.fldId, this.fldName, this.fldValue, this.table);
        if (!this.where.isEmpty()) {
            this.sql = this.sql + " where " + this.where;
        }
        Set<Integer> ids = this.tags.keySet();
        try (ResultSet rs = st.executeQuery(this.sql);){
            int t = rs.getMetaData().getColumnType(3);
            Tag.Type tagtype_new = t == 5 || t == 4 ? Tag.Type.INT : (t == 6 || t == 8 ? Tag.Type.DOUBLE : Tag.Type.STRING);
            if (this.tagtype == tagtype_new) {
                HashSet<Integer> ids_new = new HashSet<Integer>();
                while (rs.next()) {
                    ids_new.add(rs.getInt(1));
                }
                ids.removeAll(ids_new);
            }
        }
        rs = st.executeQuery(this.sql);
        var5_5 = null;
        try {
            for (Integer id : ids) {
                this.module.getTagTable().remove(this.tags.get(id));
                this.tags.remove(id);
                hasChanges = true;
            }
            TagTable tt = this.module.getTagTable();
            while (rs.next()) {
                int id = rs.getInt(1);
                String name = rs.getString(2);
                String tagname = this.table + "." + this.fldValue + "." + name;
                Tag tag = tt.get(tagname);
                if (tag == null) {
                    tag = tt.createTagRW(this.tagtype, tagname);
                }
                tag.setStatus(Tag.Status.Good);
                if (!(tag instanceof TagRW)) continue;
                Tag tag1 = this.tags.get(id);
                if (tag1 != null && !tag.getName().equals(tag1.getName())) {
                    this.module.getTagTable().remove(tag1);
                    this.tags.remove(id);
                    tag1 = null;
                }
                if (tag1 != null) continue;
                this.tags.put(id, (TagRW)tag);
                hasChanges = true;
            }
        }
        catch (Throwable throwable) {
            var5_5 = throwable;
            throw throwable;
        }
        finally {
            if (rs != null) {
                if (var5_5 != null) {
                    try {
                        rs.close();
                    }
                    catch (Throwable throwable) {
                        var5_5.addSuppressed(throwable);
                    }
                } else {
                    rs.close();
                }
            }
        }
        this.sql = String.format("select %s, %s from %s", this.fldId, this.fldValue, this.table);
        if (!this.where.isEmpty()) {
            this.sql = this.sql + " where " + this.where;
        }
        return hasChanges;
    }

    public boolean execute(Statement st) throws SQLException {
        boolean needReconnect = false;
        if (this.access == Access.RW || this.access == Access.WO) {
            for (Map.Entry<Integer, TagRW> ent : this.tags.entrySet()) {
                if (!ent.getValue().hasWriteValue()) continue;
                this.writeValue(st, ent.getKey(), ent.getValue());
            }
        }
        if (this.access == Access.RW || this.access == Access.RO) {
            int n = 0;
            try (ResultSet rs = st.executeQuery(this.sql);){
                while (rs.next()) {
                    int id = rs.getInt(1);
                    TagRW tag = this.tags.get(id);
                    if (tag == null) {
                        needReconnect = true;
                    } else {
                        tag.setReadValString(rs.getString(2));
                    }
                    ++n;
                }
            }
            if (n != this.tags.size()) {
                needReconnect = true;
            }
        }
        return needReconnect;
    }

    private void writeValue(Statement st, Integer id, TagRW tag) throws SQLException {
        String wrsql = String.format("update %s set %s=%s where %s=%d", this.table, this.fldValue, this.tagtype == Tag.Type.STRING ? "'" + tag.getWriteValString() + "'" : tag.getWriteValString(), this.fldId, id);
        st.executeUpdate(wrsql);
    }

    private static enum Access {
        RW,
        RO,
        WO;

    }
}

