/*
 * Decompiled with CFR 0.152.
 */
package promauto.jroboplc.plugin.jrbustcp;

import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.socket.SocketChannel;
import io.netty.handler.codec.LengthFieldBasedFrameDecoder;
import io.netty.handler.codec.LengthFieldPrepender;
import io.netty.handler.codec.compression.ZlibCodecFactory;
import io.netty.handler.codec.compression.ZlibWrapper;
import io.netty.handler.ssl.SslContext;
import promauto.jroboplc.plugin.jrbustcp.ClientHandler;
import promauto.jroboplc.plugin.jrbustcp.JrbustcpClientModule;
import promauto.jroboplc.plugin.jrbustcp.TrafficHandler;

public class ClientInitializer
extends ChannelInitializer<SocketChannel> {
    private static final int TRAFFIC_CHECK_INTERVAL_S = 3;
    private final JrbustcpClientModule module;
    private final SslContext sslCtx;

    public ClientInitializer(JrbustcpClientModule module, SslContext sslCtx) {
        this.module = module;
        this.sslCtx = sslCtx;
    }

    public void initChannel(SocketChannel ch) {
        ChannelPipeline pipeline = ch.pipeline();
        pipeline.addFirst("traffic", (ChannelHandler)new TrafficHandler());
        if (this.sslCtx != null) {
            pipeline.addLast(new ChannelHandler[]{this.sslCtx.newHandler(ch.alloc())});
        }
        if (this.module.getCompress().equals("gzip")) {
            pipeline.addLast(new ChannelHandler[]{ZlibCodecFactory.newZlibEncoder((ZlibWrapper)ZlibWrapper.GZIP)});
            pipeline.addLast(new ChannelHandler[]{ZlibCodecFactory.newZlibDecoder((ZlibWrapper)ZlibWrapper.GZIP)});
        }
        pipeline.addLast(new ChannelHandler[]{new LengthFieldBasedFrameDecoder(16384, 0, 2, 0, 2)});
        pipeline.addLast(new ChannelHandler[]{new LengthFieldPrepender(2)});
        pipeline.addLast(new ChannelHandler[]{new ClientHandler(this.module)});
    }
}

