/*
 * Decompiled with CFR 0.152.
 */
package promauto.jroboplc.plugin.jrbustcp;

import io.netty.bootstrap.Bootstrap;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslContextBuilder;
import io.netty.handler.ssl.util.InsecureTrustManagerFactory;
import io.netty.util.ResourceLeakDetector;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.net.ssl.SSLException;
import org.apache.log4j.BasicConfigurator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import promauto.jroboplc.core.AbstractModule;
import promauto.jroboplc.core.api.Configuration;
import promauto.jroboplc.core.api.EnvironmentInst;
import promauto.jroboplc.core.api.Module;
import promauto.jroboplc.core.api.Plugin;
import promauto.jroboplc.core.api.Signal;
import promauto.jroboplc.core.api.Tag;
import promauto.jroboplc.core.tags.TagRW;
import promauto.jroboplc.plugin.jrbustcp.ClientInitializer;
import promauto.jroboplc.plugin.jrbustcp.CommandUnknownException;
import promauto.jroboplc.plugin.jrbustcp.IllegalServerAnswerException;
import promauto.jroboplc.plugin.jrbustcp.JrbustcpProtocol;
import promauto.jroboplc.plugin.jrbustcp.Message;
import promauto.jroboplc.plugin.jrbustcp.TrafficHandler;
import promauto.jroboplc.plugin.jrbustcp.UnauthenticatedException;

public class JrbustcpClientModule
extends AbstractModule {
    private final Logger logger = LoggerFactory.getLogger(JrbustcpClientModule.class);
    protected String descr;
    private String host;
    private int port;
    public int initflags;
    private boolean ssl;
    private String compress;
    protected String filter;
    private int reconTime;
    private int timeout;
    private boolean logging;
    private boolean auth;
    private String authKeyName;
    private int writeDelay;
    private int chWdtDelay;
    private boolean chWdtEnable;
    private Tag tagConnected;
    private Tag tagReconnectCnt;
    private Tag tagDisconnectCnt;
    private Tag tagLastError;
    private Tag tagChWdtAlarm;
    protected TagRW[] tags = new TagRW[0];
    private List<Integer> writeCache = new ArrayList<Integer>();
    private Map<String, String> alarmValues = new HashMap<String, String>();
    private boolean modeSetHidden;
    private long cooldownTime = 0L;
    private long connectTime = 0L;
    private long chWdtDisconnectTime = 0L;
    private JrbustcpProtocol prot = new JrbustcpProtocol();
    private Bootstrap bootstrap;
    private EventLoopGroup workerGroup = null;
    protected Channel channel = null;
    protected ByteBuf outbuf = null;
    protected ByteBuf inbuf = null;
    private int reqid;
    private int inboundValues;
    private int outboundValues;
    final BlockingQueue<ByteBuf> answer = new LinkedBlockingQueue<ByteBuf>(10);

    public JrbustcpClientModule(Plugin plugin, String name) {
        super(plugin, name);
    }

    @Override
    public boolean canHaveExternalTags() {
        return true;
    }

    @Override
    protected boolean loadModule(Object conf) {
        Configuration cm = this.env.getConfiguration();
        this.port = cm.get(conf, "port", 0);
        this.host = cm.get(conf, "host", "localhost");
        this.descr = cm.get(conf, "descr", this.name);
        this.ssl = cm.get(conf, "ssl", false);
        this.compress = cm.get(conf, "compress", "");
        this.filter = cm.get(conf, "filter", ".*");
        this.reconTime = cm.get(conf, "recon_s", 5) * 1000;
        this.timeout = cm.get(conf, "timeout_ms", 3000);
        this.logging = cm.get(conf, "logging", false);
        this.auth = cm.get(conf, "auth", false);
        this.authKeyName = cm.get(conf, "authKey", "");
        if (this.auth && this.authKeyName.isEmpty()) {
            this.authKeyName = this.env.getKeyManager().getDefaultPrivateKeyName();
            if (this.authKeyName.isEmpty()) {
                this.auth = false;
                this.env.printError(this.logger, this.name, "No default private key found. Authentication disabled!");
            }
        }
        this.writeDelay = cm.get(conf, "writeDelay_s", 0) * 1000;
        this.chWdtDelay = cm.get(conf, "chWdtDelay_s", 0) * 1000;
        this.chWdtEnable = cm.get(conf, "chWdtEnable", false);
        this.initflags = (cm.get(conf, "tagdescr", false) ? 1 : 0) * 1;
        this.initflags += 2;
        this.initflags += (cm.get(conf, "excludeExternal", false) ? 1 : 0) * 4;
        this.initflags += (cm.get(conf, "includeHidden", false) ? 1 : 0) * 8;
        this.modeSetHidden = cm.get(conf, "setHidden", false);
        this.alarmValues.clear();
        for (Object obj : cm.toList(cm.get(conf, "alarm.values"))) {
            this.alarmValues.put(cm.get(obj, "tag", ""), cm.get(obj, "value", ""));
        }
        this.createSystemTags();
        return true;
    }

    protected void createSystemTags() {
        this.tagConnected = this.tagtable.createBool("client.connected", false);
        this.tagReconnectCnt = this.tagtable.createInt("client.reconnect.cnt", 0);
        this.tagDisconnectCnt = this.tagtable.createInt("client.disconnect.cnt", 0);
        this.tagLastError = this.tagtable.createString("client.last.error", "");
        if (this.chWdtEnable) {
            this.tagChWdtAlarm = this.tagtable.createBool("client.chwdt.alarm", false);
        }
    }

    public String getCompress() {
        return this.compress;
    }

    void setAuth(boolean auth) {
        this.auth = auth;
    }

    void setAuthKeyName(String authKeyName) {
        this.authKeyName = authKeyName;
    }

    @Override
    public String getInfo() {
        TrafficHandler th;
        long counterRead = 0L;
        long counterWritten = 0L;
        if (this.channel != null && (th = (TrafficHandler)this.channel.pipeline().get("traffic")) != null) {
            counterRead = th.getCounterRead();
            counterWritten = th.getCounterWritten();
        }
        return !this.enable ? "disabled" : String.format("%s%s:%d %s %s%s%s, tags=%d, %s%d/%d B/s%s, values rd/wr=%d/%d", !this.tagConnected.getBool() ? "\u001b[31m\u001b[01mERROR! \u001b[0m" : "", this.host, this.port, this.descr, this.filter, this.ssl ? " SSL" : "", this.auth ? " AUTH" : "", this.tags == null ? 0 : this.tags.length, "\u001b[32m", counterRead, counterWritten, "\u001b[0m", this.inboundValues, this.outboundValues);
    }

    @Override
    protected boolean prepareModule() {
        if (this.logging) {
            BasicConfigurator.configure();
            ResourceLeakDetector.setLevel((ResourceLeakDetector.Level)ResourceLeakDetector.Level.PARANOID);
        }
        this.reqid = ThreadLocalRandom.current().nextInt();
        this.tagReconnectCnt.setInt(-1);
        this.tagDisconnectCnt.setInt(0);
        if (this.workerGroup == null) {
            this.workerGroup = new NioEventLoopGroup(1);
        }
        if (this.bootstrap == null) {
            SslContext sslCtx = null;
            if (this.ssl) {
                try {
                    sslCtx = SslContextBuilder.forClient().trustManager(InsecureTrustManagerFactory.INSTANCE).build();
                }
                catch (SSLException e) {
                    this.env.printError(this.logger, e, this.name);
                    return false;
                }
            }
            this.bootstrap = new Bootstrap();
            this.bootstrap.group(this.workerGroup);
            this.bootstrap.channel(NioSocketChannel.class);
            this.bootstrap.option(ChannelOption.SO_KEEPALIVE, (Object)true);
            this.bootstrap.handler((ChannelHandler)new ClientInitializer(this, sslCtx));
        }
        this.connect();
        if (!this.isConnected()) {
            this.env.printInfo(this.logger, this.name, "No connection");
        }
        return true;
    }

    @Override
    protected boolean closedownModule() {
        this.disconnect();
        try {
            if (this.workerGroup != null) {
                this.workerGroup.shutdownGracefully().sync();
            }
        }
        catch (InterruptedException e) {
            this.env.printError(this.logger, e, this.name);
        }
        this.workerGroup = null;
        this.bootstrap = null;
        return true;
    }

    private void connect() {
        this.disconnect();
        this.tagReconnectCnt.setInt(this.tagReconnectCnt.getInt() + 1);
        try {
            this.channel = this.bootstrap.connect(this.host, this.port).sync().channel();
        }
        catch (Exception e) {
            this.setLastError(e);
        }
        if (this.isConnected() && this.authenticate() && this.initList() && this.doRead()) {
            for (TagRW tag : this.tags) {
                tag.hasWriteValue();
            }
            this.tagConnected.setBool(true);
            if (this.tagReconnectCnt.getInt() > 0) {
                this.env.printInfo(this.logger, this.name, "Connection restored");
            }
            this.resetCooldown();
            this.connectTime = System.currentTimeMillis();
        } else {
            this.disconnect();
            this.setupCooldown();
        }
    }

    private void setLastError(Exception e) {
        this.tagLastError.setString(LocalDateTime.now().toString() + ": " + e.getMessage());
    }

    private void disconnect() {
        if (this.channel == null) {
            return;
        }
        for (TagRW tag : this.tags) {
            tag.setStatus(Tag.Status.Bad);
        }
        try {
            if (this.outbuf != null) {
                this.outbuf.release();
                this.outbuf = null;
            }
            this.channel.close().sync();
        }
        catch (Exception e) {
            this.env.printError(this.logger, e, this.name);
        }
        this.channel = null;
        this.tagConnected.setBool(false);
    }

    @Override
    protected boolean executeModule() {
        if (this.cooldownTime > 0L) {
            if (this.isCooldownOver()) {
                this.resetCooldown();
                this.connect();
            } else {
                this.executeChWdt();
            }
        } else {
            try {
                if (this.isConnected() && this.doWrite() && this.doRead()) {
                    boolean bl = true;
                    return bl;
                }
            }
            catch (Exception e) {
                this.env.printError(this.logger, e, this.name);
            }
            finally {
                this.releaseInbuf();
            }
            this.disconnect();
            this.applyAlarmValues();
            this.setupCooldown();
            this.chWdtDisconnectTime = System.currentTimeMillis();
            this.tagDisconnectCnt.setInt(this.tagDisconnectCnt.getInt() + 1);
            this.env.printInfo(this.logger, this.name, "Connection lost, cnt: " + this.tagDisconnectCnt.getInt());
        }
        return true;
    }

    private boolean isCooldownOver() {
        return this.cooldownTime < System.currentTimeMillis();
    }

    private void setupCooldown() {
        this.cooldownTime = System.currentTimeMillis() + (long)this.reconTime;
    }

    private void resetCooldown() {
        this.cooldownTime = 0L;
    }

    protected boolean isConnected() {
        return this.channel != null && this.channel.isActive();
    }

    private void applyAlarmValues() {
        for (String tagexpr : this.alarmValues.keySet()) {
            Pattern p = Pattern.compile(tagexpr);
            String value = this.alarmValues.get(tagexpr);
            for (TagRW tag : this.tags) {
                if (!p.matcher(tag.getName()).matches()) continue;
                tag.setReadValString(value);
            }
        }
    }

    private Message readMessage(int cmd) throws Exception {
        Message msg;
        do {
            this.releaseInbuf();
            this.inbuf = this.answer.poll(this.timeout, TimeUnit.MILLISECONDS);
            if (this.logging && this.inbuf != null) {
                this.env.logInfo(this.logger, "Client got answer:\r\n" + ByteBufUtil.prettyHexDump((ByteBuf)this.inbuf) + "\r\n");
            }
            if (this.inbuf == null) {
                throw new TimeoutException();
            }
            msg = this.prot.getMessage(this.inbuf);
        } while (msg.reqId != this.reqid);
        if (msg.cmd != (cmd | 0x80)) {
            switch (msg.cmd) {
                case 255: {
                    throw new CommandUnknownException("Unknown command: " + cmd);
                }
                case 254: {
                    this.env.printError(this.logger, this.name, "Server required authentication!");
                    throw new UnauthenticatedException("Unauthenticated command: " + cmd);
                }
            }
            throw new IllegalServerAnswerException("Illegal server answer: " + msg.cmd + ", while command: " + cmd);
        }
        return msg;
    }

    private void releaseInbuf() {
        if (this.inbuf != null) {
            this.inbuf.release();
            this.inbuf = null;
        }
    }

    private void createOutbuf() {
        if (this.outbuf == null) {
            this.outbuf = this.channel.alloc().buffer();
        }
    }

    private void writeAndFlash() {
        if (this.logging) {
            this.env.logInfo(this.logger, "Client send request:\r\n" + ByteBufUtil.prettyHexDump((ByteBuf)this.outbuf) + "\r\n");
        }
        this.channel.writeAndFlush((Object)this.outbuf);
        this.outbuf = null;
    }

    private int getNextReqId() {
        return ++this.reqid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean authenticate() {
        if (!this.auth) {
            return true;
        }
        try {
            Message msg = this.sendCmdAuthInit();
            short statusInit = msg.body.readUnsignedByte();
            if (statusInit == 1) {
                String failDescr = this.prot.readString(msg.body);
                this.env.printError(this.logger, this.name, "Authentication failed: " + failDescr);
                boolean bl = false;
                return bl;
            }
            if (statusInit == 0) {
                String encryptedNonce = this.prot.readString(msg.body);
                String nonce = this.env.getKeyManager().decryptPrivate(this.authKeyName, encryptedNonce);
                msg = this.sendCmdAuthSubmit(nonce);
                short statusSubmit = msg.body.readUnsignedByte();
                if (statusSubmit != 0) {
                    this.env.printError(this.logger, this.name, "Authentication rejected!");
                    boolean bl = false;
                    return bl;
                }
            }
        }
        catch (CommandUnknownException e) {
            this.env.printInfo(this.logger, this.name, "Server doesn't support authentication. Server is insecure!");
            this.setLastError(e);
        }
        catch (Exception e) {
            this.env.logError(this.logger, e, this.name, "authenticate error");
            this.setLastError(e);
            boolean bl = false;
            return bl;
        }
        finally {
            this.releaseInbuf();
        }
        return true;
    }

    private Message sendCmdAuthInit() throws Exception {
        return this.sendString(7, this.authKeyName);
    }

    private Message sendCmdAuthSubmit(String nonce) throws Exception {
        return this.sendString(8, nonce);
    }

    private Message sendString(int cmd, String data) throws Exception {
        this.createOutbuf();
        this.prot.writeHeader(this.outbuf, this.getNextReqId(), cmd);
        this.prot.writeString(this.outbuf, data);
        this.prot.writeFooter(this.outbuf);
        this.writeAndFlash();
        return this.readMessage(cmd);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean initList() {
        TagRW[] newtags = null;
        try {
            Message msg = this.sendCmdInit();
            int size = msg.body.readUnsignedMedium();
            newtags = new TagRW[size];
            int next = 0;
            do {
                msg = this.sendCmdList(next);
                int index = msg.body.readUnsignedMedium();
                int qnt = msg.body.readUnsignedMedium();
                next = msg.body.readUnsignedMedium();
                for (int i = 0; i < qnt; ++i) {
                    Tag.Type type = this.prot.convertByteToTagType(msg.body.readUnsignedByte());
                    short len = msg.body.readUnsignedByte();
                    String tagname = msg.body.readCharSequence((int)len, JrbustcpProtocol.charset).toString();
                    len = msg.body.readUnsignedByte();
                    String tagdescr = msg.body.readCharSequence((int)len, JrbustcpProtocol.charset).toString();
                    if (index < 0 || index >= size) {
                        throw new IndexOutOfBoundsException();
                    }
                    newtags[index] = TagRW.create(type, tagname, 12 + (this.modeSetHidden ? 2 : 0));
                    newtags[index].setStatus(Tag.Status.Uninitiated);
                    ++index;
                }
            } while (next > 0);
        }
        catch (Exception e) {
            this.env.logError(this.logger, e, this.name, "initList error");
            this.setLastError(e);
            boolean size = false;
            return size;
        }
        finally {
            this.releaseInbuf();
        }
        boolean hasChanges = false;
        Map<String, Tag> newmap = Arrays.stream(newtags).collect(Collectors.toMap(Tag::getName, tag -> tag, (a1, a2) -> a1));
        for (TagRW oldtag : this.tags) {
            Tag newtag = newmap.get(oldtag.getName());
            if (newtag != null && newtag.getType() == oldtag.getType()) continue;
            this.tagtable.remove(oldtag);
            hasChanges = true;
        }
        for (int i = 0; i < newtags.length; ++i) {
            Tag oldtag = this.tagtable.get(newtags[i].getName());
            if (oldtag == null) {
                this.tagtable.add(newtags[i]);
                hasChanges = true;
            } else {
                newtags[i] = (TagRW)oldtag;
            }
            newtags[i].setStatus(Tag.Status.Good);
        }
        if (hasChanges) {
            this.tags = newtags;
            this.postSignal(Signal.SignalType.RELOADED);
        }
        return true;
    }

    private Message sendCmdInit() throws Exception {
        this.createOutbuf();
        this.prot.writeHeader(this.outbuf, this.getNextReqId(), 1);
        this.prot.writeShortString(this.outbuf, this.filter);
        this.prot.writeShortString(this.outbuf, this.descr);
        this.outbuf.writeShort(this.initflags);
        this.prot.writeFooter(this.outbuf);
        this.writeAndFlash();
        return this.readMessage(1);
    }

    private Message sendCmdList(int index) throws Exception {
        this.createOutbuf();
        this.prot.writeHeader(this.outbuf, this.getNextReqId(), 2);
        this.outbuf.writeMedium(index);
        this.prot.writeFooter(this.outbuf);
        this.writeAndFlash();
        return this.readMessage(2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean doWrite() {
        int i;
        if (this.writeDelay > 0 && this.connectTime > 0L) {
            long time = System.currentTimeMillis() - this.connectTime;
            if (time < 0L || time > (long)this.writeDelay) {
                this.connectTime = 0L;
            } else {
                return true;
            }
        }
        int qnt = 0;
        for (i = 0; i < this.tags.length; ++i) {
            if (!this.tags[i].hasWriteValue()) continue;
            if (qnt < this.writeCache.size()) {
                this.writeCache.set(qnt, i);
            } else {
                this.writeCache.add(i);
            }
            ++qnt;
        }
        this.outboundValues = qnt;
        if (qnt == 0) {
            return true;
        }
        try {
            i = 0;
            while (i < qnt) {
                int curindex = this.writeCache.get(i);
                this.createOutbuf();
                this.prot.writeHeader(this.outbuf, this.getNextReqId(), 5);
                this.outbuf.writeMedium(curindex);
                int qntPos = this.outbuf.writerIndex();
                this.outbuf.writeMedium(0);
                int n = 0;
                while (i < qnt && this.prot.canWrite(this.outbuf)) {
                    boolean gap;
                    int index = this.writeCache.get(i);
                    boolean bl = gap = curindex != index;
                    if (gap) {
                        this.prot.writeIndex(this.outbuf, index);
                        curindex = index;
                    }
                    this.prot.writeValue(this.outbuf, this.tags[curindex]);
                    ++i;
                    ++n;
                    ++curindex;
                }
                this.outbuf.setMedium(qntPos, n);
                this.prot.writeFooter(this.outbuf);
                this.writeAndFlash();
                this.readMessage(5);
            }
        }
        catch (Exception e) {
            this.env.logError(this.logger, e, this.name, "write error");
            this.setLastError(e);
            boolean bl = false;
            return bl;
        }
        finally {
            this.releaseInbuf();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean doRead() {
        try {
            Message msg = this.sendCmdUpdate();
            int qnt = msg.body.readUnsignedMedium();
            int next = msg.body.readUnsignedMedium();
            short liststate = msg.body.readUnsignedByte();
            if (liststate == 255) {
                this.env.printInfo(this.logger, this.name, "Server signal: reinitialize");
                boolean bl = this.initList();
                return bl;
            }
            this.inboundValues = qnt;
            if (qnt == 0) {
                boolean bl = true;
                return bl;
            }
            do {
                msg = this.sendCmdRead(next);
                int index = msg.body.readUnsignedMedium();
                qnt = msg.body.readUnsignedMedium();
                next = msg.body.readUnsignedMedium();
                int i = 0;
                while (i < qnt) {
                    if ((index = this.prot.readIndex(msg.body, index)) < 0 || index >= this.tags.length) {
                        throw new IndexOutOfBoundsException();
                    }
                    this.prot.readValueAndStatus(msg.body, this.tags[index]);
                    ++i;
                    ++index;
                }
            } while (next > 0);
        }
        catch (Exception e) {
            this.env.logError(this.logger, e, this.name, "read error");
            this.setLastError(e);
            boolean bl = false;
            return bl;
        }
        finally {
            this.releaseInbuf();
        }
        return true;
    }

    private Message sendCmdUpdate() throws Exception {
        this.createOutbuf();
        this.prot.writeHeader(this.outbuf, this.getNextReqId(), 3);
        this.prot.writeFooter(this.outbuf);
        this.writeAndFlash();
        return this.readMessage(3);
    }

    private Message sendCmdRead(int index) throws Exception {
        this.createOutbuf();
        this.prot.writeHeader(this.outbuf, this.getNextReqId(), 4);
        this.outbuf.writeMedium(index);
        this.prot.writeFooter(this.outbuf);
        this.writeAndFlash();
        return this.readMessage(4);
    }

    private void executeChWdt() {
        if (!this.chWdtEnable || this.chWdtDisconnectTime <= 0L) {
            return;
        }
        this.tagChWdtAlarm.setInt(1);
        long time = System.currentTimeMillis() - this.chWdtDisconnectTime;
        if (time >= 0L && time <= (long)this.chWdtDelay) {
            return;
        }
        this.chWdtDisconnectTime = 0L;
        Set<Module> modules = EnvironmentInst.get().getModuleManager().getModules();
        for (TagRW tag : this.tags) {
            Optional<Module> foundModule;
            String value = tag.getString();
            if (tag.getType() != Tag.Type.STRING || !(foundModule = modules.stream().filter(m -> value.startsWith(m.getName() + '.')).findFirst()).isPresent()) continue;
            String tagname = value.substring(foundModule.get().getName().length() + 1);
            Tag foundTag = foundModule.get().getTagTable().get(tagname);
            if (foundTag == null) continue;
            foundTag.setInt(0);
            System.out.println("chwdt: " + value);
        }
        this.tagChWdtAlarm.setInt(0);
    }

    @Override
    protected boolean reload() {
        JrbustcpClientModule tmp = new JrbustcpClientModule(this.plugin, this.name);
        if (!tmp.load()) {
            return false;
        }
        this.closedownModule();
        this.copySettingsFrom(tmp);
        this.descr = tmp.descr;
        this.host = tmp.host;
        this.port = tmp.port;
        this.initflags = tmp.initflags;
        this.ssl = tmp.ssl;
        this.compress = tmp.compress;
        this.filter = tmp.filter;
        this.reconTime = tmp.reconTime;
        this.timeout = tmp.timeout;
        this.logging = tmp.logging;
        this.auth = tmp.auth;
        this.authKeyName = tmp.authKeyName;
        this.writeDelay = tmp.writeDelay;
        this.chWdtDelay = tmp.chWdtDelay;
        this.chWdtEnable = tmp.chWdtEnable;
        if (this.tagChWdtAlarm == null && tmp.tagChWdtAlarm != null) {
            this.tagChWdtAlarm = tmp.tagChWdtAlarm;
            this.getTagTable().add(this.tagChWdtAlarm);
        }
        if (this.enable && this.env.isRunning()) {
            this.prepareModule();
        }
        return true;
    }
}

