/*
 * Decompiled with CFR 0.152.
 */
package promauto.jroboplc.plugin.jrbustcp;

import io.netty.buffer.ByteBuf;
import java.nio.charset.Charset;
import java.util.zip.CRC32;
import promauto.jroboplc.core.api.Tag;
import promauto.jroboplc.core.tags.TagRW;
import promauto.jroboplc.plugin.jrbustcp.Message;

public class JrbustcpProtocol {
    public static final Charset charset = Charset.forName("UTF-8");
    public static final int FRAME_SIZE_MAX = 16384;
    private static final int WRITE_UPPER_BOUND = 8192;
    public static final int STR_LEN_MAX = 4096;
    private static final int MAGIC_HEADER = 43981;
    static final int CMD_INIT = 1;
    static final int CMD_LIST = 2;
    static final int CMD_UPDATE = 3;
    static final int CMD_READ = 4;
    static final int CMD_WRITE = 5;
    static final int CMD_CRC = 6;
    static final int CMD_AUTH_INIT = 7;
    static final int CMD_AUTH_SUBMIT = 8;
    static final int ERROR_UNUATHENTICATED = 254;
    static final int ERROR_CMD_UNKNOWN = 255;
    static final int AUTH_INIT_OK = 0;
    static final int AUTH_INIT_FAILED = 1;
    static final int AUTH_INIT_DISABLED = 2;
    static final int AUTH_SUBMIT_ACCEPTED = 0;
    static final int AUTH_SUBMIT_DENIED = 255;
    static final int INITPRM_TAGDESCR = 1;
    static final int INITPRM_TAGSTATUS = 2;
    static final int INITPRM_EXCLUDE_EXTERNAL = 4;
    static final int INITPRM_INCLUDE_HIDDEN = 8;
    private static final int TYPE_BOOL = 1;
    private static final int TYPE_INT = 2;
    private static final int TYPE_LONG = 3;
    private static final int TYPE_DOUBLE = 4;
    private static final int TYPE_STRING = 5;
    private static final int FLAGS_ALL = 255;
    private static final int FLAGS_STATUS = 16;
    private static final int VAL_ZERO = 240;
    private static final int VAL_ONE = 241;
    private static final int VAL_BYTE = 242;
    private static final int VAL_WORD = 243;
    private static final int VAL_INT = 248;
    private static final int VAL_LONG = 249;
    private static final int VAL_DOUBLE = 250;
    private static final int VAL_STRING = 251;
    private static final int VAL_INDEX_SHORT = 254;
    private static final int VAL_INDEX_MEDIUM = 255;
    private boolean useTagStatus = false;
    private CRC32 crc = new CRC32();

    public boolean isUseTagStatus() {
        return this.useTagStatus;
    }

    public void setUseTagStatus(boolean useTagStatus) {
        this.useTagStatus = useTagStatus;
    }

    public Message getMessage(ByteBuf buf) {
        if (buf.readableBytes() < 9) {
            return null;
        }
        int header = buf.getUnsignedShort(0);
        long crc1 = buf.getUnsignedInt(buf.readableBytes() - 4);
        long crc2 = this.calcCrc(buf, 2, buf.readableBytes() - 4);
        if (header != 43981 || crc1 != crc2) {
            return null;
        }
        int reqid = buf.getInt(2);
        short cmd = buf.getUnsignedByte(6);
        buf = buf.slice(7, buf.readableBytes() - 9);
        return new Message(cmd, reqid, buf.readableBytes(), buf);
    }

    private long calcCrc(ByteBuf buf, int begin, int len) {
        this.crc.reset();
        for (int i = begin; i < len; ++i) {
            this.crc.update(buf.getUnsignedByte(i));
        }
        return this.crc.getValue();
    }

    public void writeHeader(ByteBuf buf, int reqId, int cmd) {
        buf.clear();
        buf.writeShort(43981);
        buf.writeInt(reqId);
        buf.writeByte(cmd);
    }

    public void writeFooter(ByteBuf buf) {
        long crc2 = this.calcCrc(buf, 2, buf.writerIndex());
        buf.writeInt((int)crc2);
    }

    public int convertTagTypeToByte(Tag tag) {
        switch (tag.getType()) {
            case BOOL: {
                return 1;
            }
            case INT: {
                return 2;
            }
            case LONG: {
                return 3;
            }
            case DOUBLE: {
                return 4;
            }
            case STRING: {
                return 5;
            }
        }
        return 0;
    }

    public Tag.Type convertByteToTagType(int value) {
        switch (value) {
            case 1: {
                return Tag.Type.BOOL;
            }
            case 2: {
                return Tag.Type.INT;
            }
            case 3: {
                return Tag.Type.LONG;
            }
            case 4: {
                return Tag.Type.DOUBLE;
            }
            case 5: {
                return Tag.Type.STRING;
            }
        }
        throw new IllegalArgumentException("Unknown tag type value: " + value);
    }

    public int readIndex(ByteBuf buf, int index) {
        short valcode = buf.getUnsignedByte(buf.readerIndex());
        switch (valcode) {
            case 254: {
                buf.skipBytes(1);
                index = buf.readUnsignedShort();
                break;
            }
            case 255: {
                buf.skipBytes(1);
                index = buf.readUnsignedMedium();
            }
        }
        return index;
    }

    public void writeIndex(ByteBuf buf, int index) {
        if (index < 65536) {
            buf.writeByte(254);
            buf.writeShort(index);
        } else {
            buf.writeByte(255);
            buf.writeMedium(index);
        }
    }

    public void readValue(ByteBuf buf, Tag tag) {
        int valcode = buf.readUnsignedByte();
        switch (valcode |= 0x10) {
            case 240: {
                tag.setInt(0);
                break;
            }
            case 241: {
                tag.setInt(1);
                break;
            }
            case 242: {
                tag.setInt(buf.readUnsignedByte());
                break;
            }
            case 243: {
                tag.setInt(buf.readUnsignedShort());
                break;
            }
            case 248: {
                tag.setInt(buf.readInt());
                break;
            }
            case 249: {
                tag.setLong(buf.readLong());
                break;
            }
            case 250: {
                tag.setDouble(buf.readDouble());
                break;
            }
            case 251: {
                tag.setString(buf.readCharSequence(buf.readUnsignedShort(), charset).toString());
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown value code: " + valcode);
            }
        }
    }

    public void readValueAndStatus(ByteBuf buf, TagRW tag) {
        int valcode = buf.readUnsignedByte();
        Tag.Status status = Tag.Status.Good;
        if ((valcode & 0x10) == 0) {
            valcode |= 0x10;
            status = Tag.Status.Bad;
        }
        switch (valcode) {
            case 240: {
                tag.setReadValInt(0);
                break;
            }
            case 241: {
                tag.setReadValInt(1);
                break;
            }
            case 242: {
                tag.setReadValInt(buf.readUnsignedByte());
                break;
            }
            case 243: {
                tag.setReadValInt(buf.readUnsignedShort());
                break;
            }
            case 248: {
                tag.setReadValInt(buf.readInt());
                break;
            }
            case 249: {
                tag.setReadValLong(buf.readLong());
                break;
            }
            case 250: {
                tag.setReadValDouble(buf.readDouble());
                break;
            }
            case 251: {
                tag.setReadValString(buf.readCharSequence(buf.readUnsignedShort(), charset).toString());
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown value code: " + valcode);
            }
        }
        tag.setStatus(status);
    }

    public void writeValueAndStatus(ByteBuf buf, Tag tag) {
        int flags = 255;
        if (this.useTagStatus && tag.getStatus() != Tag.Status.Good) {
            flags ^= 0x10;
        }
        switch (tag.getType()) {
            case BOOL: {
                this.writeValueBool(buf, tag.getBool(), flags);
                break;
            }
            case INT: {
                this.writeValueInt(buf, tag.getInt(), flags);
                break;
            }
            case LONG: {
                this.writeValueLong(buf, tag.getLong(), flags);
                break;
            }
            case DOUBLE: {
                this.writeValueDouble(buf, tag.getDouble(), flags);
                break;
            }
            case STRING: {
                this.writeValueString(buf, tag.getString(), flags);
            }
        }
    }

    public void writeValue(ByteBuf buf, TagRW tag) {
        switch (tag.getType()) {
            case BOOL: {
                this.writeValueBool(buf, tag.getWriteValBool(), 255);
                break;
            }
            case INT: {
                this.writeValueInt(buf, tag.getWriteValInt(), 255);
                break;
            }
            case LONG: {
                this.writeValueLong(buf, tag.getWriteValLong(), 255);
                break;
            }
            case DOUBLE: {
                this.writeValueDouble(buf, tag.getWriteValDouble(), 255);
                break;
            }
            case STRING: {
                this.writeValueString(buf, tag.getWriteValString(), 255);
            }
        }
    }

    private void writeValueBool(ByteBuf buf, boolean value, int flags) {
        buf.writeByte(flags & (value ? 241 : 240));
    }

    private void writeValueInt(ByteBuf buf, int value, int flags) {
        if (this.writeValueShortFormInt(buf, value, flags)) {
            return;
        }
        buf.writeByte(flags & 0xF8);
        buf.writeInt(value);
    }

    private void writeValueLong(ByteBuf buf, long value, int flags) {
        if (value >= 0L && value < 65536L && this.writeValueShortFormInt(buf, (int)value, flags)) {
            return;
        }
        buf.writeByte(flags & 0xF9);
        buf.writeLong(value);
    }

    private boolean writeValueShortFormInt(ByteBuf buf, int value, int flags) {
        if (value == 0) {
            buf.writeByte(flags & 0xF0);
            return true;
        }
        if (value > 0) {
            if (value == 1) {
                buf.writeByte(flags & 0xF1);
                return true;
            }
            if (value < 256) {
                buf.writeByte(flags & 0xF2);
                buf.writeByte(value);
                return true;
            }
            if (value < 65536) {
                buf.writeByte(flags & 0xF3);
                buf.writeShort(value);
                return true;
            }
        }
        return false;
    }

    private void writeValueDouble(ByteBuf buf, double value, int flags) {
        buf.writeByte(flags & 0xFA);
        buf.writeDouble(value);
    }

    private void writeValueString(ByteBuf buf, String value, int flags) {
        buf.writeByte(flags & 0xFB);
        this.writeString(buf, value);
    }

    public String readShortString(ByteBuf buf) {
        short len = buf.readUnsignedByte();
        return buf.readCharSequence((int)len, charset).toString();
    }

    public String readString(ByteBuf buf) {
        int len = buf.readUnsignedShort();
        return buf.readCharSequence(len, charset).toString();
    }

    public void writeShortString(ByteBuf buf, String value) {
        int posLen = buf.writerIndex();
        buf.writeByte(0);
        buf.writeCharSequence((CharSequence)value, charset);
        int len = buf.writerIndex() - posLen - 1;
        if (len < 256) {
            buf.setByte(posLen, len);
        } else {
            len = 254;
            buf.setByte(posLen, len);
            buf.writerIndex(posLen + 1 + len);
        }
    }

    public void writeString(ByteBuf buf, String value) {
        int posLen = buf.writerIndex();
        buf.writeShort(0);
        buf.writeCharSequence((CharSequence)value, charset);
        int len = buf.writerIndex() - posLen - 2;
        if (len < 4096) {
            buf.setShort(posLen, len);
        } else {
            len = 4096;
            buf.setShort(posLen, len);
            buf.writerIndex(posLen + 2 + len);
        }
    }

    boolean canWrite(ByteBuf buf) {
        return buf.writerIndex() < 8192;
    }
}

