/*
 * Decompiled with CFR 0.152.
 */
package promauto.jroboplc.plugin.motohr;

import java.sql.SQLException;
import promauto.jroboplc.core.exceptions.ConfigurationNotValidException;
import promauto.jroboplc.core.tags.TagRW;
import promauto.jroboplc.plugin.motohr.Context;

public class CounterType {
    public static final String TOTAL_NAME = "total";
    public static final String TOTAL_DESCR = "\u0412\u0441\u0435\u0433\u043e";
    private int id;
    private final Context ctx;
    public final String name;
    public final String descr;
    public final boolean timer;
    public final TagRW tagDescr;
    public final TagRW tagTimer;

    public static CounterType createCounterTypeTotal(Context ctx) {
        return new CounterType(ctx, TOTAL_NAME, TOTAL_DESCR, false);
    }

    public CounterType(Context ctx, String name, String descr, boolean timer) {
        this.ctx = ctx;
        this.name = name;
        this.descr = descr;
        this.timer = timer;
        this.tagDescr = ctx.tagtable.createRWString("cnttype." + name + ".descr", descr);
        this.tagTimer = ctx.tagtable.createRWBool("cnttype." + name + ".timer", timer);
    }

    public CounterType(Context ctx, Object conf) throws ConfigurationNotValidException {
        this(ctx, ctx.cfg.get(conf, "name", ""), ctx.cfg.get(conf, "descr", ""), ctx.cfg.get(conf, "timer", false));
        if (this.name.isEmpty() || this.descr.isEmpty()) {
            ctx.cfg.throwConfigurationNotValidException("CounterType", conf);
        }
    }

    public static void initAll(Context ctx) throws SQLException {
        for (CounterType ct : ctx.counterTypes.values()) {
            ct.init();
        }
    }

    public int getId() {
        return this.id;
    }

    public void init() throws SQLException {
        this.id = this.ctx.service.syncCounterType(this.name, this.descr, this.timer);
    }
}

