/*
 * Decompiled with CFR 0.152.
 */
package promauto.jroboplc.plugin.motohr;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import promauto.jroboplc.core.api.Database;
import promauto.jroboplc.plugin.motohr.DataServiceBase;

public class DataServiceBaseImpl
implements DataServiceBase {
    protected Database db;
    protected Statement st;
    protected String sql;
    protected final Map<Integer, HashSet<Integer>> sync = new HashMap<Integer, HashSet<Integer>>();

    @Override
    public void setDb(Database db) {
        this.db = db;
    }

    @Override
    public Database getDb() {
        return this.db;
    }

    @Override
    public Statement createStatement() throws SQLException {
        if (this.db == null) {
            throw new RuntimeException("Database is not set!");
        }
        this.st = this.db.getConnection().createStatement();
        return this.st;
    }

    @Override
    public void commit() throws SQLException {
        if (this.st != null) {
            this.st.close();
        }
        this.st = null;
        if (this.db != null) {
            this.db.commit();
        }
    }

    @Override
    public void rollback() {
        try {
            if (this.st != null) {
                this.st.close();
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        this.st = null;
        if (this.db != null) {
            this.db.rollback();
        }
    }

    protected void delete(String table, String field, int id) throws SQLException {
        this.sql = String.format("delete from %s where %s=%d", table, field, id);
        this.st.executeUpdate(this.sql);
    }

    @Override
    public String getLastSql() {
        return this.sql;
    }

    protected int executeAndGetId(String sql) throws SQLException {
        this.sql = sql;
        this.st.executeUpdate(sql, new String[]{"id"});
        try (ResultSet keys = this.st.getGeneratedKeys();){
            if (keys.next()) {
                int n = keys.getInt(1);
                return n;
            }
        }
        return 0;
    }

    protected void startSyncTable(Integer syncType, String table) throws SQLException {
        HashSet<Integer> hs = new HashSet<Integer>();
        this.sync.put(syncType, hs);
        this.sql = String.format("select id from %s", table);
        if (this.db.hasColumn(this.st, "", table, "deleted")) {
            this.sql = this.sql + " where deleted=0";
        }
        try (ResultSet rs = this.st.executeQuery(this.sql);){
            while (rs.next()) {
                hs.add(rs.getInt(1));
            }
        }
    }

    protected void removeSyncId(Integer syncType, int id) {
        assert (this.sync.get(syncType) != null);
        this.sync.get(syncType).remove(id);
    }

    protected void finishSyncTable(Integer syncType, String table) throws SQLException {
        assert (this.sync.get(syncType) != null);
        boolean hasDeletedField = this.db.hasColumn(this.st, "", table, "deleted");
        for (Integer id : this.sync.get(syncType)) {
            this.sql = hasDeletedField ? String.format("update %s set deleted=1 where id=%d", table, id) : String.format("delete from  %s where id=%d", table, id);
            this.st.executeUpdate(this.sql);
        }
        this.sync.get(syncType).clear();
    }
}

