/*
 * Decompiled with CFR 0.152.
 */
package promauto.jroboplc.plugin.peripherial;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import promauto.jroboplc.core.api.Plugin;
import promauto.jroboplc.core.api.Tag;
import promauto.jroboplc.core.tags.TagRW;
import promauto.jroboplc.plugin.peripherial.PeripherialModule;
import promauto.jroboplc.plugin.peripherial.ProtocolModbus;

public class DeltaVFDMModule
extends PeripherialModule {
    private final Logger logger = LoggerFactory.getLogger(DeltaVFDMModule.class);
    protected ProtocolModbus protocol = new ProtocolModbus(this);
    protected TagRW tagReg2000;
    protected TagRW tagReg2001;
    protected TagRW tagReg2002;
    protected Tag tagReg2100;
    protected Tag tagReg2101;
    protected Tag tagReg2102;
    protected Tag tagReg2103;
    protected Tag tagReg2104;
    protected Tag tagReg2105;
    protected Tag tagReg2106;
    protected Tag tagReg2107;
    protected Tag tagReg2108;
    protected Tag tagReg2109;
    protected Tag tagReg210A;
    protected Tag tagReg210B;
    protected Tag tagReg210C;
    protected Tag tagReg210D;

    public DeltaVFDMModule(Plugin plugin, String name) {
        super(plugin, name);
    }

    @Override
    public boolean loadPeripherialModule(Object conf) {
        this.tagReg2000 = this.protocol.addWriteTag(8192, this.tagtable.createRWInt("Reg.R2000", 0, 8));
        this.tagReg2001 = this.protocol.addWriteTag(8193, this.tagtable.createRWInt("Reg.R2001", 0, 8));
        this.tagReg2002 = this.protocol.addWriteTag(8194, this.tagtable.createRWInt("Reg.R2002", 0, 8));
        this.tagReg2100 = this.tagtable.createInt("Reg.R2100", 0, 8);
        this.tagReg2101 = this.tagtable.createInt("Reg.R2101", 0, 8);
        this.tagReg2102 = this.tagtable.createInt("Reg.R2102", 0, 8);
        this.tagReg2103 = this.tagtable.createInt("Reg.R2103", 0, 8);
        this.tagReg2104 = this.tagtable.createInt("Reg.R2104", 0, 8);
        this.tagReg2105 = this.tagtable.createInt("Reg.R2105", 0, 8);
        this.tagReg2106 = this.tagtable.createInt("Reg.R2106", 0, 8);
        this.tagReg2107 = this.tagtable.createInt("Reg.R2107", 0, 8);
        this.tagReg2108 = this.tagtable.createInt("Reg.R2108", 0, 8);
        this.tagReg2109 = this.tagtable.createInt("Reg.R2109", 0, 8);
        this.tagReg210A = this.tagtable.createInt("Reg.R210A", 0, 8);
        this.tagReg210B = this.tagtable.createInt("Reg.R210B", 0, 8);
        this.tagReg210C = this.tagtable.createInt("Reg.R210C", 0, 8);
        this.tagReg210D = this.tagtable.createInt("Reg.R210D", 0, 8);
        return true;
    }

    @Override
    public boolean executePeripherialModule() {
        if (this.emulated) {
            this.tagReg2000.acceptWriteValue();
            this.tagReg2001.acceptWriteValue();
            this.tagReg2002.acceptWriteValue();
            return true;
        }
        boolean result = true;
        try {
            result = this.protocol.sendWriteTags(16);
            if (result && (result = this.protocol.requestCmd3(8192, 3))) {
                this.tagReg2000.setReadValInt(this.protocol.getAnswerWord(0));
                this.tagReg2001.setReadValInt(this.protocol.getAnswerWord(1));
                this.tagReg2002.setReadValInt(this.protocol.getAnswerWord(2));
            }
            if (result && (result = this.protocol.requestCmd3(8448, 14))) {
                this.tagReg2100.setInt(this.protocol.getAnswerWord(0));
                this.tagReg2101.setInt(this.protocol.getAnswerWord(1));
                this.tagReg2102.setInt(this.protocol.getAnswerWord(2));
                this.tagReg2103.setInt(this.protocol.getAnswerWord(3));
                this.tagReg2104.setInt(this.protocol.getAnswerWord(4));
                this.tagReg2105.setInt(this.protocol.getAnswerWord(5));
                this.tagReg2106.setInt(this.protocol.getAnswerWord(6));
                this.tagReg2107.setInt(this.protocol.getAnswerWord(7));
                this.tagReg2108.setInt(this.protocol.getAnswerWord(8));
                this.tagReg2109.setInt(this.protocol.getAnswerWord(9));
                this.tagReg210A.setInt(this.protocol.getAnswerWord(10));
                this.tagReg210B.setInt(this.protocol.getAnswerWord(11));
                this.tagReg210C.setInt(this.protocol.getAnswerWord(12));
                this.tagReg210D.setInt(this.protocol.getAnswerWord(13));
            }
        }
        catch (Exception e) {
            this.env.printError(this.logger, e, this.name);
            result = false;
        }
        return result;
    }
}

