/*
 * Decompiled with CFR 0.152.
 */
package promauto.jroboplc.plugin.peripherial;

import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import promauto.jroboplc.core.api.Plugin;
import promauto.jroboplc.core.api.Tag;
import promauto.jroboplc.plugin.peripherial.PeripherialModule;
import promauto.jroboplc.plugin.peripherial.ProtocolIcpcon;
import promauto.utils.Numbers;

public class I7024Module
extends PeripherialModule {
    private final Logger logger = LoggerFactory.getLogger(I7024Module.class);
    protected ProtocolIcpcon protocol = new ProtocolIcpcon(this);
    private static final int OUT_SIZE = 4;
    protected Output[] outputs = new Output[4];
    private int[] buffout = new int[16];
    private int[] buffin = new int[24];

    public I7024Module(Plugin plugin, String name) {
        super(plugin, name);
    }

    @Override
    public boolean loadPeripherialModule(Object conf) {
        this.initTags();
        return true;
    }

    protected void initTags() {
        for (int i = 0; i < 4; ++i) {
            String out = "out" + i + ".";
            this.outputs[i] = new Output();
            this.outputs[i].value = this.tagtable.createInt(out + "value", 0, 8);
            this.outputs[i].valsp = this.tagtable.createInt(out + "valsp", 0, 8);
            this.outputs[i].initiated = false;
        }
    }

    @Override
    protected void initChannelMap(List<String> chtags) {
        for (int i = 0; i < 4; ++i) {
            this.addChannelMapTag(chtags, this.outputs[i].value, "" + i);
            this.addChannelMapTag(chtags, this.outputs[i].valsp, "sp" + i);
        }
    }

    @Override
    public boolean executePeripherialModule() {
        if (this.emulated) {
            for (int i = 0; i < 4; ++i) {
                Output output = this.outputs[i];
                output.value.setInt(output.valsp.getInt());
            }
            return true;
        }
        boolean result = true;
        try {
            for (int i = 0; i < 4; ++i) {
                Output output = this.outputs[i];
                if (output.initiated && output.value.getInt() != output.valsp.getInt()) {
                    this.buffout[0] = 35;
                    Numbers.intToHexByte(this.netaddr, this.buffout, 1);
                    this.buffout[3] = Numbers.hexDigit[i];
                    this.buffout[4] = 43;
                    int v = output.valsp.getInt();
                    this.buffout[5] = Numbers.hexDigit[(v %= 100000) / 10000];
                    this.buffout[6] = Numbers.hexDigit[(v %= 10000) / 1000];
                    this.buffout[7] = 46;
                    this.buffout[8] = Numbers.hexDigit[(v %= 1000) / 100];
                    this.buffout[9] = Numbers.hexDigit[(v %= 100) / 10];
                    this.buffout[10] = Numbers.hexDigit[v %= 10];
                    result = this.protocol.request(this.buffout, 11, this.buffin, 4) == 4;
                }
                this.buffout[0] = 36;
                Numbers.intToHexByte(this.netaddr, this.buffout, 1);
                this.buffout[3] = 56;
                this.buffout[4] = Numbers.hexDigit[i];
                if (result) {
                    boolean bl = result = this.protocol.request(this.buffout, 5, this.buffin, 13) == 13;
                }
                if (result) {
                    int value = Numbers.asciiDigitToInt(this.buffin[4]) * 10000 + Numbers.asciiDigitToInt(this.buffin[5]) * 1000 + Numbers.asciiDigitToInt(this.buffin[7]) * 100 + Numbers.asciiDigitToInt(this.buffin[8]) * 10 + Numbers.asciiDigitToInt(this.buffin[9]);
                    if (this.buffin[3] == 45) {
                        value = -value;
                    }
                    if (output.initiated && Math.abs(output.valsp.getInt() - value) == 1) {
                        value = output.valsp.getInt();
                    }
                    output.value.setInt(value);
                    if (output.initiated) continue;
                    output.valsp.setDouble(value);
                    output.initiated = true;
                    continue;
                }
                break;
            }
        }
        catch (Exception e) {
            this.env.printError(this.logger, e, this.name);
        }
        return result;
    }

    protected static class Output {
        public Tag value;
        public Tag valsp;
        public boolean initiated;

        protected Output() {
        }
    }
}

