/*
 * Decompiled with CFR 0.152.
 */
package promauto.jroboplc.plugin.peripherial;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import promauto.jroboplc.core.api.Plugin;
import promauto.jroboplc.core.api.Tag;
import promauto.jroboplc.core.tags.TagRW;
import promauto.jroboplc.plugin.peripherial.PeripherialModule;
import promauto.jroboplc.plugin.peripherial.ProtocolModbus;

public class InnoVertISDModule
extends PeripherialModule {
    private final Logger logger = LoggerFactory.getLogger(InnoVertISDModule.class);
    protected ProtocolModbus protocol = new ProtocolModbus(this);
    protected Tag tagR0001;
    protected Tag tagR0002;
    protected Tag tagR0003;
    protected Tag tagR0004;
    protected Tag tagR0005;
    protected Tag tagR0007;
    protected Tag tagR0008;
    protected Tag tagR0010;
    protected Tag tagR0015;
    protected Tag tagR0016;
    protected Tag tagR0017;
    protected TagRW tagR2001;
    protected TagRW tagR2000;

    public InnoVertISDModule(Plugin plugin, String name) {
        super(plugin, name);
    }

    @Override
    public boolean loadPeripherialModule(Object conf) {
        this.tagR0001 = this.tagtable.createInt("Reg.R0001", 0, 8);
        this.tagR0002 = this.tagtable.createInt("Reg.R0002", 0, 8);
        this.tagR0003 = this.tagtable.createInt("Reg.R0003", 0, 8);
        this.tagR0004 = this.tagtable.createInt("Reg.R0004", 0, 8);
        this.tagR0005 = this.tagtable.createInt("Reg.R0005", 0, 8);
        this.tagR0007 = this.tagtable.createInt("Reg.R0007", 0, 8);
        this.tagR0008 = this.tagtable.createInt("Reg.R0008", 0, 8);
        this.tagR0010 = this.tagtable.createInt("Reg.R0010", 0, 8);
        this.tagR0015 = this.tagtable.createInt("Reg.R0015", 0, 8);
        this.tagR0016 = this.tagtable.createInt("Reg.R0016", 0, 8);
        this.tagR0017 = this.tagtable.createInt("Reg.R0017", 0, 8);
        this.tagR2000 = this.protocol.addWriteTag(8192, this.tagtable.createRWInt("Reg.R2000", 0, 8));
        this.tagR2001 = this.protocol.addWriteTag(8193, this.tagtable.createRWInt("Reg.R2001", 0, 8));
        return true;
    }

    @Override
    public boolean executePeripherialModule() {
        if (this.emulated) {
            this.tagR2000.acceptWriteValue();
            this.tagR2001.acceptWriteValue();
            return true;
        }
        boolean result = true;
        try {
            result = this.protocol.sendWriteTags(6);
            if (result && (result = this.protocol.requestCmd3(1, 8))) {
                this.tagR0001.setInt(this.protocol.getAnswerWord(0));
                this.tagR0002.setInt(this.protocol.getAnswerWord(1));
                this.tagR0003.setInt(this.protocol.getAnswerWord(2));
                this.tagR0004.setInt(this.protocol.getAnswerWord(3));
                this.tagR0005.setInt(this.protocol.getAnswerWord(4));
                this.tagR0007.setInt(this.protocol.getAnswerWord(5));
                this.tagR0008.setInt(this.protocol.getAnswerWord(6));
                this.tagR0010.setInt(this.protocol.getAnswerWord(7));
            }
            if (result = this.protocol.requestCmd3(15, 3)) {
                this.tagR0015.setInt(this.protocol.getAnswerWord(0));
                this.tagR0016.setInt(this.protocol.getAnswerWord(1));
                this.tagR0017.setInt(this.protocol.getAnswerWord(2));
            }
            if (result = this.protocol.requestCmd3(8192, 1)) {
                this.tagR2000.setReadValInt(this.protocol.getAnswerWord(0));
            }
            if (result = this.protocol.requestCmd3(8193, 1)) {
                this.tagR2001.setReadValInt(this.protocol.getAnswerWord(0));
            }
        }
        catch (Exception e) {
            this.env.printError(this.logger, e, this.name);
            result = false;
        }
        return result;
    }
}

