/*
 * Decompiled with CFR 0.152.
 */
package promauto.jroboplc.plugin.peripherial;

import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import promauto.jroboplc.core.api.Configuration;
import promauto.jroboplc.core.api.Plugin;
import promauto.jroboplc.core.api.Tag;
import promauto.jroboplc.core.tags.TagRW;
import promauto.jroboplc.plugin.peripherial.PeripherialModule;
import promauto.jroboplc.plugin.peripherial.ProtocolAscii;
import promauto.utils.Numbers;

public class KiprBos1Module
extends PeripherialModule {
    private static final Charset CHARSET_WIN1251 = Charset.forName("windows-1251");
    public static final int STATUS_OK = 0;
    public static final int STATUS_ERROR = 1;
    public static final int STATUS_BROKEN = 2;
    public static final int STATUS_SHORT_CIRCUIT = 3;
    public static final int STATUS_BAD_NUMBER = 4;
    public static final int STATUS_REQUEST_ERROR = 5;
    private final Logger logger = LoggerFactory.getLogger(KiprBos1Module.class);
    protected ProtocolAscii protocol = new ProtocolAscii(this);
    protected List<Sensor> sensors = new LinkedList<Sensor>();
    private TagRW tagCounter;
    private final ProtocolAscii.CheckAnswerFunc checkAnswer = size -> {
        boolean res = this.protocol.buffin[0] == 28 && this.protocol.buffin[11] == 13 && this.protocol.buffin[12] == 10 && this.protocol.buffin[13] == 28 && this.protocol.buffin[24] == 13 && this.protocol.buffin[25] == 10;
        int crc = this.calcCrc(this.protocol.buffin, 1, 9);
        res &= this.protocol.buffin[9] == 48 + (crc >> 4);
        res &= this.protocol.buffin[10] == 48 + (crc & 0xF);
        crc = this.calcCrc(this.protocol.buffin, 14, 22);
        res &= this.protocol.buffin[22] == 48 + (crc >> 4);
        return res &= this.protocol.buffin[23] == 48 + (crc & 0xF);
    };

    public KiprBos1Module(Plugin plugin, String name) {
        super(plugin, name);
        this.protocol.adjustBuffers(14, 26);
    }

    @Override
    public boolean loadPeripherialModule(Object conf) {
        Configuration cm = this.env.getConfiguration();
        for (Object confBuilding : cm.toList(cm.get(conf, "buildings"))) {
            int buildingAddr = cm.get(confBuilding, "addr", 0);
            String buildingName = cm.get(confBuilding, "name", "" + buildingAddr);
            for (Object confBox : cm.toList(cm.get(confBuilding, "boxes"))) {
                int boxAddr = cm.get(confBox, "addr", 0);
                String boxName = cm.get(confBox, "name", "" + boxAddr);
                for (Object confProbe : cm.toList(cm.get(confBox, "probes"))) {
                    int probeSize = cm.get(confProbe, "size", 0);
                    int probeType = cm.get(confProbe, "type", 0);
                    int probeAddr = cm.get(confProbe, "addr", 0);
                    String probeName = cm.get(confProbe, "name", "" + probeAddr);
                    for (int i = 0; i < probeSize; ++i) {
                        Sensor sensor = new Sensor();
                        sensor.building = buildingAddr;
                        sensor.box = boxAddr;
                        sensor.probe = probeAddr;
                        sensor.probeType = probeType;
                        sensor.num = i + 1;
                        String tagname = String.format("%s_%s_%s_%d.", buildingName, boxName, probeName, sensor.num);
                        sensor.tagValue = this.tagtable.createRWInt(tagname + "T", 0, 8);
                        sensor.tagStatus = this.tagtable.createRWInt(tagname + "status", 0);
                        sensor.tagAnswer = this.tagtable.createRWString(tagname + "answer", "");
                        this.sensors.add(sensor);
                    }
                }
            }
        }
        this.tagCounter = this.tagtable.createRWInt("Counter", 0);
        return true;
    }

    @Override
    protected void initChannelMap(List<String> chtags) {
    }

    @Override
    public boolean executePeripherialModule() {
        if (this.emulated) {
            this.sensors.forEach(sensor -> {
                sensor.tagValue.acceptWriteValue();
                sensor.tagStatus.acceptWriteValue();
                sensor.tagAnswer.acceptWriteValue();
            });
            return true;
        }
        this.tagCounter.setReadValInt(0);
        boolean result = true;
        try {
            for (Sensor sensor2 : this.sensors) {
                this.protocol.buffout[0] = 26;
                Numbers.intToAsciiByte(sensor2.building, this.protocol.buffout, 1);
                Numbers.intToAsciiByte(sensor2.box, this.protocol.buffout, 3);
                Numbers.intToAsciiByte(sensor2.probe, this.protocol.buffout, 5);
                Numbers.intToAsciiByte(sensor2.num, this.protocol.buffout, 7);
                this.protocol.buffout[9] = sensor2.probeType + 48;
                int crc = this.calcCrc(this.protocol.buffout, 1, 10);
                this.protocol.buffout[10] = 48 + (crc >> 4);
                this.protocol.buffout[11] = 48 + (crc & 0xF);
                this.protocol.buffout[12] = 13;
                this.protocol.buffout[13] = 10;
                Arrays.fill(this.protocol.buffin, 0);
                result = this.protocol.request(14, 26, this.checkAnswer);
                int status = 0;
                if (result) {
                    byte[] bb = new byte[8];
                    for (int i = 0; i < 8; ++i) {
                        bb[i] = (byte)(this.protocol.buffin[i + 14] & 0xFF);
                    }
                    String answer = new String(bb, CHARSET_WIN1251);
                    sensor2.tagAnswer.setReadValString(answer);
                    String value = answer.substring(2, 8).trim();
                    if (value.equals("\u041e\u0428\u0418\u0411\u041a\u0410")) {
                        status = 1;
                    } else if (value.equals("\u041e\u0411\u0420\u042b\u0412")) {
                        status = 2;
                    } else if (value.equals("\u041a.\u0417.")) {
                        status = 3;
                    } else {
                        try {
                            long t = Math.round(Double.parseDouble(value) * 10.0);
                            sensor2.tagValue.setReadValLong(t);
                        }
                        catch (NumberFormatException e) {
                            status = 4;
                        }
                    }
                    sensor2.tagValue.setStatus(Tag.Status.Good);
                } else {
                    status = 5;
                    sensor2.tagValue.setStatus(Tag.Status.Bad);
                }
                sensor2.tagStatus.setReadValInt(status);
                this.tagCounter.setReadValInt(this.tagCounter.getInt() + 1);
                if (!Thread.interrupted()) continue;
                break;
            }
        }
        catch (Exception e) {
            this.env.printError(this.logger, e, this.name);
            result = false;
        }
        return true;
    }

    private int calcCrc(int[] buff, int from, int to) {
        int crc = 0;
        for (int i = from; i < to; ++i) {
            crc ^= buff[i];
        }
        return crc & 0xFF;
    }

    @Override
    protected boolean reload() {
        KiprBos1Module tmp = new KiprBos1Module(this.plugin, this.name);
        if (!tmp.load()) {
            return false;
        }
        this.copySettingsFrom(tmp);
        this.sensors.forEach(sensor -> {
            this.tagtable.remove(sensor.tagAnswer);
            this.tagtable.remove(sensor.tagStatus);
            this.tagtable.remove(sensor.tagValue);
        });
        tmp.sensors.forEach(sensor -> {
            this.tagtable.add(sensor.tagAnswer);
            this.tagtable.add(sensor.tagStatus);
            this.tagtable.add(sensor.tagValue);
        });
        this.sensors = tmp.sensors;
        return true;
    }

    private static class Sensor {
        int building;
        int box;
        int probe;
        int probeType;
        int num;
        TagRW tagValue;
        TagRW tagStatus;
        TagRW tagAnswer;

        private Sensor() {
        }
    }
}

